/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class Interpolation {
    private Interpolation() {
    }

    public static double linear(double d, double d2, double d3, double d4, double d5) {
        if (d3 - d2 == 0.0) {
            return (d4 + d5) / 2.0;
        }
        return d4 + (d - d2) * (d5 - d4) / (d3 - d2);
    }

    public static double lagrange(double d, double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        double d2 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (d - dArray[i] == 0.0) {
                return d;
            }
            double d3 = dArray2[i];
            for (int j = 0; j < n; ++j) {
                if (i == j || dArray[i] - dArray[j] == 0.0) continue;
                d3 *= (d - dArray[i]) / (dArray[i] - dArray[j]);
            }
            d2 += d3;
        }
        return d2;
    }
}

