/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Fehlberg8
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] rate7;
    private double[] rate8;
    private double[] rate9;
    private double[] rate10;
    private double[] rate11;
    private double[] rate12;
    private double[] rate13;
    private double[] estimated_state;

    public Fehlberg8(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.rate4 = new double[this.numEqn];
        this.rate5 = new double[this.numEqn];
        this.rate6 = new double[this.numEqn];
        this.rate7 = new double[this.numEqn];
        this.rate8 = new double[this.numEqn];
        this.rate9 = new double[this.numEqn];
        this.rate10 = new double[this.numEqn];
        this.rate11 = new double[this.numEqn];
        this.rate12 = new double[this.numEqn];
        this.rate13 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    public double step() {
        int n;
        double[] dArray = this.ode.getState();
        if (dArray == null) {
            return this.stepSize;
        }
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(dArray, this.rate1);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * 2.0 / 27.0 * this.rate1[n];
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (this.rate1[n] + 3.0 * this.rate2[n]) / 36.0;
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (this.rate1[n] + 3.0 * this.rate3[n]) / 24.0;
        }
        this.ode.getRate(this.estimated_state, this.rate4);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (0.4166666666666667 * this.rate1[n] - 1.5625 * this.rate3[n] + 1.5625 * this.rate4[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate5);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (this.rate1[n] + 5.0 * this.rate4[n] + 4.0 * this.rate5[n]) / 20.0;
        }
        this.ode.getRate(this.estimated_state, this.rate6);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (-25.0 * this.rate1[n] + 125.0 * this.rate4[n] - 260.0 * this.rate5[n] + 250.0 * this.rate6[n]) / 108.0;
        }
        this.ode.getRate(this.estimated_state, this.rate7);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (0.10333333333333333 * this.rate1[n] + 0.27111111111111114 * this.rate5[n] - 0.2222222222222222 * this.rate6[n] + 0.014444444444444444 * this.rate7[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate8);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (2.0 * this.rate1[n] - 8.833333333333334 * this.rate4[n] + 15.644444444444444 * this.rate5[n] - 11.88888888888889 * this.rate6[n] + 0.7444444444444445 * this.rate7[n] + 3.0 * this.rate8[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate9);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (-0.8425925925925926 * this.rate1[n] + 0.21296296296296297 * this.rate4[n] - 7.229629629629629 * this.rate5[n] + 5.7592592592592595 * this.rate6[n] - 0.31666666666666665 * this.rate7[n] + 2.8333333333333335 * this.rate8[n] - this.rate9[n] / 12.0);
        }
        this.ode.getRate(this.estimated_state, this.rate10);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (0.5812195121951219 * this.rate1[n] - 2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] - 3.6707317073170733 * this.rate6[n] + 0.5202439024390244 * this.rate7[n] + 0.5487804878048781 * this.rate8[n] + 0.27439024390243905 * this.rate9[n] + 0.43902439024390244 * this.rate10[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate11);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (0.014634146341463415 * this.rate1[n] - 0.14634146341463414 * this.rate6[n] - 0.014634146341463415 * this.rate7[n] - 0.07317073170731707 * this.rate8[n] + 0.07317073170731707 * this.rate9[n] + 0.14634146341463414 * this.rate10[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate12);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (-0.43341463414634146 * this.rate1[n] - 2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] - 3.524390243902439 * this.rate6[n] + 0.5348780487804878 * this.rate7[n] + 0.6219512195121951 * this.rate8[n] + 0.20121951219512196 * this.rate9[n] + 0.2926829268292683 * this.rate10[n] + this.rate12[n]);
        }
        this.ode.getRate(this.estimated_state, this.rate13);
        for (n = 0; n < this.numEqn; ++n) {
            dArray[n] = dArray[n] + this.stepSize * (0.3238095238095238 * this.rate6[n] + 0.2571428571428571 * this.rate7[n] + 0.2571428571428571 * this.rate8[n] + 0.03214285714285714 * this.rate9[n] + 0.03214285714285714 * this.rate10[n] + 0.04880952380952381 * this.rate12[n] + 0.04880952380952381 * this.rate13[n]);
        }
        return this.stepSize;
    }
}

