/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Interpolation;
import org.opensourcephysics.numerics.Util;

public class CubicSpline
implements Function {
    private double startDerivative = Double.NaN;
    private double endDerivative = Double.NaN;
    private int guessIndex = 1;
    double[] xd;
    double[] yd;
    double[] coefficients;
    int sign;

    public CubicSpline(double[] dArray, double[] dArray2) {
        this.update(dArray, dArray2);
    }

    public void update(double[] dArray, double[] dArray2) {
        if (this.xd == null || this.xd.length != dArray.length) {
            this.xd = (double[])dArray.clone();
        } else {
            System.arraycopy(dArray, 0, this.xd, 0, this.xd.length);
        }
        if (this.yd == null || this.yd.length != dArray2.length) {
            this.yd = (double[])dArray2.clone();
        } else {
            System.arraycopy(dArray2, 0, this.yd, 0, this.yd.length);
        }
        if (this.xd.length != this.yd.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        this.sign = Util.checkSorting(this.xd);
        if (this.sign == 0) {
            throw new IllegalArgumentException("X array must be sorted in either increasing or decreasing order.");
        }
        if (this.xd.length > 2) {
            this.computeSecondDerivatives();
        }
    }

    public double evaluate(double d) {
        int n = 0;
        int n2 = this.xd.length - 1;
        if (n2 < 1) {
            return this.yd[0];
        }
        if (n2 == 1) {
            return Interpolation.linear(d, this.xd[0], this.xd[1], this.yd[0], this.yd[1]);
        }
        if ((double)this.sign * d < (double)this.sign * this.xd[1]) {
            n2 = 1;
        } else if ((double)this.sign * d > (double)this.sign * this.xd[n2 - 1]) {
            n = n2 - 1;
        } else {
            if (this.guessIndex > 0 && (double)this.sign * d > (double)this.sign * this.xd[this.guessIndex - 1]) {
                n = this.guessIndex - 1;
            }
            if (this.guessIndex < n2 && (double)this.sign * d < (double)this.sign * this.xd[this.guessIndex + 1]) {
                n2 = this.guessIndex + 1;
            }
        }
        while (n2 - n > 1) {
            int n3 = (n + n2) / 2;
            if ((double)this.sign * this.xd[n3] > (double)this.sign * d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        this.guessIndex = n;
        double d2 = this.xd[n2] - this.xd[n];
        double d3 = (this.xd[n2] - d) / d2;
        double d4 = (d - this.xd[n]) / d2;
        return d3 * this.yd[n] + d4 * this.yd[n2] + (d3 * (d3 * d3 - 1.0) * this.coefficients[n] + d4 * (d4 * d4 - 1.0) * this.coefficients[n2]) * d2 * d2 / 6.0;
    }

    private void computeSecondDerivatives() {
        double d;
        double d2;
        int n;
        int n2 = this.xd.length;
        double[] dArray = new double[n2 - 1];
        this.coefficients = new double[n2];
        if (Double.isNaN(this.startDerivative)) {
            dArray[0] = 0.0;
            this.coefficients[0] = 0.0;
        } else {
            this.coefficients[0] = -0.5;
            dArray[0] = 3.0 / (this.xd[1] - this.xd[0]) * ((this.yd[1] - this.yd[0]) / (this.xd[1] - this.xd[0]) - this.startDerivative);
        }
        for (n = 1; n < n2 - 1; ++n) {
            double d3 = 1.0 / (this.xd[n + 1] - this.xd[n - 1]);
            d2 = (this.xd[n] - this.xd[n - 1]) * d3;
            d = 1.0 / (d2 * this.coefficients[n - 1] + 2.0);
            this.coefficients[n] = (d2 - 1.0) * d;
            dArray[n] = (6.0 * d3 * ((this.yd[n + 1] - this.yd[n]) / (this.xd[n + 1] - this.xd[n]) - (this.yd[n] - this.yd[n - 1]) / (this.xd[n] - this.xd[n - 1])) - d2 * dArray[n - 1]) * d;
        }
        if (Double.isNaN(this.endDerivative)) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d = -0.5;
            d2 = 3.0 / (this.xd[n2 - 1] - this.xd[n2 - 2]) * (this.endDerivative - (this.yd[n2 - 1] - this.yd[n2 - 2]) / (this.xd[n2 - 1] - this.xd[n2 - 2]));
        }
        this.coefficients[n2 - 1] = (d2 - d * dArray[n2 - 2]) / (d * this.coefficients[n2 - 2] + 1.0);
        for (n = n2 - 2; n >= 0; --n) {
            this.coefficients[n] = this.coefficients[n] * this.coefficients[n + 1] + dArray[n];
        }
    }
}

