/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class IntegerField
extends JTextField {
    private NumberFormat format = NumberFormat.getNumberInstance();
    private int prevValue = 0;
    private Integer maxValue;
    private Integer minValue;

    public IntegerField(int n) {
        super(n);
        this.format.setParseIntegerOnly(true);
        this.setValue(this.prevValue);
    }

    public int getValue() {
        int n;
        try {
            n = this.format.parse(this.getText()).intValue();
            if (this.minValue != null && n < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && n > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return n;
    }

    public void setValue(int n) {
        if (this.minValue != null) {
            n = Math.max(n, this.minValue);
        }
        if (this.maxValue != null) {
            n = Math.min(n, this.maxValue);
        }
        this.setText(this.format.format(n));
        this.prevValue = n;
    }

    public void setMinValue(int n) {
        this.minValue = new Integer(n);
    }

    public void setMaxValue(int n) {
        this.maxValue = new Integer(n);
    }
}

