/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class TableData
extends AbstractTableModel {
    ArrayList rowList = new ArrayList();
    ArrayList colNames = new ArrayList();
    ArrayList formats = new ArrayList();
    boolean[] columnVisibilities = new boolean[1];
    boolean rowNumberVisible = true;
    int colCount = 0;
    int maxRows = -1;

    public TableData() {
        this.columnVisibilities[0] = true;
    }

    public void setMaxPoints(int n) {
        int n2;
        this.maxRows = n;
        if (this.maxRows <= 0 || this.rowList.size() <= n) {
            return;
        }
        int n3 = this.rowList.size() - n;
        for (n2 = 0; n2 < n3; ++n2) {
            this.rowList.remove(0);
        }
        this.colCount = 0;
        n3 = this.rowList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object e = this.rowList.get(n2);
            if (!e.getClass().isArray()) continue;
            int n4 = 0;
            if (e instanceof double[]) {
                n4 = ((double[])e).length;
            } else if (e instanceof byte[]) {
                n4 = ((byte[])e).length;
            } else if (e instanceof int[]) {
                n4 = ((int[])e).length;
            } else if (e instanceof String[]) {
                n4 = ((String[])e).length;
            }
            this.colCount = Math.max(this.colCount, n4);
        }
    }

    public void clear() {
        this.rowList.clear();
        this.colCount = 0;
    }

    public synchronized void appendRow(Object object) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("A TableData row must be an array.");
        }
        Class<?> clazz = object.getClass().getComponentType();
        String string = clazz.getName();
        if (string.equals("double")) {
            this.appendDoubles((double[])object);
        } else if (string.equals("int")) {
            this.appendInts((int[])object);
        } else if (string.equals("byte")) {
            this.appendBytes((byte[])object);
        } else if (string.equals("string")) {
            this.appendStrings((String[])object);
        } else {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            this.appendStrings(stringArray);
        }
    }

    void appendDoubles(double[] dArray) {
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(dArray2);
        this.colCount = Math.max(this.colCount, dArray2.length + 1);
    }

    void appendInts(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(nArray2);
        this.colCount = Math.max(this.colCount, nArray2.length + 1);
    }

    void appendBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(byArray2);
        this.colCount = Math.max(this.colCount, byArray2.length + 1);
    }

    void appendStrings(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(stringArray2);
        this.colCount = Math.max(this.colCount, stringArray2.length + 1);
    }

    public void setColumnVisible(int n, boolean bl) {
        this.ensureCapacity(n + 1);
        this.columnVisibilities[n] = bl;
    }

    public void setRowNumberVisible(boolean bl) {
        this.rowNumberVisible = bl;
    }

    public void setColumnNames(int n, String string) {
        while (n >= this.colNames.size()) {
            this.colNames.add("" + (char)(65 + n));
        }
        this.colNames.set(n, string);
    }

    public void setColumnFormat(int n, String string) {
        while (n >= this.formats.size()) {
            this.formats.add(null);
        }
        this.formats.set(n, new DecimalFormat(string));
    }

    public DecimalFormat getColumnFormat(int n) {
        int n2 = Math.min(n, this.columnVisibilities.length);
        for (int i = 0; i < n2; ++i) {
            if (this.columnVisibilities[i]) continue;
            ++n;
        }
        if (n <= this.formats.size()) {
            return (DecimalFormat)this.formats.get(n - 1);
        }
        return null;
    }

    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int n = this.rowNumberVisible ? this.colCount : this.colCount - 1;
        int n2 = Math.min(n, this.columnVisibilities.length);
        for (int i = 0; i < n2; ++i) {
            if (this.columnVisibilities[i]) continue;
            --n;
        }
        return n;
    }

    public String getColumnName(int n) {
        if (n == 0 && this.rowNumberVisible) {
            return "row #";
        }
        if (!this.rowNumberVisible) {
            ++n;
        }
        int n2 = Math.min(n, this.columnVisibilities.length);
        for (int i = 0; i < n2; ++i) {
            if (this.columnVisibilities[i]) continue;
            ++n;
        }
        if (n <= this.colNames.size()) {
            return (String)this.colNames.get(n - 1);
        }
        return "" + (char)(65 + n);
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0 && this.rowNumberVisible) {
            return new Integer(n);
        }
        if (!this.rowNumberVisible) {
            ++n2;
        }
        if (n >= this.rowList.size()) {
            return "";
        }
        Object e = this.rowList.get(n);
        if (!e.getClass().isArray()) {
            return "";
        }
        int n3 = Math.min(n2, this.columnVisibilities.length);
        for (int i = 0; i < n3; ++i) {
            if (this.columnVisibilities[i]) continue;
            ++n2;
        }
        if (e instanceof double[]) {
            double[] dArray = (double[])e;
            if (n2 > dArray.length) {
                return "";
            }
            DecimalFormat decimalFormat = this.getColumnFormat(n2);
            if (decimalFormat == null) {
                return new Double(dArray[n2 - 1]);
            }
            return decimalFormat.format(dArray[n2 - 1]);
        }
        if (e instanceof byte[]) {
            byte[] byArray = (byte[])e;
            if (n2 > byArray.length) {
                return "";
            }
            return new Byte(byArray[n2 - 1]);
        }
        if (e instanceof int[]) {
            int[] nArray = (int[])e;
            if (n2 > nArray.length) {
                return "";
            }
            return new Integer(nArray[n2 - 1]);
        }
        if (e instanceof String[]) {
            String[] stringArray = (String[])e;
            if (n2 > stringArray.length) {
                return "";
            }
            return stringArray[n2 - 1];
        }
        return "";
    }

    private void ensureCapacity(int n) {
        if (this.columnVisibilities == null) {
            this.columnVisibilities = new boolean[n * 3 / 2 + 1];
            Arrays.fill(this.columnVisibilities, true);
        } else if (this.columnVisibilities.length < n) {
            boolean[] blArray = this.columnVisibilities;
            this.columnVisibilities = new boolean[n * 3 / 2 + 1];
            System.arraycopy(blArray, 0, this.columnVisibilities, 0, blArray.length);
            Arrays.fill(this.columnVisibilities, blArray.length, this.columnVisibilities.length, true);
        }
    }
}

