/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;

public abstract class Value {
    public abstract boolean getBoolean();

    public abstract int getInteger();

    public abstract double getDouble();

    public abstract String getString();

    public abstract Object getObject();

    public void copyValue(Value value) {
        if (this instanceof DoubleValue) {
            ((DoubleValue)this).value = value.getDouble();
        } else if (this instanceof IntegerValue) {
            ((IntegerValue)this).value = value.getInteger();
        } else if (this instanceof BooleanValue) {
            ((BooleanValue)this).value = value.getBoolean();
        } else if (this instanceof StringValue) {
            ((StringValue)this).value = value.getString();
        } else if (this instanceof ObjectValue) {
            ((ObjectValue)this).value = value.getObject();
        }
    }

    public Value cloneValue() {
        if (this instanceof DoubleValue) {
            return new DoubleValue(this.getDouble());
        }
        if (this instanceof IntegerValue) {
            return new IntegerValue(this.getInteger());
        }
        if (this instanceof BooleanValue) {
            return new BooleanValue(this.getBoolean());
        }
        if (this instanceof StringValue) {
            return new StringValue(this.getString());
        }
        if (this instanceof ObjectValue) {
            return new ObjectValue(this.getObject());
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public static Value parseConstantOrArray(String string, boolean bl) {
        String string2 = string.trim();
        boolean bl2 = false;
        if (string2.startsWith("{") && string2.endsWith("}")) {
            string = string2.substring(1, string2.length() - 1);
            bl2 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (!bl2 && n <= 1) {
            return Value.parseConstant(string, bl);
        }
        Value[] valueArray = new Value[n];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Value.parseConstant(stringTokenizer.nextToken(), bl);
            if (valueArray[i] == null) {
                return Value.parseConstant(string, bl);
            }
            if (valueArray[i] instanceof DoubleValue) {
                bl3 = true;
                continue;
            }
            if (valueArray[i] instanceof IntegerValue) {
                bl4 = true;
                continue;
            }
            if (!(valueArray[i] instanceof BooleanValue)) continue;
            bl5 = true;
        }
        if (bl3) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = valueArray[i].getDouble();
            }
            return new ObjectValue(dArray);
        }
        if (bl4) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = valueArray[i].getInteger();
            }
            return new ObjectValue(nArray);
        }
        if (bl5) {
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = valueArray[i].getBoolean();
            }
            return new ObjectValue(blArray);
        }
        return Value.parseConstant(string, bl);
    }

    public static String removeScapes(String string) {
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i == n - 1) {
                    return string2 + c;
                }
                c = string.charAt(++i);
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static Value parseConstant(String string, boolean bl) {
        if ((string = string.trim()).length() <= 0) {
            return null;
        }
        if (string.equals("null")) {
            return new ObjectValue(null);
        }
        if (string.startsWith("\"")) {
            if (string.length() <= 1) {
                return null;
            }
            if (!string.endsWith("\"")) {
                return null;
            }
            return new StringValue(Value.removeScapes(string.substring(1, string.length() - 1)));
        }
        if (string.startsWith("'")) {
            if (!string.endsWith("'")) {
                return null;
            }
            return new StringValue(Value.removeScapes(string.substring(1, string.length() - 1)));
        }
        if (string.equals("true")) {
            return new BooleanValue(true);
        }
        if (string.equals("false")) {
            return new BooleanValue(false);
        }
        if (string.indexOf(46) >= 0) {
            try {
                double d = Double.parseDouble(string);
                return new DoubleValue(d);
            }
            catch (Exception exception) {
                if (!bl) {
                    System.err.println("Value : Error 2! Incorrect input to parse " + string);
                }
                return null;
            }
        }
        try {
            int n = Integer.parseInt(string);
            return new IntegerValue(n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

