/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTextField
extends ControlSwingElement {
    static final int TEXTFIELD_ADDED = 4;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    protected static final int BACKGROUND = 11;
    protected boolean inputError = false;
    protected JTextField textfield;
    protected StringValue internalValue;
    protected boolean defaultValueSet;
    protected String defaultValue;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    private static ArrayList infoList = null;

    public ControlTextField(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof JTextField) {
            this.textfield = (JTextField)object;
        } else {
            this.textfield = new JTextField();
            this.textfield.setText("");
        }
        this.defaultValue = this.textfield.getText();
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    protected int getVariableIndex() {
        return 0;
    }

    protected int getValueIndex() {
        return 1;
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String string) {
        if (this.internalValue.value != null && this.internalValue.value.equals(string)) {
            return;
        }
        this.internalValue.value = string;
        this.textfield.setText(this.internalValue.value);
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected void setInternalValue(String string) {
        this.internalValue.value = string;
        this.variableChanged(this.getVariableIndex(), this.internalValue);
        this.invokeActions();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("value")) {
            return "String CONSTANT TRANSLATABLE";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.textfield.setEditable(value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 11: {
                super.setValue(7, value);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 11: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }

    protected void setColor(Color color) {
        if (this.textfield.isEditable()) {
            this.getVisual().setBackground(color);
        }
    }

    protected void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private void acceptValue() {
        this.setInternalValue(this.textfield.getText());
        if (this.isUnderEjs) {
            this.setFieldListValueWithAlternative(this.getVariableIndex(), this.getValueIndex(), this.internalValue);
        }
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlTextField.this.textfield.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlTextField.this.setColor(ControlTextField.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlTextField.this.textfield.setText(ControlTextField.this.internalValue.value);
                ControlTextField.this.setColor(ControlTextField.this.defaultColor);
            }
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlTextField.this.textfield.isEditable()) {
                ControlTextField.this.acceptValue();
            }
        }
    }
}

