/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JPasswordField;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPasswordField
extends ControlSwingElement {
    protected static final int PASSWORD_ADDED = 4;
    protected static final int VARIABLE = 0;
    protected static final int BACKGROUND = 11;
    protected JPasswordField textfield;
    protected StringValue internalValue;
    private Color defaultColor;
    private Color editingColor;
    private static ArrayList infoList = null;

    public ControlPasswordField(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof JPasswordField) {
            this.textfield = (JPasswordField)object;
        } else {
            this.textfield = new JPasswordField();
            this.textfield.setText("");
        }
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.internalValue = new StringValue(new String(this.textfield.getPassword()));
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    private void setTheValue(String string) {
        if (this.internalValue.value != null && this.internalValue.value.equals(string)) {
            return;
        }
        this.internalValue.value = string;
        this.textfield.setText(this.internalValue.value);
        this.textfield.setCaretPosition(Math.max(string.length() - 1, 0));
        this.setColor(this.defaultColor);
    }

    protected void setInternalValue(String string) {
        this.internalValue.value = string;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("echoCharacter");
            infoList.add("editable");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("echoCharacter")) {
            return "String CONSTANT";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.textfield.setEchoChar(value.getString().charAt(0));
                break;
            }
            case 2: {
                this.textfield.setEditable(value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            default: {
                super.setValue(n - 4, value);
                break;
            }
            case 11: {
                super.setValue(7, value);
                this.decideColors(this.getVisual().getBackground());
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setTheValue("");
                break;
            }
            case 1: {
                this.textfield.setEchoChar('*');
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
                break;
            }
            case 11: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }

    private void setColor(Color color) {
        if (this.textfield.isEditable()) {
            this.getVisual().setBackground(color);
        }
    }

    private void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
    }

    private void acceptValue() {
        this.setInternalValue(new String(this.textfield.getPassword()));
        if (this.isUnderEjs) {
            this.setFieldListValue(0, this.internalValue);
        }
        this.setColor(this.defaultColor);
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlPasswordField.this.textfield.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlPasswordField.this.setColor(ControlPasswordField.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlPasswordField.this.textfield.setText(ControlPasswordField.this.internalValue.value);
                ControlPasswordField.this.setColor(ControlPasswordField.this.defaultColor);
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlPasswordField.this.textfield.isEditable()) {
                ControlPasswordField.this.acceptValue();
            }
        }
    }
}

