/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.opensourcephysics.ejs.Function;
import org.opensourcephysics.ejs.control.swing.ControlTextField;
import org.opensourcephysics.ejs.control.swing.FunctionTextField;
import org.opensourcephysics.ejs.control.value.ParserSuryono;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.numerics.SuryonoParser;

public class ControlFunction
extends ControlTextField {
    protected static final int FUNCTION_ADDED = 2;
    private static final int VARIABLE = 2;
    private static final int VALUE = 3;
    protected boolean useJavaSyntax;
    protected String variables;
    private Function theFunction;
    private static ArrayList infoList = null;
    protected ParserSuryono parser;
    protected SuryonoParser Bparser;
    protected String[] allVars;
    protected String[] indVars;

    public ControlFunction(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof FunctionTextField) {
            this.textfield = (FunctionTextField)object;
        } else {
            this.textfield = new FunctionTextField();
            this.textfield.setText("0");
        }
        this.defaultValue = this.textfield.getText();
        this.textfield.addActionListener(new ControlTextField.MyActionListener(this));
        this.textfield.addKeyListener(new ControlTextField.MyKeyListener(this));
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.textfield.getBackground());
        ((FunctionTextField)this.textfield).setControlFunction(this);
        this.useJavaSyntax = true;
        this.variables = "t";
        this.indVars = new String[]{this.variables};
        this.theFunction = new Function(){

            public double eval(double d) {
                return ControlFunction.this.evaluate(d);
            }
        };
        return this.textfield;
    }

    protected int getVariableIndex() {
        return 2;
    }

    protected int getValueIndex() {
        return 3;
    }

    protected void setInternalValue(String string) {
        this.setTheFunction(string);
        super.setInternalValue(string);
    }

    public Object getObject(String string) {
        if ("function".equals(string)) {
            return this.theFunction;
        }
        return null;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("javaSyntax");
            infoList.add("independent");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("javaSyntax")) {
            return "boolean PREVIOUS";
        }
        if (string.equals("variable")) {
            return "String PREVIOUS";
        }
        if (string.equals("independent")) {
            return "String PREVIOUS";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.useJavaSyntax = value.getBoolean();
                this.setTheFunction(this.internalValue.value);
                break;
            }
            case 1: {
                if (value.getString().equals(this.variables)) break;
                this.setTheVariables(value.getString());
                break;
            }
            case 2: {
                if (this.internalValue.value.equals(value.getString())) break;
                this.setTheFunction(value.getString());
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.useJavaSyntax = true;
                this.setTheFunction(this.internalValue.value);
                break;
            }
            case 1: {
                this.setTheVariables("t");
                break;
            }
            case 2: {
                this.setTheFunction("0");
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }

    boolean setTheVariables(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n = stringTokenizer.countTokens();
        this.indVars = new String[n];
        for (int i = 0; i < n; ++i) {
            this.indVars[i] = stringTokenizer.nextToken();
        }
        this.variables = string;
        return this.setTheFunction(this.internalValue.value);
    }

    boolean setTheFunction(String string) {
        int n;
        if (string == null) {
            return false;
        }
        Set set = null;
        this.inputError = false;
        if (this.myGroup != null) {
            set = this.myGroup.getVariablesSet();
            this.allVars = new String[this.indVars.length + set.size()];
            for (int i = 0; i < this.indVars.length; ++i) {
                this.allVars[i] = this.indVars[i];
            }
            Iterator iterator = set.iterator();
            n = this.indVars.length;
            while (iterator.hasNext()) {
                this.allVars[n++] = (String)iterator.next();
            }
        } else {
            this.allVars = new String[this.indVars.length];
            for (int i = 0; i < this.indVars.length; ++i) {
                this.allVars[i] = this.indVars[i];
            }
        }
        if (this.useJavaSyntax) {
            if (set == null) {
                this.allVars = ParserSuryono.getVariableList(string);
            }
            this.parser = new ParserSuryono(this.allVars.length);
            n = this.allVars.length;
            for (int i = 0; i < n; ++i) {
                this.parser.defineVariable(i, this.allVars[i]);
            }
            this.parser.define(string);
            this.parser.parse();
            this.inputError = this.parser.getErrorCode() != 0;
        } else {
            if (set != null) {
                this.Bparser = new SuryonoParser(this.allVars.length);
                n = this.allVars.length;
                for (int i = 0; i < n; ++i) {
                    this.Bparser.defineVariable(i + 1, this.allVars[i]);
                }
            } else {
                try {
                    this.Bparser = new SuryonoParser(0);
                    this.allVars = this.Bparser.parseUnknown(string);
                }
                catch (Exception exception) {
                    this.allVars = ParserSuryono.getVariableList(string);
                    this.Bparser = new SuryonoParser(this.allVars.length);
                    int n2 = this.allVars.length;
                    for (n = 0; n < n2; ++n) {
                        this.Bparser.defineVariable(n + 1, this.allVars[n]);
                    }
                }
            }
            this.Bparser.define(string);
            this.Bparser.parse();
            this.inputError = this.Bparser.getErrorCode() != 0;
        }
        this.internalValue.value = string;
        this.textfield.setText(this.internalValue.value);
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
        return !this.inputError;
    }

    public double evaluate(double d) {
        if (this.indVars.length != 1) {
            throw new UnsupportedOperationException();
        }
        if (this.useJavaSyntax) {
            this.parser.setVariable(0, d);
            if (this.myGroup != null) {
                int n = this.allVars.length;
                for (int i = 1; i < n; ++i) {
                    this.parser.setVariable(i, this.myGroup.getDouble(this.allVars[i]));
                }
            }
            return this.parser.evaluate();
        }
        this.Bparser.setVariable(1, d);
        if (this.myGroup != null) {
            int n = this.allVars.length;
            for (int i = 1; i < n; ++i) {
                this.Bparser.setVariable(i + 1, this.myGroup.getDouble(this.allVars[i]));
            }
        }
        return this.Bparser.evaluate();
    }

    public double evaluate(double[] dArray) {
        int n;
        if (this.indVars.length != dArray.length) {
            throw new UnsupportedOperationException();
        }
        int n2 = dArray.length;
        if (this.useJavaSyntax) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                this.parser.setVariable(n3, dArray[n3]);
            }
            if (this.myGroup != null) {
                int n4 = this.allVars.length;
                for (n3 = n2; n3 < n4; ++n3) {
                    this.parser.setVariable(n3, this.myGroup.getDouble(this.allVars[n3]));
                }
            }
            return this.parser.evaluate();
        }
        for (n = 0; n < n2; ++n) {
            this.Bparser.setVariable(n + 1, dArray[n]);
        }
        if (this.myGroup != null) {
            int n5 = this.allVars.length;
            for (n = n2; n < n2; ++n) {
                this.Bparser.setVariable(n + 1, this.myGroup.getDouble(this.allVars[n]));
            }
        }
        return this.Bparser.evaluate();
    }
}

