/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.ejs.control.ConstantParser;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.swing.MyCoordinateStringBuilder;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlDrawingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    public static final int DP_ADDED = 29;
    private static final int[] posIndex = new int[]{6, 7};
    private static final int KEY_INDEX = 17;
    protected boolean reportDrag = false;
    protected InteractivePanel drawingPanel;
    private Rectangle myGutters = null;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    protected MyCoordinateStringBuilder strBuilder;
    private static ArrayList infoList = null;
    private InteractionTarget targetHit = null;
    private InteractionSource sourceLingered = null;

    public ControlDrawingPanel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof InteractivePanel) {
            this.drawingPanel = (InteractivePanel)object;
        } else {
            this.drawingPanel = new InteractivePanel();
            this.drawingPanel.enableInspector(false);
            this.drawingPanel.setSquareAspect(false);
            this.drawingPanel.setBuffered(true);
        }
        this.drawingPanel.removeOptionController();
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.autoX = this.drawingPanel.isAutoscaleX();
        this.autoY = this.drawingPanel.isAutoscaleY();
        this.drawingPanel.render();
        this.drawingPanel.setInteractiveMouseHandler(this);
        this.strBuilder = new MyCoordinateStringBuilder();
        this.drawingPanel.setCoordinateStringBuilder(this.strBuilder);
        this.drawingPanel.setFocusable(true);
        this.drawingPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ((ControlDrawingPanel)ControlDrawingPanel.this).keyPressedValue.value = keyEvent.getKeyCode();
                ControlDrawingPanel.this.variableChanged(17, ControlDrawingPanel.this.keyPressedValue);
                ControlDrawingPanel.this.invokeActions(30);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ((ControlDrawingPanel)ControlDrawingPanel.this).keyPressedValue.value = -1;
                ControlDrawingPanel.this.variableChanged(17, ControlDrawingPanel.this.keyPressedValue);
            }
        });
        return this.drawingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("printTarget");
            infoList.add("xyExpression");
            infoList.add("xyFormat");
            infoList.add("xMarginPercentage");
            infoList.add("yMarginPercentage");
            infoList.add("TLmessage");
            infoList.add("TRmessage");
            infoList.add("BLmessage");
            infoList.add("BRmessage");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("square")) {
            return "squareAspect";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("autoscaleX")) {
            return "boolean";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("square")) {
            return "boolean";
        }
        if (string.equals("showCoordinates")) {
            return "boolean";
        }
        if (string.equals("gutters")) {
            return "Margins|Object";
        }
        if (string.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("keyPressed")) {
            return "int";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("printTarget")) {
            return "String";
        }
        if (string.equals("xyExpression")) {
            return "Object|String";
        }
        if (string.equals("xyFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("xMarginPercentage")) {
            return "int|double";
        }
        if (string.equals("yMarginPercentage")) {
            return "int|double";
        }
        if (string.equals("TLmessage")) {
            return "String";
        }
        if (string.equals("TRmessage")) {
            return "String";
        }
        if (string.equals("BLmessage")) {
            return "String";
        }
        if (string.equals("BRmessage")) {
            return "String";
        }
        return super.getPropertyInfo(string);
    }

    public ControlElement setProperty(String string, String string2) {
        if (((string = string.trim()).equals("x") || string.equals("y") || string.equals("dragaction")) && string2 != null) {
            Value value = Value.parseConstant(string2, true);
            if (!this.reportDrag) {
                this.reportDrag = value == null;
            }
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.autoX = value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 1: {
                this.autoY = value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 2: {
                if (value.getDouble() == this.minX && this.xminSet) break;
                this.minX = value.getDouble();
                this.xminSet = true;
                this.updateExtrema();
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxX && this.xmaxSet) break;
                this.maxX = value.getDouble();
                this.xmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 4: {
                if (value.getDouble() == this.minY && this.yminSet) break;
                this.minY = value.getDouble();
                this.yminSet = true;
                this.updateExtrema();
                break;
            }
            case 5: {
                if (value.getDouble() == this.maxY && this.ymaxSet) break;
                this.maxY = value.getDouble();
                this.ymaxSet = true;
                this.updateExtrema();
                break;
            }
            case 6: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 7: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(value.getBoolean());
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(value.getBoolean());
                break;
            }
            case 13: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myGutters) break;
                this.drawingPanel.setGutters(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myGutters = rectangle;
                break;
            }
            case 14: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setXFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setXFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 15: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setYFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setYFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 16: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, value.getString());
                break;
            }
            case 17: {
                this.keyPressedValue.value = value.getInteger();
                break;
            }
            case 18: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 19: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 20: {
                this.setPrintTarget(value.getString());
                break;
            }
            case 21: {
                this.strBuilder.setExpression(value.getString());
                break;
            }
            case 22: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setExpressionFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.strBuilder.setExpressionFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 23: {
                this.drawingPanel.setXMarginPercentage(value.getDouble());
                break;
            }
            case 24: {
                this.drawingPanel.setYMarginPercentage(value.getDouble());
                break;
            }
            case 25: {
                this.drawingPanel.setMessage(value.getString(), 3);
                break;
            }
            case 26: {
                this.drawingPanel.setMessage(value.getString(), 2);
                break;
            }
            case 27: {
                this.drawingPanel.setMessage(value.getString(), 0);
                break;
            }
            case 28: {
                this.drawingPanel.setMessage(value.getString(), 1);
                break;
            }
            default: {
                super.setValue(n - 29, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.autoX = false;
                this.updateAutoscale();
                break;
            }
            case 1: {
                this.autoY = false;
                this.updateAutoscale();
                break;
            }
            case 2: {
                this.minX = Double.NaN;
                this.xminSet = false;
                this.updateExtrema();
                break;
            }
            case 3: {
                this.maxX = Double.NaN;
                this.xmaxSet = false;
                this.updateExtrema();
                break;
            }
            case 4: {
                this.minY = Double.NaN;
                this.yminSet = false;
                this.updateExtrema();
                break;
            }
            case 5: {
                this.maxY = Double.NaN;
                this.ymaxSet = false;
                this.updateExtrema();
                break;
            }
            case 6: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 7: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(false);
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(true);
                break;
            }
            case 13: {
                this.drawingPanel.setGutters(0, 0, 0, 0);
                this.myGutters = null;
                break;
            }
            case 14: {
                this.strBuilder.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 15: {
                this.strBuilder.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 16: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 17: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 18: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 19: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 20: {
                this.setPrintTarget(null);
                break;
            }
            case 21: {
                this.strBuilder.setExpression(null);
                break;
            }
            case 22: {
                this.strBuilder.setXFormat(new DecimalFormat("0.000;-0.000"));
                break;
            }
            case 23: {
                this.drawingPanel.setXMarginPercentage(0.0);
                break;
            }
            case 24: {
                this.drawingPanel.setYMarginPercentage(0.0);
                break;
            }
            case 25: {
                this.drawingPanel.setMessage("", 3);
                break;
            }
            case 26: {
                this.drawingPanel.setMessage("", 2);
                break;
            }
            case 27: {
                this.drawingPanel.setMessage("", 0);
                break;
            }
            case 28: {
                this.drawingPanel.setMessage("", 1);
                break;
            }
            default: {
                super.setDefaultValue(n - 29);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return null;
            }
            case 6: {
                return this.posValues[0];
            }
            case 7: {
                return this.posValues[1];
            }
            case 17: {
                return this.keyPressedValue;
            }
        }
        return super.getValue(n - 29);
    }

    public ControlDrawable getSelectedDrawable() {
        Object object;
        if (this.targetHit != null && this.targetHit.getSource() instanceof InteractiveElement && (object = ((InteractiveElement)this.targetHit.getSource()).getDataObject()) instanceof ControlDrawable) {
            return (ControlDrawable)object;
        }
        return null;
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 1: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive instanceof InteractionTarget) {
                    this.targetHit = (InteractionTarget)interactive;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                this.targetHit = null;
                this.mousePressed(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D point3D = new Point3D(interactivePanel.getMouseX(), interactivePanel.getMouseY(), 0.0);
                    this.targetHit.updateHotspot(interactivePanel, point3D);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    interactivePanel.repaint();
                    break;
                }
                this.mouseDragged(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                } else {
                    this.mouseReleased(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                }
                this.targetHit = null;
                break;
            }
            case 5: {
                this.invokeActions(31);
                break;
            }
            case 6: {
                this.invokeActions(32);
                this.targetHit = null;
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                }
                this.sourceLingered = null;
                break;
            }
            case 7: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive != null) {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    if (!(interactive instanceof InteractionTarget) || this.sourceLingered == ((InteractionTarget)interactive).getSource()) break;
                    if (this.sourceLingered != null) {
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                    }
                    this.sourceLingered = ((InteractionTarget)interactive).getSource();
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactive));
                    break;
                }
                interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(1));
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                }
                this.sourceLingered = null;
            }
        }
    }

    public void mousePressed(double d, double d2) {
        this.drawingPanel.requestFocus();
        this.invokeActions(10);
        this.mouseDragged(d, d2);
    }

    public void mouseDragged(double d, double d2) {
        this.posValues[0].value = d;
        this.posValues[1].value = d2;
        if (this.reportDrag) {
            this.variablesChanged(this.getPosIndex(), this.posValues);
        }
    }

    public void mouseReleased(double d, double d2) {
        this.invokeActions(0);
    }
}

