/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.ejs.control.DataCollector;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.frames.TableData;

public class ControlDataTable
extends ControlSwingElement
implements NeedsUpdate,
DataCollector {
    private static final int TABLE_ADDED = 8;
    private static final int MAX_INPUT = 5;
    private DataTable table;
    private JScrollPane panel;
    private boolean noRepeat = true;
    private boolean isSet = false;
    private boolean active = true;
    private double[] input;
    private double[] oldInput;
    private String[] columnNames = new String[0];
    private String[] columnFormats = new String[]{"0.000;-0.000"};
    private TableData data;
    private static ArrayList infoList = null;

    public ControlDataTable(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.table = object instanceof DataTable ? (DataTable)object : new DataTable();
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
        this.data = new TableData();
        this.data.setRowNumberVisible(false);
        int n = this.data.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.data.setColumnFormat(i, "0.000;-0.000");
        }
        this.table.add(this.data);
        this.panel = new JScrollPane(this.table);
        return this.table;
    }

    public String getObjectClassname() {
        return "org.opensourcephysics.frames.TableData";
    }

    public Object getObject() {
        return this.data;
    }

    public Component getComponent() {
        return this.panel;
    }

    public void initialize() {
        this.reset();
    }

    public void reset() {
        this.data.clear();
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
    }

    public void onExit() {
        this.reset();
    }

    public void update() {
        if (this.active && this.isSet && this.input != null) {
            int n;
            int n2;
            if (this.noRepeat) {
                if (this.oldInput == null || this.input.length != this.oldInput.length) {
                    this.oldInput = new double[this.input.length];
                } else {
                    n2 = 1;
                    for (n = 0; n < this.input.length; ++n) {
                        if (this.input[n] == this.oldInput[n]) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        return;
                    }
                }
                for (n2 = 0; n2 < this.input.length; ++n2) {
                    this.oldInput[n2] = this.input[n2];
                }
            }
            n2 = this.data.getColumnCount();
            this.data.appendRow(this.input);
            if (this.input.length != n2) {
                int n3 = Math.min(this.columnNames.length, this.input.length);
                for (n = 0; n < n3; ++n) {
                    this.data.setColumnNames(n, this.columnNames[n]);
                }
                if (this.columnFormats.length >= this.input.length) {
                    n3 = this.input.length;
                    for (n = 0; n < n3; ++n) {
                        this.data.setColumnFormat(n, this.columnFormats[n]);
                    }
                } else {
                    n3 = this.columnFormats.length;
                    for (n = 0; n < n3; ++n) {
                        this.data.setColumnFormat(n, this.columnFormats[n]);
                    }
                    n3 = this.input.length;
                    for (n = this.columnFormats.length; n < n3; ++n) {
                        this.data.setColumnFormat(n, this.columnFormats[this.columnFormats.length - 1]);
                    }
                }
            }
        }
        if (this.myGroup != null && this.myGroup.isCollectingData()) {
            return;
        }
        this.table.refreshTable();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("input");
            infoList.add("maxPoints");
            infoList.add("stride");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("showRowNumber");
            infoList.add("columnNames");
            infoList.add("columnFormat");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("input")) {
            return "int|double|double[]";
        }
        if (string.equals("maxPoints")) {
            return "int";
        }
        if (string.equals("stride")) {
            return "int";
        }
        if (string.equals("active")) {
            return "boolean";
        }
        if (string.equals("norepeat")) {
            return "boolean";
        }
        if (string.equals("showRowNumber")) {
            return "boolean";
        }
        if (string.equals("columnNames")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("columnFormat")) {
            return "String|String[] TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.input = value.getObject() instanceof double[] ? (double[])value.getObject() : new double[]{value.getDouble()};
                this.isSet = true;
                break;
            }
            case 1: {
                this.data.setMaxPoints(value.getInteger());
                break;
            }
            case 2: {
                this.table.setStride(this.data, value.getInteger());
                break;
            }
            case 3: {
                this.active = value.getBoolean();
                break;
            }
            case 4: {
                this.noRepeat = value.getBoolean();
                break;
            }
            case 5: {
                this.data.setRowNumberVisible(value.getBoolean());
                break;
            }
            case 6: {
                if (value.getObject() instanceof String[]) {
                    this.columnNames = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    this.columnNames = new String[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.columnNames[n2] = GUIUtils.parseTeX(stringTokenizer.nextToken());
                        ++n2;
                    }
                }
                int n3 = this.columnNames.length;
                for (int i = 0; i < n3; ++i) {
                    this.data.setColumnNames(i, this.columnNames[i]);
                }
                break;
            }
            case 7: {
                if (value.getObject() instanceof String[]) {
                    this.columnFormats = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    this.columnFormats = new String[stringTokenizer.countTokens()];
                    int n4 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.columnFormats[n4] = GUIUtils.parseTeX(stringTokenizer.nextToken());
                        ++n4;
                    }
                }
                int n5 = this.columnFormats.length;
                for (int i = 0; i < n5; ++i) {
                    this.data.setColumnFormat(i, this.columnFormats[i]);
                }
                break;
            }
            default: {
                super.setValue(n - 8, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.oldInput = null;
                this.input = null;
                this.isSet = false;
                break;
            }
            case 1: {
                this.data.setMaxPoints(-1);
                break;
            }
            case 2: {
                this.table.setStride(this.data, 1);
                break;
            }
            case 3: {
                this.active = true;
                break;
            }
            case 4: {
                this.noRepeat = true;
                break;
            }
            case 5: {
                this.data.setRowNumberVisible(false);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.columnFormats = new String[]{"0.000;-0.000"};
                int n2 = this.columnFormats.length;
                for (int i = 0; i < n2; ++i) {
                    this.data.setColumnFormat(i, this.columnFormats[i]);
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 8);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }
}

