/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlMenuBar;
import org.opensourcephysics.ejs.control.swing.ControlRadioButton;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;

public abstract class ControlContainer
extends ControlSwingElement {
    private static final BooleanValue falseValue = new BooleanValue(false);
    protected Vector radioButtons = new Vector();
    protected Vector children = new Vector();

    public ControlContainer(Object object) {
        super(object);
    }

    public Container getContainer() {
        return (Container)this.getVisual();
    }

    public boolean acceptsChild(ControlElement controlElement) {
        if (controlElement instanceof ControlMenuBar) {
            return false;
        }
        return controlElement instanceof ControlSwingElement;
    }

    public void add(ControlElement controlElement) {
        this.children.add(controlElement);
        Container container = this.getContainer();
        LayoutManager layoutManager = container.getLayout();
        String string = controlElement.getProperty("_ejs_indexInParent_");
        int n = -1;
        if (string != null) {
            n = Integer.parseInt(string);
        }
        controlElement.setProperty("_ejs_indexInParent_", null);
        if (layoutManager instanceof BorderLayout) {
            String string2 = controlElement.getProperty("position");
            if (string2 != null) {
                container.add(controlElement.getComponent(), ConstantParser.constraintsConstant(string2).getString(), n);
            } else {
                container.add(controlElement.getComponent(), "Center", n);
            }
        } else {
            container.add(controlElement.getComponent(), n);
        }
        this.adjustSize();
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.add(controlElement);
            ((ControlRadioButton)controlElement).setParent(this);
        }
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    protected void adjustChildren() {
        Container container = this.getContainer();
        if (container.getLayout() instanceof BorderLayout) {
            container.removeAll();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("center");
            arrayList.add("north");
            arrayList.add("south");
            arrayList.add("east");
            arrayList.add("west");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                ControlElement controlElement = (ControlElement)enumeration.nextElement();
                String string = controlElement.getProperty("position");
                if (string == null) {
                    string = (String)arrayList.get(0);
                }
                if (string == null) {
                    string = "center";
                } else {
                    arrayList.remove(string);
                }
                container.add(controlElement.getComponent(), ConstantParser.constraintsConstant(string).getString(), -1);
            }
        }
    }

    public void adjustSize() {
        this.getContainer().validate();
        this.getContainer().repaint();
        ControlContainer.resizeContainer(this.getContainer());
        ControlContainer.resizeContainer(this.getComponent().getParent());
    }

    private static void resizeContainer(Container container) {
        if (container == null) {
            return;
        }
        Rectangle rectangle = container.getBounds();
        container.setBounds(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        container.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        container.validate();
        container.repaint();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void remove(ControlElement controlElement) {
        this.children.remove(controlElement);
        Container container = this.getContainer();
        container.remove(controlElement.getComponent());
        container.validate();
        container.repaint();
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.remove(controlElement);
            ((ControlRadioButton)controlElement).setParent(null);
        }
    }

    public void informRadioGroup(ControlRadioButton controlRadioButton, boolean bl) {
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.radioButtons.elements();
        while (enumeration.hasMoreElements()) {
            ControlRadioButton controlRadioButton2 = (ControlRadioButton)enumeration.nextElement();
            if (controlRadioButton2 == controlRadioButton) continue;
            boolean bl2 = controlRadioButton2.isActive();
            controlRadioButton2.setActive(false);
            controlRadioButton2.setValue(controlRadioButton.getVariableIndex(), falseValue);
            controlRadioButton2.reportChanges();
            controlRadioButton2.setActive(bl2);
        }
    }

    protected void propagateProperty(ControlElement controlElement, String string, String string2) {
        if (controlElement.getProperty(string) == null) {
            controlElement.setProperty(string, string2, false);
        }
    }

    protected void propagateProperty(String string, String string2) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.propagateProperty((ControlElement)this.children.elementAt(i), string, string2);
        }
    }

    protected String getPropagatedProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
        if (controlElement != null && controlElement instanceof ControlContainer) {
            return ((ControlContainer)controlElement).getPropagatedProperty(string);
        }
        return null;
    }

    public ControlElement setProperty(String string, String string2, boolean bl) {
        ControlElement controlElement = super.setProperty(string, string2, bl);
        if (string.equals("font") || string.equals("foreground") || string.equals("background")) {
            this.propagateProperty(string, string2);
        }
        return controlElement;
    }
}

