/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveSurface;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveTile;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSurface
extends ControlInteractiveTile {
    static final int PROPERTIES_SURFACE = 8;
    static final int MY_PRIMARY_COLOR = 26;
    static final int MY_SECONDARY_COLOR = 27;
    static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{8, 9, 10};
    private static final int[] sizeSpot = new int[]{11, 12, 13};

    public ControlSurface(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        InteractiveSurface interactiveSurface = object instanceof InteractiveSurface ? (InteractiveSurface)object : new InteractiveSurface();
        interactiveSurface.setOrigin(0.0, 0.0, 0.0, true);
        this.sizeValues = new DoubleValue[]{new DoubleValue(1.0), new DoubleValue(1.0), new DoubleValue(1.0)};
        return interactiveSurface;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("data");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("data")) {
            return "double[][][]";
        }
        return super.getPropertyInfo(string);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("linecolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (!(value.getObject() instanceof double[][][])) break;
                ((InteractiveSurface)this.myElement).setData((double[][][])value.getObject());
                break;
            }
            case 26: {
                Paint paint = (Paint)value.getObject();
                if (paint == NULL_COLOR) {
                    paint = null;
                }
                this.myElement.getStyle().setFillPattern(paint);
                break;
            }
            case 27: {
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((InteractiveSurface)this.myElement).setData(null);
                break;
            }
            case 26: {
                this.myElement.getStyle().setFillPattern(Color.blue);
                break;
            }
            case 27: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 26: {
                return "BLUE";
            }
            case 27: {
                return "BLACK";
            }
        }
        return super.getDefaultValueString(n - 1);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return this.getValue(n - 1);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    private static void setDemoData(InteractiveSurface interactiveSurface) {
        int n = 16;
        int n2 = 16;
        double[][][] dArray = new double[n][n2][3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = (double)i * 1.0 / (double)(n - 1);
                double d2 = (double)j * 2.0 * Math.PI / (double)(n2 - 1);
                dArray[i][j][0] = d * Math.cos(d2);
                dArray[i][j][1] = d * Math.sin(d2);
                dArray[i][j][2] = d == 0.0 ? 0.5 : (d < 0.5 ? 0.5 * Math.max(0.0, Math.sin(Math.PI * 4 * d) / (Math.PI * 4 * d)) : 0.5 * Math.max(0.0, Math.sin(Math.PI * 4 * d) / (4.0 * d)));
            }
        }
        interactiveSurface.setData(dArray);
    }
}

