/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.ejs.control.displayejs.ControlElementSet;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSpringSet
extends ControlElementSet {
    public ControlSpringSet(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof ElementSet) {
            this.elementSet = (ElementSet)object;
        } else {
            this.elementSet = new ElementSet(1, InteractiveSpring.class);
            this.elementSet.setEnabled(1, true);
        }
        return this.elementSet;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("enabled")) {
            return "enabledSize";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledPosition";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("radius")) {
            return "int|double|double[]";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 3: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n2 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    for (int i = 0; i < n2; ++i) {
                        ((InteractiveSpring)this.elementSet.elementAt(i)).setRadius(dArray[i]);
                    }
                } else {
                    double d = value.getDouble();
                    int n3 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n3; ++i) {
                        ((InteractiveSpring)this.elementSet.elementAt(i)).setRadius(d);
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, value.getBoolean());
                break;
            }
            case 12: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, value.getBoolean());
                break;
            }
            default: {
                super.setValue(n, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 3: {
                int n2 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n2; ++i) {
                    ((InteractiveSpring)this.elementSet.elementAt(i)).setRadius(0.1);
                }
            }
            case 11: {
                this.elementSet.setEnabled(1, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(0, false);
                break;
            }
            default: {
                super.setDefaultValue(n);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 3: {
                return "0.1";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
        }
        return super.getDefaultValueString(n);
    }
}

