/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveSphere;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.displayejs.ControlCylinder;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSphere
extends ControlCylinder {
    public ControlSphere(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        InteractiveSphere interactiveSphere = object instanceof InteractiveSphere ? (InteractiveSphere)object : new InteractiveSphere();
        interactiveSphere.setOrigin(0.5, 0.5, 0.5, true);
        return interactiveSphere;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("minanglev")) {
            return "int|double";
        }
        if (string.equals("maxanglev")) {
            return "int|double";
        }
        return super.getPropertyInfo(string);
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("minangle")) {
            return "minimumAngleU";
        }
        if (string.equals("maxangle")) {
            return "maximumAngleU";
        }
        if (string.equals("minanglev")) {
            return "minimumAngleV";
        }
        if (string.equals("maxanglev")) {
            return "maximumAngleV";
        }
        return super.getPropertyCommonName(string);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("dx")) {
            return super.setProperty("sizex", "2*" + string2);
        }
        if (string.equals("dy")) {
            return super.setProperty("sizey", "2*" + string2);
        }
        if (string.equals("dz")) {
            return super.setProperty("sizez", "2*" + string2);
        }
        if (string.equals("linecolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 4: {
                ((InteractiveSphere)this.myElement).setMinAngleV(value.getInteger());
                break;
            }
            case 5: {
                ((InteractiveSphere)this.myElement).setMaxAngleV(value.getInteger());
                break;
            }
            default: {
                super.setValue(n, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 4: {
                ((InteractiveSphere)this.myElement).setMinAngleV(0);
                break;
            }
            case 5: {
                ((InteractiveSphere)this.myElement).setMaxAngleV(360);
                break;
            }
            default: {
                super.setDefaultValue(n);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 4: {
                return "0";
            }
            case 5: {
                return "360";
            }
        }
        return super.getDefaultValueString(n);
    }
}

