/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlParticle
extends ControlInteractiveElement {
    private static final int PARTICLE_ADDED = 1;
    private static final int MY_STYLE = 15;
    private static final int MY_PRIMARY_COLOR = 19;
    private static final int MY_SECONDARY_COLOR = 20;
    private static final int[] posSpot = new int[]{1, 2, 3};
    private static final int[] sizeSpot = new int[]{4, 5, 6};
    private static ArrayList infoList = null;

    public ControlParticle(Object object) {
        super(object);
        this.enabledEjsEdit = true;
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof InteractiveParticle) {
            return (InteractiveParticle)object;
        }
        InteractiveParticle interactiveParticle = new InteractiveParticle();
        interactiveParticle.setEnabled(0, true);
        return interactiveParticle;
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("pixelSize");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("pixelSize")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                ((InteractiveParticle)this.myElement).setPixelSize(value.getBoolean());
                break;
            }
            case 15: {
                ((InteractiveParticle)this.myElement).setShapeType(value.getInteger());
                break;
            }
            case 19: {
                Paint paint = (Paint)value.getObject();
                if (paint == NULL_COLOR) {
                    paint = null;
                }
                this.myElement.getStyle().setFillPattern(paint);
                break;
            }
            case 20: {
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((InteractiveParticle)this.myElement).setPixelSize(false);
                break;
            }
            case 15: {
                ((InteractiveParticle)this.myElement).setShapeType(1);
                break;
            }
            case 19: {
                this.myElement.getStyle().setFillPattern(Color.blue);
                break;
            }
            case 20: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "false";
            }
            case 15: {
                return "ELLIPSE";
            }
            case 19: {
                return "BLUE";
            }
            case 20: {
                return "BLACK";
            }
        }
        return super.getDefaultValueString(n - 1);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

