/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.ejs.Function;
import org.opensourcephysics.ejs.control.displayejs.ControlDrawable3D;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlElementSet
extends ControlDrawable3D
implements InteractionListener {
    protected static final int SET_ADDED = 33;
    protected static final int IMAGE = 1;
    protected static final int TEXT = 2;
    protected static final int RADIUS = 3;
    protected static final int POSITION_X = 4;
    protected static final int POSITION_Y = 5;
    protected static final int POSITION_Z = 6;
    protected static final int SIZE_X = 7;
    protected static final int SIZE_Y = 8;
    protected static final int SIZE_Z = 9;
    protected static final int ENABLED = 11;
    protected static final int ENABLED_SECONDARY = 12;
    protected static final int STYLE = 18;
    protected static final int PRIMARY_COLOR = 22;
    protected static final int SECONDARY_COLOR = 23;
    protected static final int ELEMENT_SELECTED = 31;
    protected ElementSet elementSet;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValue;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double scalez = 1.0;
    protected double lineWidth = 1.0;
    protected Font font;
    protected Font defaultFont;
    protected int sensitivity = AbstractInteractiveElement.SENSIBILITY;
    protected boolean numberOfElements_isSet = false;
    protected Function elementFunction = new MyFunction();
    static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{4, 5, 6};
    private static final int[] sizeSpot = new int[]{7, 8, 9};

    public ControlElementSet(Object object) {
        super(object);
        this.allposValues = new ObjectValue[3];
        this.theXs = this.elementSet.getXs();
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.theYs = this.elementSet.getYs();
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.theZs = this.elementSet.getZs();
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValue = new ObjectValue[3];
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0] = new ObjectValue(this.theSizeXs);
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1] = new ObjectValue(this.theSizeYs);
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2] = new ObjectValue(this.theSizeZs);
        this.elementSet.addListener(this);
        this.defaultFont = this.font = this.elementSet.elementAt(0).getStyle().getFont();
    }

    public Object getObject(String string) {
        if (string.equals("elementSelected")) {
            return this.elementFunction;
        }
        return null;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("elementnumber");
            infoList.add("image");
            infoList.add("text");
            infoList.add("radius");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizex");
            infoList.add("sizey");
            infoList.add("sizez");
            infoList.add("visible");
            infoList.add("enabled");
            infoList.add("enabledSecondary");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("scalez");
            infoList.add("group");
            infoList.add("groupEnabled");
            infoList.add("style");
            infoList.add("elementposition");
            infoList.add("angle");
            infoList.add("resolution");
            infoList.add("color");
            infoList.add("secondaryColor");
            infoList.add("stroke");
            infoList.add("font");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("elementSelected");
            infoList.add("sensitivity");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("elementnumber")) {
            return "numberOfElements";
        }
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("color")) {
            return "fillColor";
        }
        if (string.equals("secondaryColor")) {
            return "lineColor";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("enabled")) {
            return "enabledPosition";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledSize";
        }
        if (string.equals("sizex")) {
            return "sizeX";
        }
        if (string.equals("sizey")) {
            return "sizeY";
        }
        if (string.equals("sizez")) {
            return "sizeZ";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("elementnumber")) {
            return "int PREVIOUS";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("sizex")) {
            return "int|double|double[]";
        }
        if (string.equals("sizey")) {
            return "int|double|double[]";
        }
        if (string.equals("sizez")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabled")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledSecondary")) {
            return "boolean|boolean[]";
        }
        if (string.equals("scalex")) {
            return "int|double";
        }
        if (string.equals("scaley")) {
            return "int|double";
        }
        if (string.equals("scalez")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        if (string.equals("angle")) {
            return "int|int[]|double|double[]";
        }
        if (string.equals("resolution")) {
            return "Resolution";
        }
        if (string.equals("color")) {
            return "Color|Object|Object[]";
        }
        if (string.equals("secondaryColor")) {
            return "Color|Object|Object[]";
        }
        if (string.equals("stroke")) {
            return "int|double|Object";
        }
        if (string.equals("font")) {
            return "Font|Object ";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        if (string.equals("sensitivity")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    protected void checkNumberOfElements(int n, boolean bl) {
        if (this.elementSet.getNumberOfElements() >= n && !bl) {
            return;
        }
        this.elementSet.setNumberOfElements(n);
        this.theXs = this.elementSet.getXs();
        this.allposValues[0].value = this.theXs;
        this.theYs = this.elementSet.getYs();
        this.allposValues[1].value = this.theYs;
        this.theZs = this.elementSet.getZs();
        this.allposValues[2].value = this.theZs;
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0].value = this.theSizeXs;
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1].value = this.theSizeYs;
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2].value = this.theSizeZs;
        int n2 = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n2; ++i) {
            InteractiveElement interactiveElement = this.elementSet.elementAt(i);
            this.theSizeXs[i] = this.scalex != 0.0 ? interactiveElement.getSizeX() / this.scalex : interactiveElement.getSizeX();
            this.theSizeYs[i] = this.scaley != 0.0 ? interactiveElement.getSizeY() / this.scaley : interactiveElement.getSizeY();
            this.theSizeZs[i] = this.scalez != 0.0 ? interactiveElement.getSizeZ() / this.scalez : interactiveElement.getSizeZ();
            if (interactiveElement instanceof InteractiveTrace) {
                ((InteractiveTrace)interactiveElement).setAllowTable(true);
            }
            interactiveElement.setSensitivity(this.sensitivity);
        }
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getInteger() != this.elementSet.getNumberOfElements()) {
                    this.checkNumberOfElements(value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n2 = Math.min(this.theXs.length, dArray.length);
                    for (int i = 0; i < n2; ++i) {
                        this.theXs[i] = dArray[i];
                        this.elementSet.elementAt(i).setX(this.theXs[i]);
                    }
                } else {
                    double d = value.getDouble();
                    int n3 = this.theXs.length;
                    for (int i = 0; i < n3; ++i) {
                        this.theXs[i] = d;
                        this.elementSet.elementAt(i).setX(this.theXs[i]);
                    }
                }
                break;
            }
            case 5: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n4 = Math.min(this.theYs.length, dArray.length);
                    for (int i = 0; i < n4; ++i) {
                        this.theYs[i] = dArray[i];
                        this.elementSet.elementAt(i).setY(this.theYs[i]);
                    }
                } else {
                    double d = value.getDouble();
                    int n5 = this.theYs.length;
                    for (int i = 0; i < n5; ++i) {
                        this.theYs[i] = d;
                        this.elementSet.elementAt(i).setY(this.theYs[i]);
                    }
                }
                break;
            }
            case 6: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n6 = Math.min(this.theZs.length, dArray.length);
                    for (int i = 0; i < n6; ++i) {
                        this.theZs[i] = dArray[i];
                        this.elementSet.elementAt(i).setZ(this.theZs[i]);
                    }
                } else {
                    double d = value.getDouble();
                    int n7 = this.theZs.length;
                    for (int i = 0; i < n7; ++i) {
                        this.theZs[i] = d;
                        this.elementSet.elementAt(i).setZ(this.theZs[i]);
                    }
                }
                break;
            }
            case 7: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n8 = Math.min(this.theSizeXs.length, dArray.length);
                    for (int i = 0; i < n8; ++i) {
                        this.theSizeXs[i] = dArray[i];
                        this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                    }
                } else {
                    double d = value.getDouble();
                    int n9 = this.theSizeXs.length;
                    for (int i = 0; i < n9; ++i) {
                        this.theSizeXs[i] = d;
                        this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                    }
                }
                break;
            }
            case 8: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n10 = Math.min(this.theSizeYs.length, dArray.length);
                    for (int i = 0; i < n10; ++i) {
                        this.theSizeYs[i] = dArray[i];
                        this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                    }
                } else {
                    double d = value.getDouble();
                    int n11 = this.theSizeYs.length;
                    for (int i = 0; i < n11; ++i) {
                        this.theSizeYs[i] = d;
                        this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                    }
                }
                break;
            }
            case 9: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n12 = Math.min(this.theSizeZs.length, dArray.length);
                    for (int i = 0; i < n12; ++i) {
                        this.theSizeZs[i] = dArray[i];
                        this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                    }
                } else {
                    double d = value.getDouble();
                    int n13 = this.theSizeZs.length;
                    for (int i = 0; i < n13; ++i) {
                        this.theSizeZs[i] = d;
                        this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                    }
                }
                break;
            }
            case 10: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setVisibles((boolean[])value.getObject());
                    break;
                }
                this.elementSet.setVisible(value.getBoolean());
                break;
            }
            case 11: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, value.getBoolean());
                break;
            }
            case 12: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, value.getBoolean());
                break;
            }
            case 13: {
                this.scalex = value.getDouble();
                int n14 = this.theSizeXs.length;
                for (int i = 0; i < n14; ++i) {
                    this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                }
                break;
            }
            case 14: {
                this.scaley = value.getDouble();
                int n15 = this.theSizeYs.length;
                for (int i = 0; i < n15; ++i) {
                    this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                }
                break;
            }
            case 15: {
                this.scalez = value.getDouble();
                int n16 = this.theSizeZs.length;
                for (int i = 0; i < n16; ++i) {
                    this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int n17 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n17; ++i) {
                    this.elementSet.elementAt(i).setGroupEnabled(value.getBoolean());
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n18 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n18; ++i) {
                        this.elementSet.elementAt(i).getStyle().setPosition(nArray[i]);
                    }
                } else {
                    int n19 = value.getInteger();
                    int n20 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n20; ++i) {
                        this.elementSet.elementAt(i).getStyle().setPosition(n19);
                    }
                }
                break;
            }
            case 20: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n21 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    for (int i = 0; i < n21; ++i) {
                        this.elementSet.elementAt(i).getStyle().setAngle(dArray[i]);
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n22 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n22; ++i) {
                        this.elementSet.elementAt(i).getStyle().setAngle((double)nArray[i] * (Math.PI / 180));
                    }
                } else if (value instanceof IntegerValue) {
                    double d = (double)value.getInteger() * (Math.PI / 180);
                    int n23 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n23; ++i) {
                        this.elementSet.elementAt(i).getStyle().setAngle(d);
                    }
                } else {
                    double d = value.getDouble();
                    int n24 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n24; ++i) {
                        this.elementSet.elementAt(i).getStyle().setAngle(d);
                    }
                }
                break;
            }
            case 21: {
                int n25 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n25; ++i) {
                    this.elementSet.elementAt(i).setResolution((Resolution)value.getObject());
                }
                break;
            }
            case 22: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n26 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n26; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor((Color)objectArray[i]);
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n27 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n27; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor(color);
                    }
                }
                break;
            }
            case 23: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n28 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n28; ++i) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern((Paint)objectArray[i]);
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Paint paint = (Paint)value.getObject();
                    if (paint == NULL_COLOR) {
                        paint = null;
                    }
                    int n29 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n29; ++i) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern(paint);
                    }
                }
                break;
            }
            case 24: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n30 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n30; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke((Stroke)objectArray[i]);
                    }
                } else if (value.getObject() instanceof Stroke) {
                    Stroke stroke = (Stroke)value.getObject();
                    int n31 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n31; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(stroke);
                    }
                } else if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n32 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    for (int i = 0; i < n32; ++i) {
                        BasicStroke basicStroke = dArray[i] < 0.0 ? new BasicStroke((float)(-dArray[i]), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)dArray[i]);
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(basicStroke);
                    }
                } else {
                    if (this.lineWidth == value.getDouble()) break;
                    this.lineWidth = value.getDouble();
                    BasicStroke basicStroke = this.lineWidth < 0.0 ? new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)this.lineWidth);
                    int n33 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n33; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(basicStroke);
                    }
                }
                break;
            }
            case 25: {
                Font font;
                if (!(value.getObject() instanceof Font) || (font = (Font)value.getObject()) == this.font) break;
                this.font = font;
                int n34 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n34; ++i) {
                    this.elementSet.elementAt(i).getStyle().setFont(font);
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                this.addAction(11, value.getString());
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                this.addAction(12, value.getString());
                return;
            }
            case 31: {
                this.selectedValue.value = value.getInteger();
                break;
            }
            case 32: {
                this.sensitivity = value.getInteger();
                int n35 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n35; ++i) {
                    this.elementSet.elementAt(i).setSensitivity(this.sensitivity);
                }
                break;
            }
            default: {
                super.setValue(n - 33, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.checkNumberOfElements(1, true);
                this.numberOfElements_isSet = false;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int n2 = this.theXs.length;
                for (int i = 0; i < n2; ++i) {
                    this.theXs[i] = 0.0;
                    this.elementSet.elementAt(i).setX(0.0);
                }
                break;
            }
            case 5: {
                int n3 = this.theYs.length;
                for (int i = 0; i < n3; ++i) {
                    this.theYs[i] = 0.0;
                    this.elementSet.elementAt(i).setY(0.0);
                }
                break;
            }
            case 6: {
                int n4 = this.theZs.length;
                for (int i = 0; i < n4; ++i) {
                    this.theZs[i] = 0.0;
                    this.elementSet.elementAt(i).setZ(0.0);
                }
                break;
            }
            case 7: {
                int n5 = this.theSizeXs.length;
                for (int i = 0; i < n5; ++i) {
                    this.theSizeXs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeX(0.1 * this.scalex);
                }
                break;
            }
            case 8: {
                int n6 = this.theSizeYs.length;
                for (int i = 0; i < n6; ++i) {
                    this.theSizeYs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeY(0.1 * this.scaley);
                }
                break;
            }
            case 9: {
                int n7 = this.theSizeZs.length;
                for (int i = 0; i < n7; ++i) {
                    this.theSizeZs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeZ(0.1 * this.scalez);
                }
                break;
            }
            case 10: {
                this.elementSet.setVisible(true);
                break;
            }
            case 11: {
                this.elementSet.setEnabled(0, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(1, false);
                break;
            }
            case 13: {
                this.scalex = 1.0;
                int n8 = this.theSizeXs.length;
                for (int i = 0; i < n8; ++i) {
                    this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i]);
                }
                break;
            }
            case 14: {
                this.scaley = 1.0;
                int n9 = this.theSizeYs.length;
                for (int i = 0; i < n9; ++i) {
                    this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i]);
                }
                break;
            }
            case 15: {
                this.scalez = 1.0;
                int n10 = this.theSizeZs.length;
                for (int i = 0; i < n10; ++i) {
                    this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i]);
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int n11 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n11; ++i) {
                    this.elementSet.elementAt(i).setGroupEnabled(true);
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                int n12 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n12; ++i) {
                    this.elementSet.elementAt(i).getStyle().setPosition(0);
                }
                break;
            }
            case 20: {
                int n13 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n13; ++i) {
                    this.elementSet.elementAt(i).getStyle().setAngle(0.0);
                }
                break;
            }
            case 21: {
                int n14 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n14; ++i) {
                    this.elementSet.elementAt(i).setResolution(null);
                }
                break;
            }
            case 22: {
                int n15 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n15; ++i) {
                    this.elementSet.elementAt(i).getStyle().setEdgeColor(Color.black);
                }
                break;
            }
            case 23: {
                int n16 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n16; ++i) {
                    this.elementSet.elementAt(i).getStyle().setFillPattern(Color.blue);
                }
                break;
            }
            case 24: {
                this.lineWidth = 1.0;
                BasicStroke basicStroke = new BasicStroke((float)1.0);
                int n17 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n17; ++i) {
                    this.elementSet.elementAt(i).getStyle().setEdgeStroke(basicStroke);
                }
                break;
            }
            case 25: {
                this.font = this.defaultFont;
                int n18 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n18; ++i) {
                    this.elementSet.elementAt(i).getStyle().setFont(this.font);
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                return;
            }
            case 31: {
                this.selectedValue.value = -1;
                break;
            }
            case 32: {
                this.sensitivity = AbstractInteractiveElement.SENSIBILITY;
                int n19 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n19; ++i) {
                    this.elementSet.elementAt(i).setSensitivity(this.sensitivity);
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 33);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "1";
            }
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 4: 
            case 5: 
            case 6: {
                return "0";
            }
            case 7: 
            case 8: 
            case 9: {
                return "0.1";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
            case 13: 
            case 14: 
            case 15: {
                return "1";
            }
            case 16: {
                return "<none>";
            }
            case 17: {
                return "true";
            }
            case 18: {
                return "<none>";
            }
            case 19: {
                return "CENTERED";
            }
            case 20: {
                return "0";
            }
            case 21: {
                return "<none>";
            }
            case 22: {
                return "BLACK";
            }
            case 23: {
                return "BLUE";
            }
            case 24: {
                return "1";
            }
            case 25: {
                return "<none>";
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return "<no_action>";
            }
            case 31: {
                return "-1";
            }
            case 32: {
                return "" + AbstractInteractiveElement.SENSIBILITY;
            }
        }
        return super.getDefaultValueString(n - 33);
    }

    public Value getValue(int n) {
        switch (n) {
            case 4: {
                return this.allposValues[0];
            }
            case 5: {
                return this.allposValues[1];
            }
            case 6: {
                return this.allposValues[2];
            }
            case 7: {
                return this.allsizesValue[0];
            }
            case 8: {
                return this.allsizesValue[1];
            }
            case 9: {
                return this.allsizesValue[2];
            }
            case 31: {
                return this.selectedValue;
            }
        }
        if (n < 33) {
            return null;
        }
        return super.getValue(n - 33);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    int getElementSpot() {
        return 31;
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                this.selectedValue.value = -1;
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                break;
            }
            case 2003: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(11);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(10);
            }
            case 2001: {
                InteractionTargetSetElement interactionTargetSetElement = (InteractionTargetSetElement)interactionEvent.getTarget();
                int n = interactionTargetSetElement.getElementIndex();
                if (interactionTargetSetElement.getElementTarget().getClass() == InteractionTargetElementSize.class) {
                    this.theSizeXs[n] = this.scalex != 0.0 ? this.elementSet.elementAt(n).getSizeX() / this.scalex : this.elementSet.elementAt(n).getSizeX();
                    this.theSizeYs[n] = this.scaley != 0.0 ? this.elementSet.elementAt(n).getSizeY() / this.scaley : this.elementSet.elementAt(n).getSizeY();
                    this.theSizeZs[n] = this.scalez != 0.0 ? this.elementSet.elementAt(n).getSizeZ() / this.scalez : this.elementSet.elementAt(n).getSizeZ();
                    this.variablesChanged(this.getSizeSpot(), this.allsizesValue);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValues(this.getSizeSpot(), this.allsizesValue);
                    break;
                }
                this.theXs[n] = this.elementSet.elementAt(n).getX();
                this.theYs[n] = this.elementSet.elementAt(n).getY();
                this.theZs[n] = this.elementSet.elementAt(n).getZ();
                this.variablesChanged(this.getPosSpot(), this.allposValues);
                if (!this.isUnderEjs) break;
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.selectedValue.value = -1;
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
            }
        }
    }

    private class MyFunction
    extends Function {
        private MyFunction() {
        }

        public double eval() {
            return ControlElementSet.this.elementSet.getInteractedIndex();
        }
    }
}

