/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveCylinder;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveTile;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlCylinder
extends ControlInteractiveTile {
    static final int PROPERTIES_CYLINDER = 17;
    static final int MY_PRIMARY_COLOR = 35;
    static final int MY_SECONDARY_COLOR = 36;
    static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{17, 18, 19};
    private static final int[] sizeSpot = new int[]{20, 21, 22};

    public ControlCylinder(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        InteractiveCylinder interactiveCylinder = object instanceof InteractiveCylinder ? (InteractiveCylinder)object : new InteractiveCylinder();
        interactiveCylinder.setOrigin(0.5, 0.5, 0.0, true);
        return interactiveCylinder;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("direction");
            infoList.add("axes");
            infoList.add("minangle");
            infoList.add("maxangle");
            infoList.add("minanglev");
            infoList.add("maxanglev");
            infoList.add("closedBottom");
            infoList.add("closedTop");
            infoList.add("closedLeft");
            infoList.add("closedRight");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("minangle")) {
            return "minimumAngle";
        }
        if (string.equals("maxangle")) {
            return "maximumAngle";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("direction")) {
            return "Axis|int";
        }
        if (string.equals("axes")) {
            return "double[]";
        }
        if (string.equals("minangle")) {
            return "int|double";
        }
        if (string.equals("maxangle")) {
            return "int|double";
        }
        if (string.equals("closedBottom")) {
            return "boolean";
        }
        if (string.equals("closedTop")) {
            return "boolean";
        }
        if (string.equals("closedRight")) {
            return "boolean";
        }
        if (string.equals("closedLeft")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Axis") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).startsWith("x")) {
                return new IntegerValue(0);
            }
            if (string2.startsWith("y")) {
                return new IntegerValue(1);
            }
            if (string2.startsWith("z")) {
                return new IntegerValue(2);
            }
            if (string2.equals("custom")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(string, string2);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("dx")) {
            return super.setProperty("sizex", "2*" + string2);
        }
        if (string.equals("dy")) {
            return super.setProperty("sizey", "2*" + string2);
        }
        if (string.equals("dz")) {
            return super.setProperty("sizez", string2);
        }
        if (string.equals("linecolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                ((InteractiveCylinder)this.myElement).setDirection(value.getInteger());
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof double[])) break;
                ((InteractiveCylinder)this.myElement).setCustomAxes((double[])value.getObject());
                break;
            }
            case 2: {
                ((InteractiveCylinder)this.myElement).setMinAngleU(value.getInteger());
                break;
            }
            case 3: {
                ((InteractiveCylinder)this.myElement).setMaxAngleU(value.getInteger());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ((InteractiveCylinder)this.myElement).setClosedBottom(value.getBoolean());
                break;
            }
            case 7: {
                ((InteractiveCylinder)this.myElement).setClosedTop(value.getBoolean());
                break;
            }
            case 8: {
                ((InteractiveCylinder)this.myElement).setClosedLeft(value.getBoolean());
                break;
            }
            case 9: {
                ((InteractiveCylinder)this.myElement).setClosedRight(value.getBoolean());
                break;
            }
            case 35: {
                Paint paint = (Paint)value.getObject();
                if (paint == NULL_COLOR) {
                    paint = null;
                }
                this.myElement.getStyle().setFillPattern(paint);
                break;
            }
            case 36: {
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((InteractiveCylinder)this.myElement).setDirection(2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ((InteractiveCylinder)this.myElement).setMinAngleU(0);
                break;
            }
            case 3: {
                ((InteractiveCylinder)this.myElement).setMaxAngleU(360);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ((InteractiveCylinder)this.myElement).setClosedBottom(true);
                break;
            }
            case 7: {
                ((InteractiveCylinder)this.myElement).setClosedTop(true);
                break;
            }
            case 8: {
                ((InteractiveCylinder)this.myElement).setClosedLeft(true);
                break;
            }
            case 9: {
                ((InteractiveCylinder)this.myElement).setClosedRight(true);
                break;
            }
            case 35: {
                this.myElement.getStyle().setFillPattern(Color.blue);
                break;
            }
            case 36: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "Z_AXIS";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "360";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "<none>";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "true";
            }
            case 35: {
                return "BLUE";
            }
            case 36: {
                return "BLACK";
            }
        }
        return super.getDefaultValueString(n - 10);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return this.getValue(n - 10);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }
}

