/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.automaticcontrol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import org.opensourcephysics.automaticcontrol.Tank;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.ejs.control.displayejs.ControlDrawingPanel3D;
import org.opensourcephysics.ejs.control.displayejs.ControlGroupDrawable;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTank
extends ControlGroupDrawable
implements InteractionListener {
    protected static final int TANK_ADDED = 14;
    protected Tank tank;
    private double lineWidth = Double.NaN;
    private Value[] magnitudesValue = new Value[7];
    private static ArrayList infoList = null;
    private static final int[] magnitudesIndex = new int[]{0, 1, 2, 11, 14, 15, 16};

    public ControlTank(Object object) {
        super(object);
        this.magnitudesValue[0] = new DoubleValue(this.tank.getHeight());
        this.magnitudesValue[1] = new DoubleValue(this.tank.getWidth());
        this.magnitudesValue[2] = new DoubleValue(this.tank.getLevel());
        this.magnitudesValue[3] = new ObjectValue(this.tank.getProfile());
        this.magnitudesValue[4] = this.posValues[0];
        this.magnitudesValue[5] = this.posValues[1];
        this.magnitudesValue[6] = this.posValues[2];
        this.tank.addListener(this);
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof Tank) {
            this.tank = (Tank)object;
        } else {
            this.tank = new Tank();
            this.tank.setEnabled(true);
            this.tank.setMovable(true);
            this.tank.setResizable(true);
            this.tank.setProfilable(true);
            this.tank.setShowProfiles(false);
        }
        return this.tank;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("height");
            infoList.add("width");
            infoList.add("level");
            infoList.add("closedOnTop");
            infoList.add("lineColor");
            infoList.add("stroke");
            infoList.add("fillColor");
            infoList.add("enabled");
            infoList.add("resizable");
            infoList.add("profilable");
            infoList.add("profileColor");
            infoList.add("profile");
            infoList.add("movable");
            infoList.add("showProfiles");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("movable")) {
            return "enabledPosition";
        }
        if (string.equals("resizable")) {
            return "enabledSize";
        }
        if (string.equals("closedOnTop")) {
            return "closedTop";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("height")) {
            return "int|double";
        }
        if (string.equals("width")) {
            return "int|double";
        }
        if (string.equals("level")) {
            return "int|double";
        }
        if (string.equals("closedOnTop")) {
            return "boolean";
        }
        if (string.equals("lineColor")) {
            return "Color|Object";
        }
        if (string.equals("stroke")) {
            return "int|double|Object";
        }
        if (string.equals("fillColor")) {
            return "Color|Object";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("resizable")) {
            return "boolean";
        }
        if (string.equals("profilable")) {
            return "boolean";
        }
        if (string.equals("profileColor")) {
            return "Color|Object";
        }
        if (string.equals("profile")) {
            return "double[]";
        }
        if (string.equals("movable")) {
            return "boolean";
        }
        if (string.equals("showProfiles")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public Object getObject(String string) {
        if (string.equals("diameter")) {
            return this.tank.diameterFunction;
        }
        return null;
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.tank.setHeight(value.getDouble());
                break;
            }
            case 1: {
                this.tank.setWidth(value.getDouble());
                break;
            }
            case 2: {
                this.tank.setLevel(value.getDouble());
                break;
            }
            case 3: {
                this.tank.setClosedOnTop(value.getBoolean());
                break;
            }
            case 4: {
                this.tank.setLineColor((Color)value.getObject());
                break;
            }
            case 5: {
                if (value.getObject() instanceof Stroke) {
                    this.tank.setLineStroke((Stroke)value.getObject());
                    break;
                }
                if (this.lineWidth == value.getDouble()) break;
                this.lineWidth = value.getDouble();
                if (this.lineWidth < 0.0) {
                    this.tank.setLineStroke(new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f));
                    break;
                }
                this.tank.setLineStroke(new BasicStroke((float)this.lineWidth));
                break;
            }
            case 6: {
                this.tank.setFillColor((Color)value.getObject());
                break;
            }
            case 7: {
                this.tank.setEnabled(value.getBoolean());
                break;
            }
            case 8: {
                this.tank.setResizable(value.getBoolean());
                break;
            }
            case 9: {
                this.tank.setProfilable(value.getBoolean());
                break;
            }
            case 10: {
                this.tank.setProfileColor((Color)value.getObject());
                break;
            }
            case 11: {
                if (!(value.getObject() instanceof double[])) break;
                this.tank.setProfile((double[])value.getObject());
                break;
            }
            case 12: {
                this.tank.setMovable(value.getBoolean());
                break;
            }
            case 13: {
                this.tank.setShowProfiles(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.tank.setHeight(0.5);
                break;
            }
            case 1: {
                this.tank.setWidth(0.2);
                break;
            }
            case 2: {
                this.tank.setLevel(0.0);
                break;
            }
            case 3: {
                this.tank.setClosedOnTop(false);
                break;
            }
            case 4: {
                this.tank.setLineColor(Color.BLACK);
                break;
            }
            case 5: {
                this.tank.setLineStroke(new BasicStroke());
                break;
            }
            case 6: {
                this.tank.setFillColor(Color.BLUE);
                break;
            }
            case 7: {
                this.tank.setEnabled(true);
                break;
            }
            case 8: {
                this.tank.setResizable(true);
                break;
            }
            case 9: {
                this.tank.setProfilable(true);
                break;
            }
            case 10: {
                this.tank.setProfileColor(Color.GRAY);
                break;
            }
            case 11: {
                this.tank.setProfile(null);
                break;
            }
            case 12: {
                this.tank.setMovable(true);
                break;
            }
            case 13: {
                this.tank.setShowProfiles(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0.5";
            }
            case 1: {
                return "0.2";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "false";
            }
            case 4: {
                return "BLACK";
            }
            case 5: {
                return "1";
            }
            case 6: {
                return "BLUE";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return "GRAY";
            }
            case 11: {
                return "<none>";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 14);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.magnitudesValue[0];
            }
            case 1: {
                return this.magnitudesValue[1];
            }
            case 2: {
                return this.magnitudesValue[2];
            }
            case 11: {
                return this.magnitudesValue[3];
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(n - 14);
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                break;
            }
            case 2003: {
                this.invokeActions(11);
                break;
            }
            case 2000: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(this);
                }
                this.invokeActions(10);
            }
            case 2001: {
                ((DoubleValue)this.magnitudesValue[0]).value = this.tank.getHeight();
                ((DoubleValue)this.magnitudesValue[1]).value = this.tank.getWidth();
                ((DoubleValue)this.magnitudesValue[2]).value = this.tank.getLevel();
                ((ObjectValue)this.magnitudesValue[3]).value = this.tank.getProfile();
                ((DoubleValue)this.magnitudesValue[4]).value = this.tank.getX();
                ((DoubleValue)this.magnitudesValue[5]).value = this.tank.getY();
                ((DoubleValue)this.magnitudesValue[6]).value = this.tank.getZ();
                this.variablesChanged(magnitudesIndex, this.magnitudesValue);
                if (!this.isUnderEjs) break;
                this.setFieldListValues(magnitudesIndex, this.magnitudesValue);
                break;
            }
            case 2002: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(null);
                }
                this.invokeActions(0);
            }
        }
    }
}

