/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.automaticcontrol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.opensourcephysics.automaticcontrol.PoligonsAndTexts;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetGroupDrawableElement;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.ejs.control.ConstantParser;
import org.opensourcephysics.ejs.control.displayejs.ControlDrawingPanel3D;
import org.opensourcephysics.ejs.control.displayejs.ControlGroupDrawable;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlPoligonsAndTexts
extends ControlGroupDrawable
implements InteractionListener {
    protected static final int PAT_ADDED = 20;
    protected static final int VALUE = 12;
    protected static final int FILLCOLOR2 = 6;
    private DoubleValue value;
    private double lineWidth = Double.NaN;
    protected PoligonsAndTexts pat = (PoligonsAndTexts)this.myGroupDrawable;
    private static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{20, 21, 22};

    public ControlPoligonsAndTexts(Object object) {
        super(object);
        this.value = new DoubleValue(this.pat.getValue());
        this.pat.addListener(this);
    }

    protected abstract Drawable createDrawable(Object var1);

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("type");
            infoList.add("angle");
            infoList.add("lineColor");
            infoList.add("lineStroke");
            infoList.add("filled");
            infoList.add("fillColor");
            infoList.add("fillColor2");
            infoList.add("text");
            infoList.add("text2");
            infoList.add("showText");
            infoList.add("textFont");
            infoList.add("textColor");
            infoList.add("value");
            infoList.add("valueFormat");
            infoList.add("valueIncrement");
            infoList.add("movable");
            infoList.add("enabled");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("movable")) {
            return "enabledPosition";
        }
        if (string.equals("filled")) {
            return "drawingFill";
        }
        if (string.equals("valueFormat")) {
            return "format";
        }
        if (string.equals("textFont")) {
            return "font";
        }
        if (string.equals("type")) {
            return "style";
        }
        if (string.equals("lineStroke")) {
            return "stroke";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("type")) {
            return "int";
        }
        if (string.equals("angle")) {
            return "int|double";
        }
        if (string.equals("lineColor")) {
            return "Color|Object";
        }
        if (string.equals("lineStroke")) {
            return "int|double|Object";
        }
        if (string.equals("filled")) {
            return "boolean";
        }
        if (string.equals("fillColor")) {
            return "Color|Object";
        }
        if (string.equals("fillColor2")) {
            return "Color|Object";
        }
        if (string.equals("text")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("text2")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("showText")) {
            return "boolean";
        }
        if (string.equals("textFont")) {
            return "Font|Object";
        }
        if (string.equals("textColor")) {
            return "Color|Object";
        }
        if (string.equals("value")) {
            return "int|double";
        }
        if (string.equals("valueFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("valueIncrement")) {
            return "int|double";
        }
        if (string.equals("movable")) {
            return "boolean";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.pat.setType(value.getInteger());
                break;
            }
            case 1: {
                if (value instanceof IntegerValue) {
                    this.pat.setAngle((double)value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.pat.setAngle(value.getDouble());
                break;
            }
            case 2: {
                this.pat.setLineColor((Color)value.getObject());
                break;
            }
            case 3: {
                if (value.getObject() instanceof Stroke) {
                    this.pat.setLineStroke((Stroke)value.getObject());
                    break;
                }
                if (this.lineWidth == value.getDouble()) break;
                this.lineWidth = value.getDouble();
                if (this.lineWidth < 0.0) {
                    this.pat.setLineStroke(new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f));
                    break;
                }
                this.pat.setLineStroke(new BasicStroke((float)this.lineWidth));
                break;
            }
            case 4: {
                this.pat.setFilled(value.getBoolean());
                break;
            }
            case 5: {
                this.pat.setFillColor((Color)value.getObject());
                break;
            }
            case 6: {
                this.pat.setFillColor2((Color)value.getObject());
                break;
            }
            case 7: {
                this.pat.setText(value.getString());
                break;
            }
            case 8: {
                this.pat.setText2(value.getString());
                break;
            }
            case 9: {
                this.pat.setShowText(value.getBoolean());
                break;
            }
            case 10: {
                this.pat.setTextFont((Font)value.getObject());
                break;
            }
            case 11: {
                this.pat.setTextColor((Color)value.getObject());
                break;
            }
            case 12: {
                this.value.value = value.getDouble();
                this.pat.setValue(this.value.value);
                break;
            }
            case 13: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.pat.setValueFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.pat.setValueFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 14: {
                this.pat.setValueIncrement(value.getDouble());
                break;
            }
            case 15: {
                this.pat.setMovable(value.getBoolean());
                break;
            }
            case 16: {
                this.pat.setEnabled(value.getBoolean());
                break;
            }
            case 17: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                return;
            }
            case 18: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                return;
            }
            case 19: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                return;
            }
            default: {
                super.setValue(n - 20, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.pat.setType(0);
                break;
            }
            case 1: {
                this.pat.setAngle(0.0);
                break;
            }
            case 2: {
                this.pat.setLineColor(Color.BLACK);
                break;
            }
            case 3: {
                this.pat.setLineStroke(new BasicStroke());
                break;
            }
            case 4: {
                this.pat.setFilled(false);
                break;
            }
            case 5: {
                this.pat.setFillColor(null);
                break;
            }
            case 6: {
                this.pat.setFillColor2(null);
                break;
            }
            case 7: {
                this.pat.setText("");
                break;
            }
            case 8: {
                this.pat.setText2("");
                break;
            }
            case 9: {
                this.pat.setShowText(true);
                break;
            }
            case 10: {
                this.pat.setTextFont(new Font("Dialog", 0, 12));
                break;
            }
            case 11: {
                this.pat.setTextColor(Color.BLACK);
                break;
            }
            case 12: {
                this.value.value = 0.0;
                this.pat.setValue(0.0);
                break;
            }
            case 13: {
                this.pat.setValueFormat(new DecimalFormat("0.000;-0.000"));
                break;
            }
            case 14: {
                this.pat.setValueIncrement(0.1);
                break;
            }
            case 15: {
                this.pat.setMovable(false);
                break;
            }
            case 16: {
                this.pat.setEnabled(false);
                break;
            }
            case 17: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 18: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 19: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            default: {
                super.setDefaultValue(n - 20);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "BLACK";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "false";
            }
            case 5: {
                return "null";
            }
            case 6: {
                return "null";
            }
            case 7: 
            case 8: {
                return "<none>";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return "Dialog,PLAIN,12";
            }
            case 11: {
                return "BLACK";
            }
            case 12: {
                return "0";
            }
            case 13: {
                return "0.000;-0.000";
            }
            case 14: {
                return "0.1";
            }
            case 15: 
            case 16: {
                return "false";
            }
            case 17: 
            case 18: 
            case 19: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(n - 20);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return null;
            }
            case 12: {
                return this.value;
            }
        }
        return super.getValue(n - 20);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int getValueIndex() {
        return 12;
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                break;
            }
            case 2003: {
                this.invokeActions(11);
                break;
            }
            case 2000: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(this);
                }
                this.invokeActions(10);
            }
            case 2001: {
                if (((InteractionTargetGroupDrawableElement)interactionEvent.getTarget()).getElement() == this.pat.getText()) {
                    this.value.value = this.pat.getValue();
                    this.variableChanged(this.getValueIndex(), this.value);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValue(this.getValueIndex(), this.value);
                    break;
                }
                this.posValues[0].value = this.pat.getX();
                this.posValues[1].value = this.pat.getY();
                this.posValues[2].value = this.pat.getZ();
                this.variablesChanged(this.getPosSpot(), this.posValues);
                if (!this.isUnderEjs) break;
                this.setFieldListValues(this.getPosSpot(), this.posValues);
                break;
            }
            case 2002: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(null);
                }
                this.invokeActions(0);
            }
        }
    }
}

