/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.lang.reflect.Method;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class MethodWithOneParameter {
    private String methodName;
    private int methodType;
    private boolean isArray = false;
    private Object targetObject = null;
    private Object[] parameterList = new Object[0];
    private Method methodToCall;
    private MethodWithOneParameter secondMethod = null;
    private Value returnValue = null;

    public MethodWithOneParameter(int n, Object object, String string, String string2, MethodWithOneParameter methodWithOneParameter, Object object2) {
        Object object3;
        Class[] classArray = new Class[]{};
        Object object4 = null;
        Class<Object> clazz = null;
        this.methodName = string;
        this.methodType = n;
        this.targetObject = object;
        this.secondMethod = methodWithOneParameter;
        String[] stringArray = MethodWithOneParameter.splitMethodName(string.trim());
        if ("#CONTROL#".equals(stringArray[2]) && object2 != null) {
            object4 = object2;
            clazz = object2.getClass();
        } else {
            object3 = Value.parseConstant(stringArray[2], false);
            if (object3 == null) {
                object4 = null;
            } else if (object3 instanceof StringValue) {
                object4 = ((Value)object3).getString();
                clazz = string.getClass();
            } else if (object3 instanceof BooleanValue) {
                object4 = new Boolean(((Value)object3).getBoolean());
                clazz = Boolean.TYPE;
            } else if (object3 instanceof DoubleValue) {
                object4 = new Double(((Value)object3).getDouble());
                clazz = Double.TYPE;
            } else if (object3 instanceof IntegerValue) {
                object4 = new Integer(((Value)object3).getInteger());
                clazz = Integer.TYPE;
            }
        }
        if (object4 != null) {
            classArray = new Class[]{clazz};
            this.parameterList = new Object[1];
            this.parameterList[0] = object4;
        }
        this.methodToCall = MethodWithOneParameter.resolveMethod(this.targetObject, stringArray[1], classArray);
        object3 = this.methodToCall.getReturnType();
        this.isArray = ((Class)object3).isArray();
        if (this.methodToCall == null) {
            System.err.println(this.getClass().getName() + " : Error! Unable to find a suitable method " + this.methodName + " in class " + this.targetObject.getClass().getName());
        }
        this.returnValue = this.isArray ? new ObjectValue(null) : (string2 == null ? null : ((string2 = string2.trim().toLowerCase()).equals("double") ? new DoubleValue(0.0) : (string2.equals("int") ? new IntegerValue(0) : (string2.equals("string") ? new StringValue("") : (string2.equals("boolean") ? new BooleanValue(false) : (string2.equals("object") ? new ObjectValue(null) : null))))));
    }

    public Value invoke(int n, Object object) {
        if (this.methodType != n) {
            return null;
        }
        try {
            if (this.isArray) {
                ((ObjectValue)this.returnValue).value = this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue == null) {
                this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof DoubleValue) {
                ((DoubleValue)this.returnValue).value = (Double)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof IntegerValue) {
                ((IntegerValue)this.returnValue).value = (Integer)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof BooleanValue) {
                ((BooleanValue)this.returnValue).value = (Boolean)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof StringValue) {
                Object object2 = this.methodToCall.invoke(this.targetObject, this.parameterList);
                ((StringValue)this.returnValue).value = object2 == null ? null : this.methodToCall.invoke(this.targetObject, this.parameterList).toString();
            } else if (this.returnValue instanceof ObjectValue) {
                ((ObjectValue)this.returnValue).value = this.methodToCall.invoke(this.targetObject, this.parameterList);
            }
            if (this.secondMethod != null) {
                this.secondMethod.invoke(n, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
        return this.returnValue;
    }

    public boolean equals(int n, Object object, String string) {
        if (this.methodType != n) {
            return false;
        }
        if (this.targetObject != object) {
            return false;
        }
        return this.methodName.equals(string);
    }

    public String toString() {
        return this.methodName;
    }

    public static Method resolveMethod(Object object, String string, Class[] classArray) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray2;
            if (!methodArray[i].getName().equals(string) || (classArray2 = methodArray[i].getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j].isAssignableFrom(classArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return methodArray[i];
        }
        return null;
    }

    public static String[] splitMethodName(String string) {
        String[] stringArray = new String[3];
        String string2 = string;
        int n = string.indexOf(46);
        int n2 = string.indexOf(40);
        if (n > 0 && (n2 < 0 || n2 > n)) {
            stringArray[0] = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            stringArray[0] = null;
        }
        n = string2.indexOf("(");
        if (n <= 0) {
            stringArray[1] = string2;
            stringArray[2] = "";
        } else {
            stringArray[1] = string2.substring(0, n).trim();
            n2 = (string2 = string2.substring(n)).lastIndexOf(41);
            if (n2 < 0) {
                System.err.println(" : Error! Incorrect method description " + string);
                return null;
            }
            stringArray[2] = string2.substring(1, n2).trim();
        }
        return stringArray;
    }
}

