/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;
import netscape.javascript.JSObject;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.ejs.EmersionLink;
import org.opensourcephysics.ejs.Experiment;
import org.opensourcephysics.ejs.Input;
import org.opensourcephysics.ejs.LauncherApplet;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.View;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.SpecialRender;
import org.opensourcephysics.ejs.utils.GIFEncoder;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;
import org.opensourcephysics.tools.VideoCaptureTool;

public abstract class Simulation
implements Runnable,
ActionListener {
    static ResourceBundle launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", Locale.getDefault());
    static ResourceBundle ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", Locale.getDefault());
    public static int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    public static final int MINIMUM_DELAY = 10;
    private static String pathToLibrary = "";
    static AWTEventListener focusListener = null;
    private Model model = null;
    private View view = null;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private ArrayList stateVariablesList = null;
    private Thread thread = null;
    private boolean autoplay = false;
    private boolean isPlaying = false;
    private boolean updateView = true;
    private long delay = 10L;
    private URL codebase = null;
    private int stepsPerDisplay = 1;
    private VideoCaptureTool videoTool = null;
    private Component videoComponent;
    private BufferedImage videoImage = null;
    private SpecialRender videoSpecialRender = null;
    private Simulation master = null;
    private ArrayList slaveList = new ArrayList();
    private String resetFile = null;
    private static ArrayList resourcesExtracted = new ArrayList();
    private static String homeDir = null;
    private static String userDir = null;
    public int counter = 0;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private static final String dummy = "";
    private static final Class strClass = "".getClass();
    private static Hashtable memory = new Hashtable();
    private EmersionLink eMersion = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    protected JSObject htmlWindow = null;
    private JPopupMenu popupMenu = null;
    private JMenu langMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    private Experiment currentExperiment = null;

    public static String getEjsString(String string) {
        return ejsRes.getString(string);
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String string) {
        try {
            File file = new File(string + "_library");
            if (file.exists() && file.isDirectory()) {
                pathToLibrary = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = userDir + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = homeDir + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return Simulation.getHomeDir() + "Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File requiresResourceFile(String string) {
        return Simulation.requiresResourceFile(string, string);
    }

    public static File requiresResourceFile(String string, String string2) {
        File file = null;
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            file = resource.getFile();
        }
        if (file != null && file.exists()) {
            return file;
        }
        return Simulation.extractResource(string, Simulation.getTemporaryDir() + string2);
    }

    public static File extractResource(String string, String string2) {
        File file = new File(string2);
        try {
            int n;
            InputStream inputStream = ResourceLoader.openInputStream(string);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            resourcesExtracted.add(file);
            System.out.println("Ejs simulation: resource " + string + " extracted into " + string2);
            return file;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted into " + string2);
            exception.printStackTrace();
            return null;
        }
    }

    private static void cleanExtractedResources() {
        if (resourcesExtracted.size() <= 0) {
            return;
        }
        System.out.println("Ejs simulation: Cleaning extracted files.");
        for (File file : resourcesExtracted) {
            System.out.println("Ejs simulation: wants to delete " + file.getPath());
            if (!file.exists()) continue;
            System.out.println("Ejs simulation: Removing extracted resource " + file.getPath());
            file.delete();
        }
        resourcesExtracted.clear();
        Simulation.removeEmptyDirs(new File(Simulation.getTemporaryDir()), true);
    }

    public static void removeEmptyDirs(File file, boolean bl) {
        if (!file.isDirectory() || !file.exists()) {
            return;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (bl) {
            Simulation.recursiveRemoveEmptyDirs(file, fileSystemView);
        } else {
            File[] fileArray = fileSystemView.getFiles(file, false);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                Simulation.recursiveRemoveEmptyDirs(fileArray[i], fileSystemView);
            }
        }
    }

    private static void recursiveRemoveEmptyDirs(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            Simulation.recursiveRemoveEmptyDirs(fileArray[i], fileSystemView);
        }
        fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
        }
    }

    private String getClassname() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getModelClassname() {
        String string = this.model.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void errorMessage(String string) {
        System.err.println(this.getClassname() + ": " + string);
    }

    private void errorMessage(Exception exception) {
        System.err.println(this.getClassname() + ": Exception caught! Text follows:");
        exception.printStackTrace(System.err);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setParentComponent(String string) {
        this.parentComponentName = string;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public Model runSimulation() {
        return this.runSimulation(null);
    }

    public Model runSimulation(String string) {
        try {
            Simulation simulation;
            Class<?> clazz = string == null ? this.getModel().getClass() : Class.forName(string);
            Model model = (Model)clazz.newInstance();
            model.getSimulation().master = simulation = this.getTopMaster();
            model.getSimulation().isPlaying = this.isPlaying;
            model.getSimulation().update();
            simulation.slaveList.add(model);
            return model;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void freeSimulation(Model model) {
        if (model == null) {
            return;
        }
        try {
            Simulation simulation = this.getTopMaster();
            simulation.slaveList.remove(model);
            model.getSimulation().master = null;
            if (model.getView() instanceof GroupControl) {
                ((GroupControl)((Object)model.getView())).undoReparenting();
            }
            if (simulation.isPlaying) {
                model.getSimulation().play();
            } else {
                model.getSimulation().isPlaying = false;
            }
            model.getSimulation().update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void killSimulation(Model model) {
        if (model == null) {
            return;
        }
        this.freeSimulation(model);
        model.getSimulation().pause();
        if (model.getView() instanceof GroupControl) {
            ((GroupControl)((Object)model.getView())).dispose();
        }
    }

    public synchronized void killAllSimulations() {
        ArrayList arrayList = this.slaveList;
        this.slaveList = new ArrayList();
        for (Model model : arrayList) {
            model.getSimulation().pause();
            model.getSimulation().master = null;
            if (!(model.getView() instanceof GroupControl)) continue;
            ((GroupControl)((Object)model.getView())).undoReparenting();
            ((GroupControl)((Object)model.getView())).dispose();
        }
    }

    public Model getTopSimulation() {
        return this.getTopMaster().getModel();
    }

    private Simulation getTopMaster() {
        if (this.master == null) {
            return this;
        }
        Simulation simulation = this.master;
        while (simulation.master != null) {
            simulation = simulation.master;
        }
        return simulation;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void translate() {
        TranslatorTool translatorTool = TranslatorTool.getTool();
        translatorTool.showProperties(this.model.getClass());
        translatorTool.setKeepHidden(false);
        translatorTool.setVisible(true);
    }

    public String translateString(String string, String string2) {
        return TranslatorTool.getTool().getProperty(this.model.getClass(), string, string2);
    }

    public String translateString(String string) {
        return TranslatorTool.getTool().getProperty(this.model.getClass(), string);
    }

    public void setLocale(String string) {
        Locale locale = new Locale(string);
        TranslatorTool.getTool().setLocale(locale);
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", locale);
        ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", locale);
        this.setViewLocale();
        this.popupMenu = null;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof GroupControl) {
            ((GroupControl)((Object)this.view)).addElementsMenuEntries();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
        this.isPlaying = true;
        Iterator iterator = this.slaveList.iterator();
        while (iterator.hasNext()) {
            ((Model)iterator.next()).getSimulation().isPlaying = true;
        }
    }

    public void play() {
        if (this.master != null) {
            this.getTopMaster().play();
            return;
        }
        Timer timer = new Timer(10, this);
        timer.setRepeats(false);
        timer.setCoalesce(true);
        timer.start();
    }

    public void pause() {
        if (this.master != null) {
            this.getTopMaster().pause();
            return;
        }
        this.thread = null;
        this.isPlaying = false;
        Iterator iterator = this.slaveList.iterator();
        while (iterator.hasNext()) {
            ((Model)iterator.next()).getSimulation().isPlaying = false;
        }
    }

    public void run() {
        while (this.thread == Thread.currentThread()) {
            this.step();
            Iterator iterator = this.slaveList.iterator();
            while (iterator.hasNext()) {
                ((Model)iterator.next()).getSimulation().step();
            }
            try {
                if (this.delay < 10L) {
                    Simulation simulation = this;
                    simulation.thread.yield();
                    continue;
                }
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void onExit() {
        Simulation.cleanExtractedResources();
        this.thread = null;
        this.isPlaying = false;
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Simulation.this.view.onExit();
                Simulation.this.model._freeMemory();
                System.gc();
            }
        });
        timer.setRepeats(false);
        timer.setCoalesce(true);
        timer.start();
    }

    public void setFPS(int n) {
        this.delay = n <= 1 ? 1000L : (n >= MAXIMUM_FPS ? 10L : Math.max((long)(1000.0 / (double)n), 10L));
    }

    public void setDelay(int n) {
        this.delay = Math.max((long)n, 0L);
    }

    public int getDelay() {
        return (int)this.delay;
    }

    public void setStepsPerDisplay(int n) {
        if (n >= 1) {
            this.stepsPerDisplay = n;
        }
    }

    public void setUpdateView(boolean bl) {
        this.updateView = bl;
    }

    public void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isPaused() {
        return !this.isPlaying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.pause();
        if (this.model != null) {
            this.model.reset();
            if (this._init_ != null) {
                this._init_.invoke(0, this.model._getApplet());
            }
            if (this.resetFile != null) {
                this.justReadVariables(this.resetFile, null, this.stateVariablesList);
            }
        }
        if (this.view != null) {
            this.view.setUpdateSimulation(false);
            this.view.reset();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                if (this.videoImage != null) {
                    this.captureVideoImage();
                }
            } else {
                this.view.collectData();
            }
            this.view.setUpdateSimulation(true);
        }
        System.gc();
        ArrayList arrayList = this.slaveList;
        synchronized (arrayList) {
            this.killAllSimulations();
        }
        if (this.autoplay) {
            this.play();
        }
    }

    public void initialize() {
        if (this.view != null) {
            this.view.read();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.initialize();
            if (this.updateView) {
                this.view.update();
                if (this.videoImage != null) {
                    this.captureVideoImage();
                }
            } else {
                this.view.collectData();
            }
        }
    }

    public void apply() {
        if (this.view != null) {
            this.view.read();
        }
        this.update();
    }

    public void applyAll() {
        this.view.read();
        this.update();
    }

    public void apply(String string) {
        if (this.view != null) {
            this.view.read(string);
        }
    }

    public void update() {
        if (this.model != null) {
            this.model.update();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
    }

    public void step() {
        if (this.stepsPerDisplay > 1) {
            for (int i = 1; i < this.stepsPerDisplay; ++i) {
                this.model.step();
                this.model.update();
                this.view.collectData();
            }
        }
        this.model.step();
        this.update();
        if (this.videoImage != null && this.updateView) {
            this.captureVideoImage();
        }
    }

    public void updateAfterModelAction() {
        if (this.master != null) {
            this.getTopMaster().updateAfterModelAction();
            return;
        }
        this.update();
        Iterator iterator = this.slaveList.iterator();
        while (iterator.hasNext()) {
            ((Model)iterator.next()).getSimulation().update();
        }
    }

    public void addDescriptionPage(String string, String string2) {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.descriptionDialog == null) {
            object2 = Input.getResource("DescriptionFor") + " " + this.getModelClassname();
            object = ((GroupControl)((Object)this.view)).getOwnerFrame();
            this.descriptionDialog = new JFrame((String)object2);
            this.descriptionPanel = new JTabbedPane();
            this.descriptionPanel.setPreferredSize(new Dimension(570, 410));
            this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
            this.descriptionDialog.pack();
            serializable = Toolkit.getDefaultToolkit().getScreenSize();
            this.descriptionDialog.setLocation((((Dimension)serializable).width - this.descriptionDialog.getSize().width) / 2, (((Dimension)serializable).height - this.descriptionDialog.getSize().height) / 2);
        }
        object2 = new JEditorPane();
        ((JTextComponent)object2).setEditable(false);
        object = ResourceLoader.getResource(string2);
        if (object != null) {
            try {
                ((JEditorPane)object2).setPage(((Resource)object).getURL());
                serializable = new JScrollPane((Component)object2);
                this.descriptionPanel.add(string, (Component)serializable);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + ((Resource)object).getURL());
            }
        } else {
            System.err.println("Couldn't find descrition file: " + object);
        }
    }

    public void showDescription() {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(true);
        }
    }

    public String getVariable(String string) {
        return this.getVariable(string, ",");
    }

    public String getVariable(String string, String string2) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                String string3 = dummy;
                Object object = field.get(this.model);
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    string3 = i > 0 ? string3 + string2 + Array.get(object, i).toString() : string3 + Array.get(object, i).toString();
                }
                return string3;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return null;
        }
    }

    public boolean setVariable(String string, String string2) {
        return this.setVariable(string, string2, ",");
    }

    public boolean setVariable(String string, String string2, String string3) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                boolean bl = true;
                Object object = field.get(this.model);
                int n = 0;
                int n2 = Array.getLength(object);
                Class<?> clazz = field.getType().getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                if (n2 < stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (n2 > stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (stringTokenizer.hasMoreTokens() && n < n2) {
                    String string4 = stringTokenizer.nextToken();
                    if (clazz.equals(Double.TYPE)) {
                        Array.setDouble(object, n, Double.parseDouble(string4));
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.setFloat(object, n, Float.parseFloat(string4));
                    } else if (clazz.equals(Byte.TYPE)) {
                        Array.setByte(object, n, Byte.parseByte(string4));
                    } else if (clazz.equals(Short.TYPE)) {
                        Array.setShort(object, n, Short.parseShort(string4));
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.setInt(object, n, Integer.parseInt(string4));
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.setLong(object, n, Long.parseLong(string4));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (string4.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(object, n, true);
                        } else {
                            Array.setBoolean(object, n, false);
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.setChar(object, n, string4.charAt(0));
                    } else if (clazz.equals(strClass)) {
                        Array.set(object, n, string4);
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                return bl;
            }
            Class<?> clazz = field.getType();
            if (clazz.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(string2));
            } else if (clazz.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(string2));
            } else if (clazz.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(string2));
            } else if (clazz.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(string2));
            } else if (clazz.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(string2));
            } else if (clazz.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                if (string2.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (clazz.equals(Character.TYPE)) {
                field.setChar(this.model, string2.charAt(0));
            } else if (clazz.equals(strClass)) {
                field.set(this.model, string2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return false;
        }
    }

    public boolean setVariables(String string) {
        return this.setVariables(string, ";", ",");
    }

    public boolean setVariables(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = dummy;
        String string5 = dummy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n = string6.indexOf(61);
            if (n < 0) {
                bl = false;
                continue;
            }
            string4 = string6.substring(0, n).trim();
            boolean bl2 = this.setVariable(string4, string5 = string6.substring(n + 1).trim(), string3);
            if (bl2) continue;
            bl = false;
        }
        this.update();
        return bl;
    }

    public void initEmersion() {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            return;
        }
        try {
            String string = launcherApplet.getParameter("init");
            if (string != null) {
                this._init_ = new MethodWithOneParameter(0, launcherApplet._model, string, null, null, launcherApplet);
                this._init_.invoke(0, launcherApplet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (launcherApplet.getParameter("eMersionURL") == null) {
            return;
        }
        this.eMersion = new EmersionLink(launcherApplet, this);
    }

    public boolean isEmersionConnected() {
        if (this.eMersion == null) {
            return false;
        }
        return this.eMersion.isConnected();
    }

    public void ejsPopup(String string) {
        String string2 = "window.open('" + string + "', 'ejspopup', 'menubar=0,location=0,scrollbars,resizable,width=100,height=100');";
        this.ejsEval(string2);
    }

    public void ejsEval(String string) {
        if (this.javascriptControlMode(false)) {
            if (this.htmlWindow == null) {
                this.htmlWindow = JSObject.getWindow((Applet)this.javascriptControledApplet);
            }
            this.htmlWindow.eval(string);
        }
    }

    public void ejsCommand(String[] stringArray) {
        this.ejsCommand("ejsCommand", stringArray);
    }

    public void ejsCommand(String string, String[] stringArray) {
        if (this.javascriptControlMode(false)) {
            if (this.htmlWindow == null) {
                this.htmlWindow = JSObject.getWindow((Applet)this.javascriptControledApplet);
            }
            this.htmlWindow.call(string, stringArray);
        }
    }

    private boolean javascriptControlMode() {
        return this.javascriptControlMode(true);
    }

    private boolean javascriptControlMode(boolean bl) {
        if (this.javascriptControledApplet == null) {
            this.javascriptControledApplet = this.model._getApplet();
        }
        if (this.javascriptControledApplet == null || this.isEmersionConnected()) {
            return false;
        }
        if (bl) {
            boolean bl2 = true;
            try {
                System.getProperty("user.dir");
            }
            catch (Exception exception) {
                bl2 = false;
            }
            return !bl2;
        }
        return true;
    }

    public static boolean isImageFormatSupported(String string) {
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public AbstractList getExperiments() {
        return null;
    }

    public Experiment createExperiment(String string) {
        return null;
    }

    public void runExperiment(Experiment experiment) {
        if (experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = experiment;
        experiment._runExperiment();
    }

    public void runExperiment(String string) {
        this.runExperiment(this.createExperiment(string));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(AbstractList abstractList) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList();
        }
        this.popupMenuExtraEntries.addAll(abstractList);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String string, AbstractList abstractList) {
        Serializable serializable;
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            serializable = new ArrayList();
            ((ArrayList)serializable).add(this.elementsMenu);
            this.addMenuEntries((AbstractList)((Object)serializable));
        }
        serializable = new JMenu(string);
        Iterator iterator = abstractList.iterator();
        while (iterator.hasNext()) {
            this.addMenuItem((JComponent)serializable, iterator.next());
        }
        this.addMenuItem(this.elementsMenu, serializable);
    }

    public Component getTopLevelComponent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }

    public void getPopupMenu(Component component, String string) {
        this.getPopupMenu(component, -1, -1, string);
    }

    public void getPopupMenu(final Component component, int n, int n2, final String string) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = bl = this.model._getApplet() != null;
        if (this.popupMenu == null) {
            Object object3;
            boolean bl3 = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                bl3 = false;
            }
            this.popupMenu = new JPopupMenu();
            object2 = this.getExperiments();
            if (object2 != null) {
                object3 = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                object = ((AbstractList)object2).iterator();
                while (object.hasNext()) {
                    final Experiment experiment = (Experiment)object.next();
                    String string2 = this.translateString(experiment._getName());
                    String string3 = this.translateString(experiment._getDescription());
                    AbstractAction abstractAction = new AbstractAction(string2){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.runExperiment(experiment);
                        }
                    };
                    abstractAction.putValue("ShortDescription", string3);
                    ((JMenu)object3).add(abstractAction);
                }
                this.popupMenu.add((JMenuItem)object3);
                object = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
                this.popupMenu.addSeparator();
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                object3 = this.popupMenuExtraEntries.iterator();
                while (object3.hasNext()) {
                    this.addMenuItem(this.popupMenu, object3.next());
                }
                this.popupMenu.addSeparator();
            }
            if (bl3) {
                object3 = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Snapshot")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = Simulation.this.isPlaying();
                        if (bl) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(string);
                        if (bl) {
                            Simulation.this.play();
                        }
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            PrintUtils.saveComponentAsEPS(Simulation.this.getTopLevelComponent(component));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        focusListener = new AWTEventListener(){

                            public void eventDispatched(AWTEvent aWTEvent) {
                                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                                if (windowEvent.getID() == 207) {
                                    Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                    try {
                                        PrintUtils.saveComponentAsEPS(windowEvent.getWindow());
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                        };
                        System.out.println("Put the focus on the window you want to capture");
                        Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.startVideoTool(string);
                    }
                });
                this.popupMenu.add((JMenuItem)object3);
                object = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.saveState(null);
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
            }
            object3 = new JMenu(this.getMenuText("ejs_res:MenuItem.GUI"));
            if (!bl) {
                this.langMenu = new JMenu(this.getMenuText("tools_res:TranslatorTool.Label.Description"));
                ((JMenu)object3).add(this.langMenu);
                if (bl3) {
                    ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:TranslatorTool.Title")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.translate();
                        }
                    });
                }
            }
            object = new JMenu(this.getMenuText("display_res:DrawingFrame.Font_menu_title"));
            ((JMenu)object).add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.IncreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelUp();
                    Iterator iterator = Simulation.this.getWindowsList().iterator();
                    while (iterator.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)iterator.next()), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object).add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.DecreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelDown();
                    Iterator iterator = Simulation.this.getWindowsList().iterator();
                    while (iterator.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)iterator.next()), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object3).add((JMenuItem)object);
            this.popupMenu.add((JMenuItem)object3);
            this.popupMenu.addSeparator();
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Input.getResource("ShowDescription")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (bl3 && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(launcherRes.getString("Popup.MenuItem.EjsModel")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EjsTool.runEjs(Simulation.this.getModel().getClass());
                    }
                });
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog.getOSPLog().setLocationRelativeTo(Simulation.this.parentComponent);
                    OSPLog.showLog();
                }
            });
        }
        if (this.langMenu != null) {
            this.langMenu.removeAll();
            Locale[] localeArray = TranslatorTool.getTool().getTranslatedLocales(this.model.getClass());
            object2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Simulation.this.setLocale(actionEvent.getActionCommand());
                }
            };
            for (int i = 0; i < localeArray.length; ++i) {
                object = new JMenuItem(localeArray[i].getDisplayLanguage(localeArray[i]));
                ((AbstractButton)object).setActionCommand(localeArray[i].getLanguage());
                ((AbstractButton)object).addActionListener((ActionListener)object2);
                this.langMenu.add((JMenuItem)object);
            }
        }
        this.popupTriggeredBy = component;
        if (n >= 0 && n2 >= 0) {
            this.popupMenu.show(component, n, n2);
        } else {
            this.popupMenu.show(component, (component.getWidth() - this.popupMenu.getWidth()) / 2, (component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    private String getMenuText(String string) {
        String string2 = string.startsWith("ejs_res:") ? ejsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("tools_res:") ? ToolsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("display_res:") ? DisplayRes.getString(string.substring(string.indexOf(58) + 1)) : ToolsRes.getString(string)));
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = DisplayRes.getString(string);
        }
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = string;
        }
        return string2;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            jMenu.setText(this.getMenuText(jMenu.getActionCommand()));
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.processMenuTexts(jMenu.getItem(i));
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            jMenuItem.setText(this.getMenuText(jMenuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent jComponent, Object object) {
        if (object instanceof Action) {
            final Action action = (Action)object;
            String string = (String)action.getValue("Name");
            String string2 = this.getMenuText(string);
            AbstractAction abstractAction = new AbstractAction(string2){

                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(actionEvent);
                }
            };
            abstractAction.putValue("ShortDescription", string2);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(abstractAction);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(abstractAction);
            }
        } else if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            this.processMenuTexts(jMenu);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenu);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            this.processMenuTexts(jMenuItem);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenuItem);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenuItem);
            }
        }
    }

    public ArrayList getWindowsList() {
        return new ArrayList();
    }

    public boolean startVideoTool(String string) {
        this.videoImage = null;
        this.videoComponent = null;
        this.videoSpecialRender = null;
        if (this.view == null) {
            return false;
        }
        Component component = this.view.getComponent(string);
        if (component == null) {
            System.err.println("Component not found: " + string);
            return false;
        }
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        } else if (component instanceof JDialog) {
            component = ((JDialog)component).getContentPane();
        }
        this.videoImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        this.videoComponent = component;
        ControlElement controlElement = this.view.getElement(string);
        if (controlElement instanceof SpecialRender) {
            this.videoSpecialRender = (SpecialRender)((Object)controlElement);
        }
        if (this.videoTool == null) {
            this.videoTool = VideoGrabber.getTool();
        }
        this.videoTool.setVisible(true);
        this.videoTool.clear();
        return true;
    }

    private void captureVideoImage() {
        if (this.videoSpecialRender != null) {
            this.videoSpecialRender.render(this.videoImage);
        } else {
            Graphics graphics = this.videoImage.getGraphics();
            this.videoComponent.paint(graphics);
            graphics.dispose();
        }
        this.videoTool.addFrame(this.videoImage);
    }

    public boolean saveImage(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string2 = gregorianCalendar.get(1) + dummy + decimalFormat.format(gregorianCalendar.get(2)) + dummy + decimalFormat.format(gregorianCalendar.get(5)) + "_" + decimalFormat.format(gregorianCalendar.get(11)) + dummy + decimalFormat.format(gregorianCalendar.get(12)) + dummy + decimalFormat.format(gregorianCalendar.get(13));
        return this.saveImage(this.getClassname() + "_" + string2 + ".jpg", string);
    }

    public boolean saveImageAs(String string) {
        return this.saveImage(null, string);
    }

    public boolean saveImage(String string, String string2) {
        if (this.view == null) {
            return false;
        }
        ControlElement controlElement = this.view.getElement(string2);
        if (controlElement == null) {
            System.err.println("Component not found: " + string2);
            return false;
        }
        Component component = controlElement.getComponent();
        if (this.isEmersionConnected() || this.javascriptControlMode()) {
            Object object;
            if (component instanceof JFrame) {
                component = ((JFrame)component).getContentPane();
            } else if (component instanceof JDialog) {
                component = ((JDialog)component).getContentPane();
            }
            BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
            if (controlElement instanceof SpecialRender) {
                ((SpecialRender)((Object)controlElement)).render(bufferedImage);
            } else {
                object = bufferedImage.getGraphics();
                component.paint((Graphics)object);
                ((Graphics)object).dispose();
            }
            if (string == null) {
                string = "default.gif";
            }
            if (this.isEmersionConnected()) {
                return this.eMersion.saveImage(string, "GIF image", bufferedImage) != null;
            }
            try {
                object = "jpg";
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    object = string.substring(n + 1).toLowerCase();
                } else {
                    string = string + "." + (String)object;
                }
                boolean bl = Simulation.isImageFormatSupported((String)object);
                if (!bl && !"gif".equalsIgnoreCase((String)object)) {
                    System.err.println("Format not supported : " + (String)object);
                    return false;
                }
                OutputStream outputStream = null;
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(string);
                boolean bl2 = true;
                if (bl) {
                    bl2 = ImageIO.write((RenderedImage)bufferedImage, (String)object, outputStream);
                } else {
                    try {
                        GIFEncoder gIFEncoder = new GIFEncoder(bufferedImage);
                        gIFEncoder.Write(outputStream);
                    }
                    catch (Exception exception) {
                        bl2 = false;
                        exception.printStackTrace();
                    }
                }
                outputStream.close();
                if (!bl2) {
                    return false;
                }
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
                } else if (this.javascriptControlMode()) {
                    this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(string, component, null);
    }

    public void processArguments(String[] stringArray) {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            int n;
            if (stringArray != null && stringArray.length > 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].toLowerCase().endsWith(".xml")) continue;
                    this.readState(stringArray[n]);
                }
            }
            n = 1;
            if (OSPRuntime.isLauncherMode()) {
                n = 0;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        n = 0;
                    } else if ("true".equals(System.getProperty("osp_ejs"))) {
                        n = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n != 0) {
                this.showDescription();
            }
        }
    }

    public static ArrayList toArrayList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public ArrayList getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(ArrayList arrayList) {
        this.stateVariablesList = arrayList;
    }

    public void setStateVariablesList(String string) {
        this.stateVariablesList = Simulation.toArrayList(string);
    }

    public boolean saveState(String string) {
        return this.saveVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string) {
        return this.readVariables(string, (URL)null, this.stateVariablesList);
    }

    public boolean readState(String string, URL uRL) {
        return this.readVariables(string, uRL, this.stateVariablesList);
    }

    public boolean saveVariables(String string, String string2) {
        return this.saveVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, String string2) {
        return this.readVariables(string, uRL, Simulation.toArrayList(string2));
    }

    public boolean saveVariables(String string, ArrayList arrayList) {
        Object object;
        if (this.model == null) {
            return false;
        }
        if (string == null) {
            object = OSPRuntime.createChooser("XML", new String[]{"xml"});
            ((JFileChooser)object).setSelectedFile(new File(this.getModelClassname() + "_Variables.xml"));
            string = OSPRuntime.chooseFilename((JFileChooser)object, this.popupTriggeredBy, true);
            if (string == null) {
                return false;
            }
            if (string.lastIndexOf(46) < string.length() - 5) {
                string = string + ".xml";
            }
        }
        try {
            int n;
            Object object2;
            object = null;
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                object = new XMLControlElement(this.getClass());
            } else {
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") || this.isEmersionConnected() ? new ByteArrayOutputStream() : new FileOutputStream(string);
                object2 = new BufferedOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream((OutputStream)object2);
            }
            object2 = this.model.getClass().getFields();
            if (arrayList == null) {
                for (n = 0; n < ((Field[])object2).length; ++n) {
                    if (!(object2[n].get(this.model) instanceof Serializable)) continue;
                    if (object != null) {
                        ((XMLControlElement)object).setValue(object2[n].getName(), object2[n].get(this.model));
                        continue;
                    }
                    objectOutputStream.writeObject(object2[n].get(this.model));
                }
            } else {
                int n2 = arrayList.size();
                block3: for (n = 0; n < n2; ++n) {
                    String string2 = ((String)arrayList.get(n)).trim();
                    for (int i = 0; i < ((Field[])object2).length; ++i) {
                        if (!(object2[i].get(this.model) instanceof Serializable) || !object2[i].getName().equals(string2)) continue;
                        if (object != null) {
                            ((XMLControlElement)object).setValue(object2[i].getName(), object2[i].get(this.model));
                            continue block3;
                        }
                        objectOutputStream.writeObject(object2[i].get(this.model));
                        continue block3;
                    }
                }
            }
            if (object != null) {
                Writer writer;
                if (string.startsWith("ejs:")) {
                    writer = new CharArrayWriter();
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveXML(string, "XML file", ((XMLControlElement)object).toXML()) != null;
                    }
                    writer = new FileWriter(string);
                }
                ((XMLControlElement)object).write(writer);
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                objectOutputStream.close();
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveBinary(string, "Binary data", ((ByteArrayOutputStream)outputStream).toByteArray()) != null;
                    }
                    if (this.javascriptControlMode()) {
                        this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save " + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean readVariables(String string, URL uRL, ArrayList arrayList) {
        boolean bl;
        if (this.model == null) {
            return false;
        }
        if (string == null) {
            JFileChooser jFileChooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            jFileChooser.setSelectedFile(new File(this.getModelClassname() + "_Variables.xml"));
            string = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, false);
            if (string == null) {
                return false;
            }
        }
        if (uRL == null && arrayList == this.stateVariablesList) {
            this.resetFile = string;
        }
        if (bl = this.justReadVariables(string, uRL, arrayList)) {
            if (this.view != null) {
                this.view.initialize();
            }
            this.updateAfterModelAction();
        }
        return bl;
    }

    private boolean justReadVariables(String string, URL uRL, ArrayList arrayList) {
        try {
            CharSequence charSequence;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl = true;
            URLConnection uRLConnection = null;
            Reader reader = null;
            if (string.startsWith("ejs:")) {
                bl = memory.get(string) != null;
            } else if (!this.isEmersionConnected()) {
                if (string.startsWith("url:")) {
                    object4 = string.substring(4);
                    if (uRL != null && !((String)object4).startsWith("http:")) {
                        object4 = uRL + (String)object4;
                    }
                    try {
                        uRLConnection = new URL((String)object4).openConnection();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    reader = ResourceLoader.openReader(string);
                    boolean bl2 = bl = reader != null;
                }
            }
            if (!bl) {
                return false;
            }
            object4 = null;
            ObjectInputStream objectInputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                object3 = null;
                if (uRLConnection != null) {
                    object3 = (String)uRLConnection.getContent();
                } else {
                    object2 = null;
                    if (string.startsWith("ejs:")) {
                        object2 = new CharArrayReader((char[])memory.get(string));
                    } else if (this.isEmersionConnected()) {
                        object3 = this.eMersion.readXML(string);
                    } else {
                        object2 = reader;
                    }
                    if (object2 != null) {
                        object = new LineNumberReader((Reader)object2);
                        charSequence = new StringBuffer();
                        String string2 = ((LineNumberReader)object).readLine();
                        while (string2 != null) {
                            charSequence.append(string2 + "\n");
                            string2 = ((LineNumberReader)object).readLine();
                        }
                        object2.close();
                        object3 = charSequence.toString();
                    }
                }
                object4 = new XMLControlElement(this.getClass());
                if (!((XMLControlElement)object4).readXMLForClass((String)object3, this.getClass())) {
                    return true;
                }
            } else {
                if (uRLConnection != null) {
                    object3 = uRLConnection.getInputStream();
                } else if (string.startsWith("ejs:")) {
                    object3 = new ByteArrayInputStream((byte[])memory.get(string));
                } else if (this.isEmersionConnected()) {
                    object2 = this.eMersion.readBinary(string);
                    if (object2 == null) {
                        return false;
                    }
                    object3 = new ByteArrayInputStream((byte[])object2);
                } else {
                    object3 = new FileInputStream(string);
                }
                if (object3 == null) {
                    return false;
                }
                objectInputStream = new ObjectInputStream(new BufferedInputStream((InputStream)object3));
            }
            object3 = this.model.getClass().getFields();
            if (arrayList == null) {
                for (int i = 0; i < ((Field[])object3).length; ++i) {
                    if (!(object3[i].get(this.model) instanceof Serializable)) continue;
                    if (object4 != null) {
                        object = ((XMLControlElement)object4).getObject(object3[i].getName());
                        if (object == null) continue;
                        object3[i].set(this.model, object);
                        continue;
                    }
                    object3[i].set(this.model, objectInputStream.readObject());
                }
            } else {
                int n = arrayList.size();
                block6: for (int i = 0; i < n; ++i) {
                    charSequence = ((String)arrayList.get(i)).trim();
                    for (int j = 0; j < ((Field[])object3).length; ++j) {
                        if (!(object3[j].get(this.model) instanceof Serializable)) continue;
                        if (!object3[j].getName().equals(charSequence)) continue block6;
                        if (object4 != null) {
                            Object object5 = ((XMLControlElement)object4).getObject((String)charSequence);
                            if (object5 == null) continue block6;
                            object3[j].set(this.model, object5);
                            continue block6;
                        }
                        object3[j].set(this.model, objectInputStream.readObject());
                        continue block6;
                    }
                }
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveText(String string, String string2) {
        try {
            Writer writer;
            if (string.startsWith("ejs:")) {
                writer = new CharArrayWriter();
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.saveXML(string, "XML file", string2) != null;
                    }
                    return this.eMersion.saveText(string, "Text file", string2) != null;
                }
                writer = new FileWriter(string);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            if (string.startsWith("ejs:")) {
                memory.put(string, ((CharArrayWriter)writer).toCharArray());
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error when trying to save" + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String string, StringBuffer stringBuffer) {
        return this.saveText(string, stringBuffer.toString());
    }

    public String readText(String string) {
        return this.readText(string, null);
    }

    public String readText(String string, URL uRL) {
        if (string.startsWith("url:")) {
            String string2 = string.substring(4);
            if (uRL != null && !string2.startsWith("http:")) {
                string2 = uRL + string2;
            }
            try {
                return (String)new URL(string2).getContent();
            }
            catch (Exception exception) {
                System.err.println("Error when trying to read " + string);
                exception.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader reader;
            if (string.startsWith("ejs:")) {
                reader = new CharArrayReader((char[])memory.get(string));
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.readXML(string);
                    }
                    return this.eMersion.readText(string);
                }
                reader = new FileReader(string);
            }
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = lineNumberReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3 + "\n");
                string3 = lineNumberReader.readLine();
            }
            reader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            return null;
        }
    }
}

