/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.View;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class LauncherApplet
extends JApplet {
    private JFrame _parentFrame = null;
    public Model _model = null;
    public Simulation _simulation = null;
    public View _view = null;
    private byte[] imageByteArray = null;
    private byte[] stateByteArray = null;

    public void init() {
        super.init();
        String string = this.getParameter("bqServer");
        if (string != null) {
            ResourceLoader.addSearchPath(string);
        }
    }

    public void _play() {
        this._simulation.play();
    }

    public void _pause() {
        this._simulation.pause();
    }

    public void _step() {
        this._simulation.step();
    }

    public void _setFPS(int n) {
        this._simulation.setFPS(n);
    }

    public void _setDelay(int n) {
        this._simulation.setDelay(n);
    }

    public void _reset() {
        this._model._reset();
    }

    public void _initialize() {
        this._model._initialize();
    }

    public boolean _isPlaying() {
        return this._simulation.isPlaying();
    }

    public boolean _isPaused() {
        return this._simulation.isPaused();
    }

    public void _setParentComponent(String string) {
        this._simulation.setParentComponent(string);
    }

    public boolean _saveImage(String string, String string2) {
        return this._simulation.saveImage(string, string2);
    }

    public boolean _saveState(String string) {
        return this._simulation.saveState(string);
    }

    public boolean _saveVariables(String string, String string2) {
        return this._simulation.saveVariables(string, string2);
    }

    public boolean _saveVariables(String string, ArrayList arrayList) {
        return this._simulation.saveVariables(string, arrayList);
    }

    public boolean _saveText(String string, String string2) {
        return this._simulation.saveText(string, string2);
    }

    public boolean _saveText(String string, StringBuffer stringBuffer) {
        return this._simulation.saveText(string, stringBuffer);
    }

    public boolean _readState(String string) {
        return this._simulation.readState(string);
    }

    public boolean _readVariables(String string, String string2) {
        return this._simulation.readVariables(string, (URL)null, string2);
    }

    public boolean _readVariables(String string, ArrayList arrayList) {
        return this._simulation.readVariables(string, (URL)null, arrayList);
    }

    public String _readText(String string) {
        return this._simulation.readText(string);
    }

    public boolean _setVariables(String string, String string2, String string3) {
        return this._simulation.setVariables(string, string2, string3);
    }

    public boolean _setVariables(String string) {
        return this._simulation.setVariables(string);
    }

    public String _getVariables(String string) {
        return this._simulation.getVariable(string);
    }

    public void _clearView() {
        if (this._view != null) {
            this._view.initialize();
        }
    }

    public void _resetView() {
        if (this._view != null) {
            this._view.reset();
            this._view.initialize();
        }
    }

    public void _alert(String string, String string2, String string3) {
        this._model._alert(string, string2, string3);
    }

    public void _print(String string) {
        if (this._view != null) {
            this._view.print(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println(String string) {
        if (this._view != null) {
            this._view.println(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println() {
        if (this._view != null) {
            this._view.println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this._view != null) {
            this._view.clearMessages();
        }
    }

    public String _format(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    protected Frame getParentFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    protected Component captureWindow(View view, String string) {
        if (string == null) {
            return null;
        }
        Container container = this._parentFrame != null ? this._parentFrame : this;
        Component component = view.getComponent(string);
        if (component == null) {
            return null;
        }
        Dimension dimension = component.getSize();
        if (component instanceof DrawingFrame) {
            component.setVisible(true);
            Container container2 = ((RootPaneContainer)((Object)component)).getContentPane();
            container2.setVisible(true);
            container.setContentPane(container2);
            Component component2 = ((RootPaneContainer)((Object)component)).getGlassPane();
            container.setGlassPane(component2);
            component2.setVisible(true);
            ((DrawingFrame)component).setKeepHidden(true);
            ((DrawingFrame)component).setDefaultCloseOperation(2);
        } else if (component instanceof JDialog) {
            component.setVisible(true);
            Container container3 = ((RootPaneContainer)((Object)component)).getContentPane();
            container3.setVisible(true);
            container.setContentPane(container3);
            Component component3 = ((RootPaneContainer)((Object)component)).getGlassPane();
            container.setGlassPane(component3);
            component3.setVisible(true);
            ((JDialog)component).dispose();
        } else {
            container.getContentPane().setLayout(new BorderLayout());
            container.getContentPane().add(component, "Center");
            container.getContentPane().validate();
            Container container4 = component.getParent();
            if (container4 != null) {
                container4.validate();
            }
        }
        if (this._parentFrame != null) {
            this._parentFrame.pack();
        }
        return container.getContentPane();
    }

    public Component _getMainComponent() {
        return null;
    }

    public void setImageByteArray(byte[] byArray) {
        this.imageByteArray = byArray;
    }

    private String byteArray2String(byte[] byArray) {
        if (byArray.length < 1) {
            return "";
        }
        String string = "" + byArray[0];
        for (int i = 1; i < byArray.length; ++i) {
            string = string + "_" + byArray[i];
        }
        return string;
    }

    public String imageByteData() {
        return this.byteArray2String(this.imageByteArray);
    }

    public void setStateByteArray(byte[] byArray) {
        this.stateByteArray = byArray;
    }

    public String stateByteData() {
        return this.byteArray2String(this.stateByteArray);
    }

    public String frameName() {
        return this._getMainComponent().getName();
    }
}

