/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.displayejs.InteractiveCylinder;
import org.opensourcephysics.displayejs.Resolution;

public class InteractiveCone
extends InteractiveCylinder {
    protected double[] nextCenter = new double[]{0.0, 0.0, 0.0};

    public InteractiveCone() {
        this(2);
    }

    public InteractiveCone(int n) {
        this.setSizeXYZ(0.2, 0.2, 0.5);
        this.setResolution(new Resolution(3, 12, 5));
        this.setDirection(n);
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        double d2 = this.sizex / 2.0;
        double d3 = this.sizey / 2.0;
        double d4 = this.sizez;
        int n5 = 1;
        int n6 = 1;
        int n7 = 1;
        double d5 = this.maxangleu;
        double d6 = this.minangleu;
        if (Math.abs(d5 - d6) > 360.0) {
            d5 = d6 + 360.0;
        }
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n5 = Math.max(this.resolution.n1, 1);
                    n6 = Math.max(this.resolution.n2, 1);
                    n7 = Math.max(this.resolution.n3, 1);
                    break;
                }
                case 1: {
                    n5 = Math.max((int)Math.round(0.49 + Math.max(Math.abs(d2), Math.abs(d3)) / this.resolution.maxLength), 1);
                    n6 = Math.max((int)Math.round(0.49 + Math.abs(d5 - d6) * (Math.PI / 180) * (Math.abs(d2) + Math.abs(d3)) / this.resolution.maxLength), 1);
                    n7 = Math.max((int)Math.round(0.49 + Math.abs(d4) / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nr != n5 || this.nu != n6 || this.nz != n7 || this.changeNTiles) {
            this.nr = n5;
            this.nu = n6;
            this.nz = n7;
            this.cosu = new double[this.nu + 1];
            this.sinu = new double[this.nu + 1];
            n4 = this.nu * this.nz;
            if (this.closedBottom) {
                n4 += this.nr * this.nu;
            }
            if (Math.abs(d5 - d6) < 360.0) {
                if (this.closedLeft) {
                    n4 += this.nr * this.nz;
                }
                if (this.closedRight) {
                    n4 += this.nr * this.nz;
                }
            }
            this.changeNTiles = false;
            this.setCorners(new double[n4][4][3]);
        }
        for (n4 = 0; n4 <= this.nu; ++n4) {
            d = ((double)(this.nu - n4) * d6 + (double)n4 * d5) * (Math.PI / 180) / (double)this.nu;
            this.cosu[n4] = Math.cos(d) * d2;
            this.sinu[n4] = Math.sin(d) * d3;
        }
        n4 = 0;
        this.center[0] = this.x;
        this.center[1] = this.y;
        this.center[2] = this.z;
        d = d4 / (double)this.nz;
        for (n3 = 0; n3 < this.nz; ++n3) {
            n2 = 0;
            while (n2 < this.nu) {
                for (n = 0; n < 3; ++n) {
                    this.corners[n4][0][n] = this.center[n] + (this.cosu[n2] * this.vectorx[n] + this.sinu[n2] * this.vectory[n]) * (double)(this.nz - n3) / (double)this.nz + (double)n3 * d * this.vectorz[n];
                    this.corners[n4][1][n] = this.center[n] + (this.cosu[n2 + 1] * this.vectorx[n] + this.sinu[n2 + 1] * this.vectory[n]) * (double)(this.nz - n3) / (double)this.nz + (double)n3 * d * this.vectorz[n];
                    this.corners[n4][2][n] = this.center[n] + (this.cosu[n2 + 1] * this.vectorx[n] + this.sinu[n2 + 1] * this.vectory[n]) * (double)(this.nz - n3 - 1) / (double)this.nz + (double)(n3 + 1) * d * this.vectorz[n];
                    this.corners[n4][3][n] = this.center[n] + (this.cosu[n2] * this.vectorx[n] + this.sinu[n2] * this.vectory[n]) * (double)(this.nz - n3 - 1) / (double)this.nz + (double)(n3 + 1) * d * this.vectorz[n];
                }
                ++n2;
                ++n4;
            }
        }
        if (this.closedBottom) {
            boolean bl = false;
            for (int i = 0; i < this.nu; ++i) {
                n3 = 0;
                while (n3 < this.nr) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.corners[n4][0][n2] = ((double)(this.nr - n3) * this.center[n2] + (double)n3 * this.corners[i][0][n2]) / (double)this.nr;
                        this.corners[n4][1][n2] = ((double)(this.nr - n3 - 1) * this.center[n2] + (double)(n3 + 1) * this.corners[i][0][n2]) / (double)this.nr;
                        this.corners[n4][2][n2] = ((double)(this.nr - n3 - 1) * this.center[n2] + (double)(n3 + 1) * this.corners[i][1][n2]) / (double)this.nr;
                        this.corners[n4][3][n2] = ((double)(this.nr - n3) * this.center[n2] + (double)n3 * this.corners[i][1][n2]) / (double)this.nr;
                    }
                    ++n3;
                    ++n4;
                }
            }
        }
        if (Math.abs(d5 - d6) < 360.0) {
            int n8;
            this.center[0] = this.x;
            this.center[1] = this.y;
            this.center[2] = this.z;
            if (this.closedRight) {
                int n9 = 0;
                double d7 = d4 / (double)this.nz;
                n2 = 0;
                while (n2 < this.nz) {
                    this.center[0] = this.x + (double)n2 * d7 * this.vectorz[0];
                    this.center[1] = this.y + (double)n2 * d7 * this.vectorz[1];
                    this.center[2] = this.z + (double)n2 * d7 * this.vectorz[2];
                    this.nextCenter[0] = this.x + (double)(n2 + 1) * d7 * this.vectorz[0];
                    this.nextCenter[1] = this.y + (double)(n2 + 1) * d7 * this.vectorz[1];
                    this.nextCenter[2] = this.z + (double)(n2 + 1) * d7 * this.vectorz[2];
                    n = 0;
                    while (n < this.nr) {
                        for (n8 = 0; n8 < 3; ++n8) {
                            this.corners[n4][0][n8] = ((double)(this.nr - n) * this.center[n8] + (double)n * this.corners[n9][0][n8]) / (double)this.nr;
                            this.corners[n4][1][n8] = ((double)(this.nr - n - 1) * this.center[n8] + (double)(n + 1) * this.corners[n9][0][n8]) / (double)this.nr;
                            this.corners[n4][2][n8] = ((double)(this.nr - n - 1) * this.nextCenter[n8] + (double)(n + 1) * this.corners[n9][3][n8]) / (double)this.nr;
                            this.corners[n4][3][n8] = ((double)(this.nr - n) * this.nextCenter[n8] + (double)n * this.corners[n9][3][n8]) / (double)this.nr;
                        }
                        ++n;
                        ++n4;
                    }
                    ++n2;
                    n9 += this.nu;
                }
            }
            if (this.closedLeft) {
                int n10 = this.nu - 1;
                double d8 = d4 / (double)this.nz;
                n2 = 0;
                while (n2 < this.nz) {
                    this.center[0] = this.x + (double)n2 * d8 * this.vectorz[0];
                    this.center[1] = this.y + (double)n2 * d8 * this.vectorz[1];
                    this.center[2] = this.z + (double)n2 * d8 * this.vectorz[2];
                    this.nextCenter[0] = this.x + (double)(n2 + 1) * d8 * this.vectorz[0];
                    this.nextCenter[1] = this.y + (double)(n2 + 1) * d8 * this.vectorz[1];
                    this.nextCenter[2] = this.z + (double)(n2 + 1) * d8 * this.vectorz[2];
                    n = 0;
                    while (n < this.nr) {
                        for (n8 = 0; n8 < 3; ++n8) {
                            this.corners[n4][0][n8] = ((double)(this.nr - n) * this.center[n8] + (double)n * this.corners[n10][1][n8]) / (double)this.nr;
                            this.corners[n4][1][n8] = ((double)(this.nr - n - 1) * this.center[n8] + (double)(n + 1) * this.corners[n10][1][n8]) / (double)this.nr;
                            this.corners[n4][2][n8] = ((double)(this.nr - n - 1) * this.nextCenter[n8] + (double)(n + 1) * this.corners[n10][2][n8]) / (double)this.nr;
                            this.corners[n4][3][n8] = ((double)(this.nr - n) * this.nextCenter[n8] + (double)n * this.corners[n10][2][n8]) / (double)this.nr;
                        }
                        ++n;
                        ++n4;
                    }
                    ++n2;
                    n10 += this.nu;
                }
            }
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

