/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetCursorPosition
extends InteractionTargetElementPosition {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int XY = 2;
    private int motion = -1;

    InteractionTargetCursorPosition(InteractiveElement interactiveElement, int n) {
        super(interactiveElement);
        this.motion = n;
    }

    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX(), this.element.getY(), this.element.getZ());
        }
        return new Point3D(this.element.getGroup().getX() + this.element.getX() * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + this.element.getY() * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + this.element.getZ() * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        switch (this.motion) {
            case 0: {
                this.element.setX(point3D.x);
                break;
            }
            case 1: {
                this.element.setY(point3D.y);
                break;
            }
            default: {
                this.element.setXY(point3D.x, point3D.y);
            }
        }
    }
}

