/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.Group;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetGroupDrawableElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;

public class GroupDrawable
extends Group
implements Interactive,
Drawable3D,
Measurable3D,
InteractionSource {
    private ArrayList list3D = new ArrayList();
    private Object3D[] minimalObjects = new Object3D[1];
    private ArrayList listeners = new ArrayList();

    public void add(InteractiveElement interactiveElement) {
        interactiveElement.setGroup(this);
    }

    public void remove(InteractiveElement interactiveElement) {
        interactiveElement.setGroup(null);
    }

    public void removeAll() {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).setGroup(null);
        }
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (!((InteractiveElement)iterator.next()).isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(int n, boolean bl) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).setEnabled(n, bl);
        }
    }

    public boolean isEnabled(int n) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (!((InteractiveElement)iterator.next()).isEnabled(n)) continue;
            return true;
        }
        return false;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        for (InteractiveElement interactiveElement : this.list) {
            Interactive interactive = interactiveElement.findInteractive(drawingPanel, n, n2);
            if (interactive instanceof InteractionTargetElementPosition) {
                return new InteractionTargetGroupDrawableElement(this, interactiveElement, (InteractionTarget)interactive);
            }
            if (interactive == null) continue;
            return interactive;
        }
        return null;
    }

    public void needsToProject(DrawingPanel drawingPanel) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).needsToProject(drawingPanel);
        }
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        this.list3D.clear();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object3D[] object3DArray = ((InteractiveElement)iterator.next()).getObjects3D(drawingPanel3D);
            if (object3DArray == null) continue;
            int n = object3DArray.length;
            for (int i = 0; i < n; ++i) {
                this.list3D.add(object3DArray[i]);
            }
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        System.out.println("Group draw (i): I should not be called!");
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).drawQuickly(drawingPanel3D, graphics2D);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((InteractiveElement)iterator.next()).draw(drawingPanel, graphics);
        }
    }

    public boolean isMeasured() {
        return !this.list.isEmpty();
    }

    public double getXMin() {
        double d = Double.MAX_VALUE;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.min(d, ((InteractiveElement)iterator.next()).getXMin());
        }
        return d;
    }

    public double getXMax() {
        double d = -1.7976931348623157E308;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.max(d, ((InteractiveElement)iterator.next()).getXMax());
        }
        return d;
    }

    public double getYMin() {
        double d = Double.MAX_VALUE;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.min(d, ((InteractiveElement)iterator.next()).getYMin());
        }
        return d;
    }

    public double getYMax() {
        double d = -1.7976931348623157E308;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.max(d, ((InteractiveElement)iterator.next()).getYMax());
        }
        return d;
    }

    public double getZMin() {
        double d = Double.MAX_VALUE;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.min(d, ((InteractiveElement)iterator.next()).getZMin());
        }
        return d;
    }

    public double getZMax() {
        double d = -1.7976931348623157E308;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            d = Math.max(d, ((InteractiveElement)iterator.next()).getZMax());
        }
        return d;
    }

    public void addListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public void removeListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    public void removeAllListeners() {
        this.listeners = new ArrayList();
    }

    public void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }
}

