/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractionSource;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;

public class ElementSet
extends AbstractInteractionSource
implements Interactive,
Drawable3D,
Measurable3D {
    protected int numElements = 0;
    protected Class classType;
    protected int elementInteracted = -1;
    protected String name = "";
    protected InteractiveElement[] elements = null;
    protected ArrayList list3D = new ArrayList();
    protected Object3D[] minimalObjects = new Object3D[1];

    public ElementSet(int n, Class clazz) {
        if (n < 1) {
            System.out.println("ElementSet error: An element set must contain at least one element!");
            n = 1;
        }
        this.classType = clazz;
        this.setNumberOfElements(n);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public synchronized void setNumberOfElements(int n) {
        int n2;
        if (n == this.numElements || n < 1) {
            return;
        }
        InteractiveElement[] interactiveElementArray = this.elements;
        this.elements = new InteractiveElement[n];
        try {
            for (n2 = 0; n2 < n; ++n2) {
                this.elements[n2] = (InteractiveElement)this.classType.newInstance();
                this.elements[n2].setSet(this, n2);
            }
            this.numElements = n;
        }
        catch (Exception exception) {
            System.out.println("Error: ElementSet requires a class that extends InteractiveElement!");
            exception.printStackTrace();
            this.numElements = 0;
            return;
        }
        if (interactiveElementArray == null) {
            return;
        }
        int n3 = Math.min(this.elements.length, interactiveElementArray.length);
        for (n2 = 0; n2 < n3; ++n2) {
            this.elements[n2].copyFrom(interactiveElementArray[n2]);
        }
        if (this.elements.length > interactiveElementArray.length) {
            n3 = this.elements.length;
            for (n2 = interactiveElementArray.length; n2 < n3; ++n2) {
                this.elements[n2].copyFrom(interactiveElementArray[0]);
            }
        }
        interactiveElementArray = null;
        this.setName(this.name);
    }

    public InteractiveElement elementAt(int n) {
        return this.elements[n];
    }

    public void setXs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setX(dArray[i]);
        }
    }

    public double[] getXs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getX();
        }
        return dArray;
    }

    public void setYs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setY(dArray[i]);
        }
    }

    public double[] getYs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getY();
        }
        return dArray;
    }

    public void setZs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setZ(dArray[i]);
        }
    }

    public double[] getZs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getZ();
        }
        return dArray;
    }

    public void setXYZs(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        if (n > dArray2.length) {
            n = dArray2.length;
        }
        if (n > dArray3.length) {
            n = dArray3.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setXYZ(dArray[i], dArray2[i], dArray3[i]);
        }
    }

    public void setSizeXs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setSizeX(dArray[i]);
        }
    }

    public double[] getSizeXs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getSizeX();
        }
        return dArray;
    }

    public void setSizeYs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setSizeY(dArray[i]);
        }
    }

    public double[] getSizeYs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getSizeY();
        }
        return dArray;
    }

    public void setSizeZs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setSizeZ(dArray[i]);
        }
    }

    public double[] getSizeZs() {
        double[] dArray = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            dArray[i] = this.elements[i].getSizeZ();
        }
        return dArray;
    }

    public void setSizeXYZs(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        if (n > dArray2.length) {
            n = dArray2.length;
        }
        if (n > dArray3.length) {
            n = dArray3.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setSizeXYZ(dArray[i], dArray2[i], dArray3[i]);
        }
    }

    public void setVisible(boolean bl) {
        for (int i = 0; i < this.numElements; ++i) {
            this.elements[i].setVisible(bl);
        }
    }

    public boolean isVisible() {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public void setVisibles(boolean[] blArray) {
        int n = this.numElements;
        if (n > blArray.length) {
            n = blArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setVisible(blArray[i]);
        }
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.numElements; ++i) {
            this.elements[i].setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(int n, boolean bl) {
        for (int i = 0; i < this.numElements; ++i) {
            this.elements[i].setEnabled(n, bl);
        }
    }

    public boolean isEnabled(int n) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].isEnabled(n)) continue;
            return true;
        }
        return false;
    }

    public void setEnableds(boolean[] blArray) {
        int n = this.numElements;
        if (n > blArray.length) {
            n = blArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.elements[i].setEnabled(blArray[i]);
        }
    }

    public void setEnableds(int n, boolean[] blArray) {
        int n2 = this.numElements;
        if (n2 > blArray.length) {
            n2 = blArray.length;
        }
        for (int i = 0; i < n2; ++i) {
            this.elements[i].setEnabled(n, blArray[i]);
        }
    }

    public String toXML() {
        return this.toString();
    }

    public int getElementInteracted() {
        return this.elementInteracted;
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        for (int i = 0; i < this.numElements; ++i) {
            Interactive interactive = this.elements[i].findInteractive(drawingPanel, n, n2);
            if (interactive == null) continue;
            this.elementInteracted = i;
            if (interactive instanceof InteractionTarget) {
                return new InteractionTargetSetElement(this, i, (InteractionTarget)interactive);
            }
            return interactive;
        }
        this.elementInteracted = -1;
        return null;
    }

    public void needsToProject(DrawingPanel drawingPanel) {
        for (int i = 0; i < this.numElements; ++i) {
            this.elements[i].needsToProject(drawingPanel);
        }
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.numElements <= 0) {
            return null;
        }
        this.list3D.clear();
        for (int i = 0; i < this.numElements; ++i) {
            Object3D[] object3DArray = this.elements[i].getObjects3D(drawingPanel3D);
            if (object3DArray == null) continue;
            for (int j = 0; j < object3DArray.length; ++j) {
                this.list3D.add(object3DArray[j]);
            }
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        System.out.println("ElementSet draw (i): I should not be called!");
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        for (int i = this.numElements - 1; i >= 0; --i) {
            this.elements[i].drawQuickly(drawingPanel3D, graphics2D);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        for (int i = this.numElements - 1; i >= 0; --i) {
            this.elements[i].draw(drawingPanel, graphics);
        }
    }

    public boolean isMeasured() {
        return this.numElements > 0;
    }

    public double getXMin() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getXMin();
            if (!(d2 < d)) continue;
            d = d3;
        }
        return d;
    }

    public double getXMax() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getXMax();
            if (!(d2 > d)) continue;
            d = d3;
        }
        return d;
    }

    public double getYMin() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getYMin();
            if (!(d2 < d)) continue;
            d = d3;
        }
        return d;
    }

    public double getYMax() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getYMax();
            if (!(d2 > d)) continue;
            d = d3;
        }
        return d;
    }

    public double getZMin() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getZMin();
            if (!(d2 < d)) continue;
            d = d3;
        }
        return d;
    }

    public double getZMax() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numElements; ++i) {
            double d2;
            double d3 = this.elements[i].getZMax();
            if (!(d2 > d)) continue;
            d = d3;
        }
        return d;
    }

    public void setXY(double d, double d2) {
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        return Double.NaN;
    }

    public double getY() {
        return Double.NaN;
    }
}

