/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class XAxis
extends XYAxis {
    public XAxis() {
        this("X Axis");
    }

    public XAxis(String string) {
        this.setTitle(string);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.yToPix(this.location);
        if (n < 1) {
            this.location = drawingPanel.getYMin();
        }
        if (n > drawingPanel.getHeight() - 1) {
            this.location = drawingPanel.getYMax();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, graphics);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, graphics);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, graphics);
            }
        }
        graphics2D.setClip(shape);
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2 = drawingPanel.getBottomGutter();
        int n3 = drawingPanel.getRightGutter();
        int n4 = drawingPanel.getLeftGutter();
        int n5 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = 0;
        graphics.setColor(this.color);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
        }
        int n7 = n4;
        int n8 = drawingPanel.yToPix(this.location);
        int n9 = drawingPanel.getWidth() - n4 - n3;
        graphics.drawLine(n7, n8, n7 + n9, n8);
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + n9 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n10 = stringArray.length;
        for (n = 0; n < n10; ++n) {
            int n11;
            if (this.axisType == 0) {
                n11 = drawingPanel.xToPix(dArray[n] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n5 + 1, n11, drawingPanel.getHeight() - n2 - 1);
                    graphics.setColor(this.color);
                }
                graphics.drawLine(n11, n8 - 5, n11, n8 + 5);
                n6 = fontMetrics.stringWidth(stringArray[n]);
                graphics.drawString(stringArray[n], n11 - n6 / 2, n8 + 18);
                continue;
            }
            n11 = drawingPanel.xToPix(Math.pow(10.0, dArray[n] * this.decade_multiplier));
            if (this.showMajorGrid) {
                graphics.setColor(this.majorGridColor);
                graphics.drawLine(n11, n5 + 1, n11, drawingPanel.getHeight() - n2 - 1);
                graphics.setColor(this.color);
            }
            graphics.drawLine(n11, n8 - 5, n11, n8 + 5);
            n6 = fontMetrics.stringWidth(this.logBase);
            this.drawMultiplier(n11 - n6 / 2, n8 + 18, (int)dArray[n], (Graphics2D)graphics);
        }
        n = drawingPanel.getHeight() - Math.max(n2 / 2, 6);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", drawingPanel.getWidth() - 36, n);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, n - 6);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
            this.axisLabel.setY(drawingPanel.getYMin() - 20.0 / drawingPanel.getYPixPerUnit());
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
        graphics2D.setFont(font);
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2 = drawingPanel.getBottomGutter();
        int n3 = drawingPanel.getRightGutter();
        int n4 = drawingPanel.getLeftGutter();
        int n5 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = 0;
        graphics.setColor(this.color);
        int n7 = n4;
        int n8 = drawingPanel.getHeight() - n2 - 1;
        int n9 = drawingPanel.getWidth() - n4 - n3;
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + n9 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n10 = stringArray.length;
        for (n = 0; n < n10; ++n) {
            int n11;
            if (this.axisType == 0) {
                n11 = drawingPanel.xToPix(dArray[n] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n5 + 1, n11, n8);
                    graphics.setColor(this.color);
                }
                graphics.drawLine(n11, n8, n11, n8 + 5);
                n6 = fontMetrics.stringWidth(stringArray[n]);
                graphics.drawString(stringArray[n], n11 - n6 / 2, n8 + 18);
                continue;
            }
            n11 = drawingPanel.xToPix(Math.pow(10.0, dArray[n] * this.decade_multiplier));
            if (this.showMajorGrid) {
                graphics.setColor(this.majorGridColor);
                graphics.drawLine(n11, n5 + 1, n11, n8);
                graphics.setColor(this.color);
            }
            graphics.drawLine(n11, n8, n11, n8 + 5);
            n6 = fontMetrics.stringWidth(this.logBase);
            this.drawMultiplier(n11 - n6 / 2, n8 + 18, (int)dArray[n], (Graphics2D)graphics);
        }
        graphics.drawLine(n7, n8, n7 + n9, n8);
        n = drawingPanel.getHeight() - Math.max(n2 / 2 - 15, 6);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", drawingPanel.getWidth() - 36, n);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, n - 6);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
            FontMetrics fontMetrics2 = drawingPanel.getFontMetrics(this.labelFont);
            this.axisLabel.setY(drawingPanel.pixToY(drawingPanel.getHeight() - Math.max(n2 - 2 * fontMetrics2.getHeight() - 4, 10)));
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(drawingPanel.yToPix(this.location) - n2) < 2) {
            return this;
        }
        return null;
    }

    public void setXY(double d, double d2) {
        this.location = d2;
    }

    public void setY(double d) {
        this.location = d;
    }
}

