/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.DrawableAxes;

public class CustomAxes
extends AbstractAxes
implements DrawableAxes {
    Color gridColor = Color.lightGray;
    ArrayList drawableList = new ArrayList();

    public CustomAxes(PlottingPanel plottingPanel) {
        super(plottingPanel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        plottingPanel.setAxes(this);
    }

    public void setXLabel(String string, String string2) {
    }

    public void setYLabel(String string, String string2) {
    }

    public String getXLabel() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setTitle(String string, String string2) {
        this.titleLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(string2));
    }

    public void setXLog(boolean bl) {
    }

    public void setYLog(boolean bl) {
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public void setShowMajorXGrid(boolean bl) {
    }

    public void setShowMinorXGrid(boolean bl) {
    }

    public void setShowMajorYGrid(boolean bl) {
    }

    public void setShowMinorYGrid(boolean bl) {
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != drawingPanel.getBackground()) {
            graphics.setColor(this.interiorColor);
            int n = drawingPanel.getLeftGutter() + drawingPanel.getRightGutter();
            int n2 = drawingPanel.getTopGutter() + drawingPanel.getLeftGutter();
            graphics.fillRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
            graphics.setColor(this.gridColor);
            graphics.drawRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
        }
        Iterator iterator = this.drawableList.iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            drawable.draw(drawingPanel, graphics);
        }
        this.titleLine.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
        if (drawingPanel.getTopGutter() > 20) {
            this.titleLine.setY(drawingPanel.getYMax() + 5.0 / drawingPanel.getYPixPerUnit());
        } else {
            this.titleLine.setY(drawingPanel.getYMax() - 25.0 / drawingPanel.getYPixPerUnit());
        }
        this.titleLine.draw(drawingPanel, graphics);
    }
}

