/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;

public class GUIUtils {
    public static Map charMap = new HashMap();
    static /* synthetic */ Class class$org$opensourcephysics$display$DataTableFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$DrawingFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$OSPFrame;

    private GUIUtils() {
    }

    public static String parseTeX(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\$");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (bl && (string2 = (String)charMap.get(stringArray[i].trim())) != null) {
                stringArray[i] = string2;
            }
            bl = !bl;
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + stringArray[i];
        }
        return string3;
    }

    public static String removeSubscripting(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("_");
        while (n > 0) {
            int n2;
            String string2 = string.substring(n + 1);
            if (string2.startsWith("{") && (n2 = string2.indexOf("}")) > 0) {
                string2 = string2.substring(1, n2) + string2.substring(n2 + 1);
            }
            string = string.substring(0, n) + string2;
            n = string.indexOf("_");
        }
        return string;
    }

    public static Component findInstance(Container container, Class clazz) {
        if (container == null || clazz.isInstance(container)) {
            return container;
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component component;
            if (clazz.isInstance(componentArray[i])) {
                return componentArray[i];
            }
            if (!(componentArray[i] instanceof Container) || !clazz.isInstance(component = GUIUtils.findInstance((Container)componentArray[i], clazz))) continue;
            return component;
        }
        return null;
    }

    public static void showDrawingAndTableFrames() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isDisplayable() || frameArray[i].getName() != null && frameArray[i].getName().indexOf("Tool") > -1 || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frameArray[i])) continue;
            if ((class$org$opensourcephysics$display$DataTableFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DataTableFrame") : class$org$opensourcephysics$display$DataTableFrame).isInstance(frameArray[i])) {
                ((DataTableFrame)frameArray[i]).refreshTable();
            }
            frameArray[i].setVisible(true);
            ((OSPFrame)frameArray[i]).invalidateImage();
            frameArray[i].repaint();
            frameArray[i].toFront();
        }
        if (OSPRuntime.applet != null) {
            OSPRuntime.applet.getRootPane().repaint();
        }
    }

    public static void renderAnimatedFrames() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frameArray[i]) || !((OSPFrame)frameArray[i]).isAnimated()) continue;
            ((OSPFrame)frameArray[i]).render();
        }
        if (OSPRuntime.applet != null && OSPRuntime.applet instanceof Renderable) {
            ((Renderable)((Object)OSPRuntime.applet)).render();
        }
    }

    public static void repaintAnimatedFrames() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frameArray[i]) || !((OSPFrame)frameArray[i]).isAnimated()) continue;
            ((OSPFrame)frameArray[i]).invalidateImage();
            ((OSPFrame)frameArray[i]).repaint();
        }
    }

    public static void clearDrawingFrameData(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frameArray[i])) continue;
            OSPFrame oSPFrame = (OSPFrame)frameArray[i];
            if (!bl && !oSPFrame.isAutoclear()) continue;
            oSPFrame.clearDataAndRepaint();
        }
    }

    public static void setAnimatedFrameIgnoreRepaint(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            DrawingPanel drawingPanel;
            if (!frameArray[i].isDisplayable() || !(class$org$opensourcephysics$display$DrawingFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DrawingFrame") : class$org$opensourcephysics$display$DrawingFrame).isInstance(frameArray[i]) || !((DrawingFrame)frameArray[i]).isAnimated() || (drawingPanel = ((DrawingFrame)frameArray[i]).getDrawingPanel()) == null) continue;
            drawingPanel.setIgnoreRepaint(bl);
        }
    }

    public static void enableMenubars(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            JMenuBar jMenuBar;
            if (!frameArray[i].isDisplayable() || frameArray[i].getName() != null && frameArray[i].getName().indexOf("Tool") > -1) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.opensourcephysics.display3d.core.DrawingFrame3D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!(class$org$opensourcephysics$display$DrawingFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DrawingFrame") : class$org$opensourcephysics$display$DrawingFrame).isInstance(frameArray[i]) && (clazz == null || !clazz.isInstance(frameArray[i])) || (jMenuBar = ((JFrame)frameArray[i]).getJMenuBar()) == null) continue;
            int n = jMenuBar.getMenuCount();
            for (int j = 0; j < n; ++j) {
                jMenuBar.getMenu(j).setEnabled(bl);
            }
        }
    }

    public static void closeAndDisposeOSPFrames(Frame frame) {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (frameArray[i] == frame || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frameArray[i])) continue;
            ((OSPFrame)frameArray[i]).setDefaultCloseOperation(2);
            ((OSPFrame)frameArray[i]).setVisible(false);
            ((OSPFrame)frameArray[i]).dispose();
        }
    }

    public static File showSaveDialog(Component component) {
        return GUIUtils.showSaveDialog(component, "Save");
    }

    public static File showSaveDialog(Component component, String string) {
        int n;
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        if (jFileChooser == null) {
            return null;
        }
        String string2 = jFileChooser.getDialogTitle();
        jFileChooser.setDialogTitle(string);
        int n2 = jFileChooser.showSaveDialog(component);
        jFileChooser.setDialogTitle(string2);
        if (n2 != 0) {
            return null;
        }
        OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && (n = JOptionPane.showConfirmDialog(component, "A file named " + file.getName() + " already exists.\nAre you sure you want to replace it?", "Warning", 1)) != 0) {
            return null;
        }
        return file;
    }

    public static File showOpenDialog(Component component) {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
        File file = jFileChooser.getSelectedFile();
        return file;
    }

    public static void timingTest(Drawable drawable) {
        DrawingPanel drawingPanel = new DrawingPanel();
        DrawingFrame drawingFrame = new DrawingFrame(drawingPanel);
        drawingFrame.setVisible(true);
        drawingPanel.addDrawable(drawable);
        drawingPanel.scale();
        drawingPanel.setPixelScale();
        Graphics graphics = drawingPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        long l = System.currentTimeMillis();
        drawable.draw(drawingPanel, graphics);
        System.out.print("first drawing=" + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            drawable.draw(drawingPanel, graphics);
        }
        System.out.println("  avg time/drawing=" + (System.currentTimeMillis() - l) / 5L);
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(JComponent jComponent, File file, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            if (string.equals("eps")) {
                EpsGraphics2D epsGraphics2D = new EpsGraphics2D("", fileOutputStream, 0, 0, jComponent.getWidth(), jComponent.getHeight());
                jComponent.paint(epsGraphics2D);
                epsGraphics2D.scale(0.24, 0.24);
                epsGraphics2D.close();
            } else {
                BufferedImage bufferedImage = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 5);
                Graphics graphics = bufferedImage.getGraphics();
                jComponent.paint(graphics);
                graphics.dispose();
                ImageIO.write((RenderedImage)bufferedImage, string, fileOutputStream);
                fileOutputStream.close();
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void saveImage(JComponent jComponent, String string, Component component) {
        File file = GUIUtils.showSaveDialog(jComponent, "Save Image");
        if (file == null) {
            return;
        }
        try {
            GUIUtils.saveImage(jComponent, file, string);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, "An error occurred while saving the file " + file.getName() + ".'");
        }
    }

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
    }
}

