/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.text.DecimalFormat;
import org.opensourcephysics.automaticcontrol.PoligonsAndTexts;

public class Valve
extends PoligonsAndTexts {
    public static final int CONTINUOUS = 0;
    public static final int DISCRETE = 1;
    public static final int TRIPLE_CONTINUOUS = 10;
    public static final int TRIPLE_DISCRETE = 11;
    private static final double w = 0.08;
    private static final double w2 = 0.07;
    private static final double h = 0.07;
    private static final double t = 0.06;

    public Valve() {
        this.setShowSecondText(false);
        this.format = new DecimalFormat("##0%");
        this.text.getStyle().setPosition(2);
        this.setShowText(false);
    }

    protected double getRadius() {
        return 0.08;
    }

    protected void setGroupData() {
        this.data = this.type >= 10 ? (Object)new double[][]{{0.0, 0.0}, {-0.08, -0.04}, {-0.08, 0.04}, {0.0, 0.0}, {0.08, -0.04}, {0.08, 0.04}, {0.0, 0.0}, {-0.04, -0.08}, {0.04, -0.08}, {0.0, 0.0}, {0.0, 0.07}} : (double[][])new double[][]{{0.0, 0.0}, {-0.08, -0.04}, {-0.08, 0.04}, {0.0, 0.0}, {0.08, -0.04}, {0.08, 0.04}, {0.0, 0.0}, {0.0, 0.07}};
        switch (this.type % 10) {
            case 1: {
                this.data2 = new double[][]{{0.07, 0.07}, {0.07, 0.13}, {-0.07, 0.13}, {-0.07, 0.07}, {0.0, 0.07}};
                break;
            }
            default: {
                int n = 9;
                this.data2 = new double[n + 1][];
                double d = Math.sqrt(0.005444444444444445);
                double d2 = Math.atan2(0.023333333333333334, 0.07);
                double d3 = Math.PI - 2.0 * d2;
                for (int i = 0; i < n; ++i) {
                    double d4 = d2 + (double)i * d3 / (double)(n - 1);
                    this.data2[i] = new double[]{d * Math.cos(d4), 0.04666666666666667 + d * Math.sin(d4)};
                }
                this.data2[n] = new double[]{0.0, 0.07};
            }
        }
        this.textX = 0.0;
        this.textY = 0.154;
        this.rotateData();
        this.poligon.setData(this.data);
        this.poligon2.setData(this.data2);
        this.text.setXY(this.textX, this.textY);
        this.text.getStyle().setAngle(this.angle);
    }
}

