/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.text.DecimalFormat;
import org.opensourcephysics.automaticcontrol.PoligonsAndTexts;

public class Symbol
extends PoligonsAndTexts {
    public static final int CIRCLE_1 = 0;
    public static final int CIRCLE_2 = 1;
    public static final int CIRCLE_3 = 2;
    public static final int CIRCLE_4 = 3;
    public static final int CIRCLE_5 = 4;
    public static final int DIAMOND_1 = 10;
    public static final int DIAMOND_2 = 11;
    public static final int DIAMOND_3 = 12;
    public static final int RECTANGLE_1 = 20;
    public static final int RECTANGLE_2 = 21;
    private static final double w = 0.15;
    private static final double wUp = 0.015;
    private static final double wDown = -0.0375;

    public Symbol() {
        this.setShowSecondText(true);
        this.format = new DecimalFormat("##0");
        this.setShowText(false);
        this.increment = 5.0;
        this.hasChanged = true;
    }

    private static double[][] box() {
        return new double[][]{{-0.15, -0.15}, {0.15, -0.15}, {0.15, 0.15}, {-0.15, 0.15}};
    }

    private static double[][] boxBar() {
        return new double[][]{{-0.15, 0.0}, {-0.15, 0.15}, {0.15, 0.15}, {0.15, -0.15}, {-0.15, -0.15}, {-0.15, 0.0}, {0.15, 0.0}};
    }

    private static double[][] diamondBox() {
        return new double[][]{{-0.15, 0.0}, {0.0, -0.15}, {0.15, 0.0}, {0.0, 0.15}, {-0.15, 0.0}, {-0.15, -0.15}, {0.15, -0.15}, {0.15, 0.15}, {-0.15, 0.15}};
    }

    private static double[][] diamond() {
        return new double[][]{{-0.15, 0.0}, {0.0, -0.15}, {0.15, 0.0}, {0.0, 0.15}};
    }

    private static double[][] diamondBar() {
        return new double[][]{{-0.15, 0.0}, {0.0, -0.15}, {0.15, 0.0}, {0.0, 0.15}, {-0.15, 0.0}, {0.15, 0.0}};
    }

    private static double[][] circle(int n) {
        int n2 = 20;
        double[][] dArray = new double[n2 + n][2];
        for (int i = 0; i < n2; ++i) {
            double d = (double)i * 2.0 * Math.PI / (double)(n2 - 1);
            dArray[i] = new double[]{0.15 * Math.cos(d), 0.15 * Math.sin(d)};
        }
        if (n > 0) {
            dArray[n2] = new double[]{-0.15, 0.0};
        }
        return dArray;
    }

    private static double[][] circleBox() {
        int n = 20;
        double[][] dArrayArray = new double[n + 6][];
        dArrayArray[0] = new double[]{0.15, 0.0};
        dArrayArray[1] = new double[]{0.15, 0.15};
        dArrayArray[2] = new double[]{-0.15, 0.15};
        dArrayArray[3] = new double[]{-0.15, -0.15};
        dArrayArray[4] = new double[]{0.15, -0.15};
        dArrayArray[5] = new double[]{0.15, 0.0};
        for (int i = 6; i < n + 6; ++i) {
            double d = (double)(i - 6) * 2.0 * Math.PI / (double)(n - 1);
            dArrayArray[i] = new double[]{0.15 * Math.cos(d), 0.15 * Math.sin(d)};
        }
        return dArrayArray;
    }

    protected double getRadius() {
        return 0.15;
    }

    protected void setGroupData() {
        switch (this.type) {
            case 0: {
                this.data = null;
                this.data2 = Symbol.circle(0);
                this.setShowText(false);
                this.text2.getStyle().setPosition(0);
                this.text2Y = 0.0;
                this.text2X = 0.0;
                break;
            }
            case 1: {
                this.data = null;
                this.data2 = Symbol.circle(0);
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            case 2: {
                this.data = null;
                this.data2 = Symbol.circle(1);
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            case 3: {
                this.data = Symbol.circleBox();
                this.data2 = Symbol.circle(0);
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            default: {
                this.data = Symbol.circleBox();
                this.data2 = Symbol.circle(1);
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            case 10: {
                this.data = null;
                this.data2 = Symbol.diamond();
                this.setShowText(false);
                this.text2.getStyle().setPosition(0);
                this.text2Y = 0.0;
                this.text2X = 0.0;
                break;
            }
            case 11: {
                this.data = null;
                this.data2 = Symbol.diamondBar();
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            case 12: {
                this.data = Symbol.diamondBox();
                this.data2 = Symbol.diamondBar();
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
                break;
            }
            case 20: {
                this.data = null;
                this.data2 = Symbol.box();
                this.setShowText(false);
                this.text2.getStyle().setPosition(0);
                this.text2Y = 0.0;
                this.text2X = 0.0;
                break;
            }
            case 21: {
                this.data = null;
                this.data2 = Symbol.boxBar();
                this.setShowText(true);
                this.textX = 0.0;
                this.textY = -0.0375;
                this.text.getStyle().setPosition(1);
                this.text2X = 0.0;
                this.text2Y = 0.015;
                this.text2.getStyle().setPosition(2);
            }
        }
        this.rotateData();
        this.text.getStyle().setAngle(this.angle);
        this.text2.getStyle().setAngle(this.angle);
        this.text.setXY(this.textX, this.textY);
        this.text2.setXY(this.text2X, this.text2Y);
        if (this.data == null) {
            this.poligon.setVisible(false);
        } else {
            this.poligon.setVisible(true);
            this.poligon.setData(this.data);
        }
        this.poligon2.setData(this.data2);
    }
}

