/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import org.opensourcephysics.automaticcontrol.PoligonsAndTexts;

public class Pump
extends PoligonsAndTexts {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    protected double rotorAngle = Double.NaN;
    private boolean showRotor = false;
    private static final double w = 0.08;
    private static final double w2 = 0.05;
    private static final double h = 0.12;
    private static final boolean[] rotorConnected = new boolean[]{true, false, true, false};

    public Pump() {
        this.poligon2.setData(Pump.rotorData());
        this.poligon2.setConnections(rotorConnected);
        this.poligon2.setClosed(false);
        this.setRotorData(false);
        this.setShowSecondText(false);
        this.format = new DecimalFormat("0.000");
        this.text.getStyle().setPosition(2);
        this.setShowText(false);
    }

    public void setRotorAngle(double d) {
        this.rotorAngle = d;
        this.setRotorData(true);
    }

    public void setFillColor2(Paint paint) {
        if (paint instanceof Color) {
            this.poligon2.getStyle().setEdgeColor((Color)paint);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.poligon2.setVisible(this.showRotor);
        }
    }

    private static double[][] rotorData() {
        return new double[][]{{-0.05, 0.0}, {0.05, 0.0}, {0.0, 0.05}, {0.0, -0.05}};
    }

    private static double[][] pumpRight() {
        int n;
        int n2 = 20;
        int n3 = n2 / 3;
        double[][] dArrayArray = new double[n2 + n3 + 2][];
        double d = 5.235987755982989;
        d = Math.PI * 2;
        for (n = 0; n < n2; ++n) {
            double d2 = 1.5707963267948966 + (double)n * d / (double)(n2 - 1);
            dArrayArray[n] = new double[]{0.08 * Math.cos(d2), 0.08 * Math.sin(d2)};
        }
        dArrayArray[n2] = new double[]{0.12, 0.08};
        dArrayArray[n2 + 1] = new double[]{0.12, dArrayArray[n2 - n3][1]};
        for (n = 0; n < n3; ++n) {
            dArrayArray[n2 + 2 + n] = new double[]{dArrayArray[n2 - n3 + n][0], dArrayArray[n2 - n3 + n][1]};
        }
        return dArrayArray;
    }

    private static double[][] pumpLeft() {
        int n;
        int n2 = 20;
        int n3 = n2 / 3;
        double[][] dArrayArray = new double[n2 + n3 + 2][];
        double d = 5.235987755982989;
        d = Math.PI * 2;
        for (n = 0; n < n2; ++n) {
            double d2 = 1.5707963267948966 - (double)n * d / (double)(n2 - 1);
            dArrayArray[n] = new double[]{0.08 * Math.cos(d2), 0.08 * Math.sin(d2)};
        }
        dArrayArray[n2] = new double[]{-0.12, 0.08};
        dArrayArray[n2 + 1] = new double[]{-0.12, dArrayArray[n2 - n3][1]};
        for (n = 0; n < n3; ++n) {
            dArrayArray[n2 + 2 + n] = new double[]{dArrayArray[n2 - n3 + n][0], dArrayArray[n2 - n3 + n][1]};
        }
        return dArrayArray;
    }

    protected double getRadius() {
        return 0.08;
    }

    protected void setRotorData(boolean bl) {
        double d;
        if (Double.isNaN(this.rotorAngle)) {
            this.data2 = null;
            this.showRotor = false;
            this.poligon2.setVisible(false);
            return;
        }
        this.data2 = Pump.rotorData();
        switch (this.type) {
            default: {
                d = -this.rotorAngle;
                break;
            }
            case 1: {
                d = this.rotorAngle;
            }
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = this.data2.length;
        for (int i = 0; i < n; ++i) {
            double d4 = d2 * this.data2[i][0] - d3 * this.data2[i][1];
            this.data2[i][1] = d3 * this.data2[i][0] + d2 * this.data2[i][1];
            this.data2[i][0] = d4;
        }
        if (bl) {
            this.rotateData();
            this.showRotor = true;
            this.poligon2.setVisible(true);
            this.poligon2.setData(this.data2);
        }
    }

    protected void setGroupData() {
        switch (this.type) {
            default: {
                this.data = Pump.pumpRight();
                break;
            }
            case 1: {
                this.data = Pump.pumpLeft();
            }
        }
        this.setRotorData(false);
        this.textX = 0.0;
        this.textY = 0.08800000000000001;
        this.rotateData();
        if (this.data2 == null) {
            this.poligon2.setVisible(false);
        } else {
            this.poligon2.setVisible(true);
            this.poligon2.setData(this.data2);
        }
        this.poligon.setData(this.data);
        this.text.setXY(this.textX, this.textY);
        this.text.getStyle().setAngle(this.angle);
    }
}

