/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractivePoligon;

public class Pipe
extends InteractivePoligon {
    protected boolean filled = false;
    protected boolean endClosed = false;
    protected double width = 0.05;
    protected Paint emptyPattern = null;
    protected int sides = 0;
    protected int[] sidePointsA = null;
    protected int[] sidePointsB = null;
    private int[] pieceA = new int[4];
    private int[] pieceB = new int[4];
    protected double[] origin = new double[6];
    protected double[] pixelOrigin = new double[5];

    public Pipe() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.closed = false;
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof Pipe) {
            this.setWidth(((Pipe)interactiveElement).getWidth());
            this.setFilled(((Pipe)interactiveElement).isFilled());
        }
    }

    public void setClosed(boolean bl) {
        this.closed = false;
    }

    public void setConnections(boolean[] blArray) {
        for (int i = 0; i < this.numPoints; ++i) {
            this.connect[i] = true;
        }
    }

    public void setNumberOfPoints(int n) {
        if (n == this.numPoints) {
            return;
        }
        if (n < 1) {
            return;
        }
        super.setNumberOfPoints(n);
        this.sidePointsA = new int[2 * n + 1];
        this.sidePointsB = new int[2 * n + 1];
        for (int i = 0; i < this.numPoints; ++i) {
            this.coordinates[0][i] = (double)i * 0.2 / (double)(this.numPoints - 1);
        }
    }

    public void setWidth(double d) {
        this.hasChanged = this.width != d;
        this.width = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setEndClosed(boolean bl) {
        this.endClosed = bl;
    }

    public boolean isEndClosed() {
        return this.endClosed;
    }

    public void setEmptyPattern(Paint paint) {
        this.emptyPattern = paint;
    }

    public Paint getEmptyPattern() {
        return this.emptyPattern;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        if (n < this.numPoints - 1) {
            int n2 = n;
            int n3 = 2 * this.numPoints - 1 - n;
            Paint paint = null;
            paint = this.filled ? this.style.getFillPattern() : this.emptyPattern;
            if (paint != null) {
                if (paint instanceof Color) {
                    paint = drawingPanel3D.projectColor((Color)paint, this.lineObjects[n].distance);
                }
                this.pieceA[0] = this.sidePointsA[n2];
                this.pieceB[0] = this.sidePointsB[n2];
                this.pieceA[1] = this.sidePointsA[n2 + 1];
                this.pieceB[1] = this.sidePointsB[n2 + 1];
                this.pieceA[2] = this.sidePointsA[n3 - 1];
                this.pieceB[2] = this.sidePointsB[n3 - 1];
                this.pieceA[3] = this.sidePointsA[n3];
                this.pieceB[3] = this.sidePointsB[n3];
                graphics2D.setPaint(paint);
                graphics2D.fillPolygon(this.pieceA, this.pieceB, 4);
            }
            if (this.style.getEdgeColor() != null) {
                Color color = drawingPanel3D.projectColor(this.style.getEdgeColor(), this.lineObjects[n].distance);
                graphics2D.setStroke(this.style.getEdgeStroke());
                graphics2D.setColor(color);
                graphics2D.drawLine(this.sidePointsA[n2], this.sidePointsB[n2], this.sidePointsA[n2 + 1], this.sidePointsB[n2 + 1]);
                graphics2D.drawLine(this.sidePointsA[n3], this.sidePointsB[n3], this.sidePointsA[n3 - 1], this.sidePointsB[n3 - 1]);
            }
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.numPoints <= 0 || !this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.projectPoints(drawingPanel);
        Paint paint = null;
        paint = this.filled ? this.style.getFillPattern() : this.emptyPattern;
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(this.sidePointsA, this.sidePointsB, 2 * this.numPoints + 1);
            if (paint instanceof Color) {
                graphics2D.setColor((Color)paint);
                graphics2D.setStroke(this.style.getEdgeStroke());
                graphics2D.drawPolyline(this.sidePointsA, this.sidePointsB, 2 * this.numPoints + 1);
            }
        }
        if (this.style.getEdgeColor() != null) {
            graphics2D.setColor(this.style.getEdgeColor());
            graphics2D.setStroke(this.style.getEdgeStroke());
            int n = 1;
            int n2 = this.numPoints;
            while (n < this.numPoints) {
                graphics2D.drawLine(this.sidePointsA[n - 1], this.sidePointsB[n - 1], this.sidePointsA[n], this.sidePointsB[n]);
                graphics2D.drawLine(this.sidePointsA[n2], this.sidePointsB[n2], this.sidePointsA[n2 + 1], this.sidePointsB[n2 + 1]);
                ++n;
                ++n2;
            }
            if (this.endClosed) {
                graphics2D.drawLine(this.sidePointsA[this.numPoints - 1], this.sidePointsB[this.numPoints - 1], this.sidePointsA[this.numPoints], this.sidePointsB[this.numPoints]);
            }
        }
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        double d;
        double d2;
        double d3;
        super.projectPoints(drawingPanel);
        this.origin[0] = (drawingPanel.getXMin() + drawingPanel.getXMax()) / 2.0;
        this.origin[1] = (drawingPanel.getYMin() + drawingPanel.getYMax()) / 2.0;
        if (drawingPanel instanceof DrawingPanel3D) {
            DrawingPanel3D drawingPanel3D = (DrawingPanel3D)drawingPanel;
            this.origin[2] = (drawingPanel3D.getZMin() + drawingPanel3D.getZMax()) / 2.0;
        } else {
            this.origin[2] = 0.0;
        }
        this.origin[3] = this.width / 2.0;
        this.origin[4] = this.width / 2.0;
        this.origin[5] = this.width / 2.0;
        drawingPanel.project(this.origin, this.pixelOrigin);
        double d4 = Math.max(this.pixelOrigin[2], this.pixelOrigin[3]);
        double d5 = this.aPoints[1] - this.aPoints[0];
        double d6 = this.bPoints[1] - this.bPoints[0];
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            d3 = d4;
            d2 = 0.0;
        } else {
            d3 = -d6 / d7 * d4;
            d2 = d5 / d7 * d4;
        }
        int n = 0;
        int n2 = this.numPoints - 1;
        int n3 = 2 * this.numPoints - 1;
        this.sidePointsA[n] = this.aPoints[n] + (int)d3;
        this.sidePointsB[n] = this.bPoints[n] + (int)d2;
        this.sidePointsA[n3] = this.aPoints[n] - (int)d3;
        this.sidePointsB[n3] = this.bPoints[n] - (int)d2;
        n = 1;
        --n3;
        while (n < n2) {
            d = d5;
            double d8 = d6;
            d5 = this.aPoints[n + 1] - this.aPoints[n];
            d6 = this.bPoints[n + 1] - this.bPoints[n];
            d7 = Math.sqrt(d5 * d5 + d6 * d6);
            if (d7 == 0.0) {
                d3 = d4;
                d2 = 0.0;
            } else {
                d3 = -d6 / d7 * d4;
                d2 = d5 / d7 * d4;
            }
            double d9 = d8 * d5 - d * d6;
            if (Math.abs(d9) < 0.1) {
                this.sidePointsA[n] = this.aPoints[n] + (int)d3;
                this.sidePointsB[n] = this.bPoints[n] + (int)d2;
                this.sidePointsA[n3] = this.aPoints[n] - (int)d3;
                this.sidePointsB[n3] = this.bPoints[n] - (int)d2;
            } else {
                double d10 = (((double)(this.bPoints[n] - this.sidePointsB[n - 1]) + d2) * d5 - ((double)(this.aPoints[n] - this.sidePointsA[n - 1]) + d3) * d6) / d9;
                this.sidePointsA[n] = this.sidePointsA[n - 1] + (int)(d * d10);
                this.sidePointsB[n] = this.sidePointsB[n - 1] + (int)(d8 * d10);
                d10 = (((double)(this.bPoints[n + 1] - this.sidePointsB[n3 + 1]) - d2) * d5 - ((double)(this.aPoints[n + 1] - this.sidePointsA[n3 + 1]) - d3) * d6) / d9;
                this.sidePointsA[n3] = this.sidePointsA[n3 + 1] + (int)(d * d10);
                this.sidePointsB[n3] = this.sidePointsB[n3 + 1] + (int)(d8 * d10);
            }
            ++n;
            --n3;
        }
        if (Math.abs(d7) < 1.0E-4) {
            this.sidePointsA[n] = this.aPoints[n] + (int)d4;
            this.sidePointsB[n] = this.bPoints[n] + 0;
            this.sidePointsA[n3] = this.aPoints[n] - (int)d4;
            this.sidePointsB[n3] = this.bPoints[n] - 0;
        } else {
            d7 *= d7;
            d = ((double)(this.aPoints[n] - this.sidePointsA[n - 1]) * d5 + (double)(this.bPoints[n] - this.sidePointsB[n - 1]) * d6) / d7;
            this.sidePointsA[n] = this.sidePointsA[n - 1] + (int)(d5 * d);
            this.sidePointsB[n] = this.sidePointsB[n - 1] + (int)(d6 * d);
            d = ((double)(this.aPoints[n] - this.sidePointsA[n3 + 1]) * d5 + (double)(this.bPoints[n] - this.sidePointsB[n3 + 1]) * d6) / d7;
            this.sidePointsA[n3] = this.sidePointsA[n3 + 1] + (int)(d5 * d);
            this.sidePointsB[n3] = this.sidePointsB[n3 + 1] + (int)(d6 * d);
        }
        n = 2 * this.numPoints;
        this.sidePointsA[n] = this.sidePointsA[0];
        this.sidePointsB[n] = this.sidePointsB[0];
    }
}

