/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.external;

import com.calerga.sysquake.SQLinkVariableListener;
import com.calerga.sysquake.SysquakeLink;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.colos.ejs.external.ExternalApp;
import org.colos.ejs.external.ExternalClient;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.Simulation;

public class EjsSysquake
implements ExternalApp,
SQLinkVariableListener {
    private static SysquakeLink sqlink = null;
    private static String homeDir = null;
    private static boolean alreadyLoaded = false;
    private static int numberOfEngines = 0;
    private static int dllCounter = -1;
    private int sqID = -1;
    private String sqFile = null;
    private ExternalClient client = null;
    private Hashtable varTable = new Hashtable();

    private static SysquakeLink tryThisOne(String string) {
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        if (file.exists()) {
            return new SysquakeLink(string);
        }
        return null;
    }

    private static void initSysquake() {
        if (sqlink != null) {
            return;
        }
        homeDir = null;
        String string = System.getProperty("user.dir").replace('\\', '/');
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (OSPRuntime.isWindows()) {
            sqlink = EjsSysquake.tryThisOne(string + Simulation.getPathToLibrary() + "_library/external/SysquakeLink.dll");
            if (sqlink == null) {
                sqlink = EjsSysquake.tryThisOne(string + "_library/external/SysquakeLink.dll");
            }
            if (sqlink == null) {
                homeDir = Simulation.getTemporaryDir();
                if (!alreadyLoaded) {
                    dllCounter = 0;
                    for (int i = 1; i <= 50; ++i) {
                        File file = new File(homeDir + "_library/external/SysquakeLink" + i + ".dll");
                        if (file.exists()) {
                            file.delete();
                            continue;
                        }
                        if (dllCounter != 0) continue;
                        dllCounter = i;
                        if (Simulation.extractResource("../_library/external/SysquakeLink.dll", file.getPath()) == null) continue;
                        Simulation.extractResource("_library/external/SysquakeLink.dll", file.getPath());
                    }
                    alreadyLoaded = true;
                }
                sqlink = EjsSysquake.tryThisOne(homeDir + "_library/external/SysquakeLink" + dllCounter + ".dll");
            }
        } else {
            new SysquakeLink(string + "_library/external/libSysquakeLink.jnilib");
        }
    }

    public EjsSysquake(String string) {
        EjsSysquake.initSysquake();
        String string2 = null;
        if (homeDir != null) {
            string2 = homeDir;
        } else {
            string2 = System.getProperty("user.dir").replace('\\', '/');
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
        }
        if (string != null) {
            this.sqFile = string.trim();
            if (this.sqFile.length() == 0 || this.sqFile.toLowerCase().startsWith("<sysquake>")) {
                this.sqFile = null;
            } else if (!(homeDir == null && new File(string2 + this.sqFile).exists() || Simulation.extractResource(this.sqFile, (string2 = Simulation.getTemporaryDir()) + this.sqFile) == null)) {
                System.out.println("Warning : the sq file " + this.sqFile + " does not exist!");
                this.sqFile = null;
            }
            if (this.sqFile != null) {
                this.sqFile = string2 + this.sqFile;
            }
        }
        try {
            SysquakeLink.connect();
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        if (!SysquakeLink.isConnected()) {
            System.out.println("Warning : Sysquake is NOT connected!!!");
        }
        this.loadSQFile();
    }

    private synchronized void loadSQFile() {
        try {
            SysquakeLink.resetVariableChangeNotification(this.sqID);
            if (this.sqID != -1) {
                // empty if block
            }
            if (this.sqFile == null) {
                this.sqID = -1;
                return;
            }
            SysquakeLink.show();
            this.sqID = SysquakeLink.open(this.sqFile);
            if (this.sqID == -1) {
                return;
            }
            SysquakeLink.setVariableChangeNotification(this.sqID, this);
            String[] stringArray = SysquakeLink.variableNames(this.sqID);
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    if (string.startsWith("_")) continue;
                    this.varTable.put(stringArray[i], new Integer(i));
                }
            }
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public void variableChange(int n) {
        if (n != this.sqID) {
            System.out.println("Wrong Sysquake ID!");
            return;
        }
        if (this.client != null) {
            this.client._externalGetValuesAndUpdate(false, this);
        }
    }

    public String toString() {
        return this.sqFile;
    }

    public void setClient(ExternalClient externalClient) {
        this.client = externalClient;
    }

    public void setInitCommand(String string) {
    }

    public void eval(String string) {
        try {
            SysquakeLink.execute(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public synchronized void eval(String string, boolean bl) {
        this.eval(string);
    }

    public void resetIC() {
    }

    public void resetParam() {
    }

    public synchronized void step(double d) {
    }

    public void stepAS(double d) {
    }

    public void stepAS(double d, int n) {
    }

    public synchronized void reset() {
        try {
            SysquakeLink.disconnect();
            SysquakeLink.connect();
            this.loadSQFile();
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public synchronized void quit() {
        try {
            if (this.sqID != -1) {
                SysquakeLink.resetVariableChangeNotification(this.sqID);
            }
            SysquakeLink.disconnect();
            this.sqID = -1;
            SysquakeLink.quit();
            sqlink = null;
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public void setValues(Vector vector, Vector vector2) throws Exception {
        if (this.sqID == -1) {
            return;
        }
        int n = vector.size();
        if (n <= 0) {
            return;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.varTable.get((String)vector.get(i));
            if (n2 != null) {
                nArray[i] = n2;
                continue;
            }
            System.out.println("EjsSysquake Error: Variable " + vector.get(i) + " not found");
            nArray[i] = -1;
        }
        SysquakeLink.setVariableValue(this.sqID, nArray, vector2.toArray());
    }

    public void setValue(String string, String string2) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)string2);
        } else {
            SysquakeLink.execute(string + " = '" + string2 + "';");
        }
    }

    public void setValue(String string, double d) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)new Double(d));
        } else {
            SysquakeLink.execute(string + " = " + d + ";");
        }
    }

    public void setValue(String string, double[] dArray) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)dArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" = [ ");
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Double.toString(dArray[i]));
            }
            stringBuffer.append("];");
            SysquakeLink.execute(stringBuffer.toString());
        }
    }

    public void setValue(String string, double[][] dArray) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)dArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" = [ ");
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(";");
                }
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (j > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(Double.toString(dArray[i][j]));
                }
            }
            stringBuffer.append("];");
            SysquakeLink.execute(stringBuffer.toString());
        }
    }

    public synchronized String getString(String string) throws Exception {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        return (String)object;
    }

    public double getDouble(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        if (object == null) {
            return Double.NaN;
        }
        return (Double)object;
    }

    public synchronized double[] getDoubleArray(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
            if (object instanceof double[][]) {
                return ((double[][])object)[0];
            }
            return (double[])object;
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
            return null;
        }
    }

    public double[][] getDoubleArray2D(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        return (double[][])object;
    }

    public synchronized void update(String string, String string2, int n) {
    }

    public synchronized void update(String string, String string2, int n, int n2) {
    }

    public synchronized void haltUpdate(boolean bl) {
    }

    public synchronized void haltStepAS(boolean bl) {
    }

    public void setValue(String string, double[][] dArray, boolean bl) throws Exception {
        this.setValue(string, dArray);
    }

    public void setValue(String string, double[] dArray, boolean bl) throws Exception {
        this.setValue(string, dArray);
    }

    public synchronized void setValue(String string, String string2, boolean bl) throws Exception {
        this.setValue(string, string2);
    }

    public void setValue(String string, double d, boolean bl) throws Exception {
        this.setValue(string, d);
    }

    public synchronized String getStringAS() throws Exception {
        return null;
    }

    public double getDoubleAS() {
        return 0.0;
    }

    public synchronized void synchronize(boolean bl) {
    }

    public synchronized void synchronize() {
    }

    public synchronized void externalVars(String string) {
    }

    public synchronized void setCommand(String string) {
    }

    public synchronized void packageSize(double d) {
    }

    public synchronized double[] getDoubleArrayAS() {
        return null;
    }

    public double[][] getDoubleArray2DAS() {
        return null;
    }
}

