/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.contrib.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import org.colos.ejs.unpackaged.EjscHotEqn;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlEquation
extends ControlSwingElement {
    private static final int VARIABLE = 0;
    protected EjscHotEqn equation;
    private StringValue internalValue;
    private boolean defaultValueSet;
    private String defaultValue;
    private Color defaultColor;
    private Color editingColor;
    private Color errorColor;
    private static ArrayList infoList = null;
    private static int nparam = 3;

    public ControlEquation(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof EjscHotEqn) {
            this.equation = (EjscHotEqn)((Object)object);
        } else if (this.equation == null) {
            this.equation = new EjscHotEqn("");
        }
        this.equation.setDebug(false);
        this.equation.setEditable(false);
        this.equation.setEquation("");
        this.defaultValue = "";
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.equation.getBackground());
        return this.equation;
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String string) {
        if (this.internalValue.value.equals(string)) {
            return;
        }
        this.internalValue.value = string;
        this.equation.setEquation(this.internalValue.value);
        this.setColor(this.defaultColor);
    }

    private void setInternalValue(String string) {
        this.internalValue.value = string;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("value")) {
            return "String CONSTANT";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.equation.setEditable(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - nparam, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.equation.setEditable(true);
                break;
            }
            default: {
                super.setDefaultValue(n - nparam);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - nparam);
    }

    private void setColor(Color color) {
        if (this.equation.isEditable()) {
            this.getVisual().setBackground(color);
        }
    }

    private void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }
}

