/*
 * Decompiled with CFR 0.152.
 */
package com.calerga.sysquake;

import com.calerga.sysquake.SQLinkConnectionException;
import com.calerga.sysquake.SQLinkInstanceIDException;
import com.calerga.sysquake.SQLinkUnsupportedDataTypeException;
import com.calerga.sysquake.SQLinkVariableException;
import com.calerga.sysquake.SQLinkVariableListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;

public class SysquakeLink
implements Runnable {
    private static boolean initialized = false;
    private static int notificationPort = -1;
    private static VarListeners varListeners = null;
    private static volatile Thread varChangedThread = null;

    public SysquakeLink(String string) {
        if (!initialized && string != null) {
            try {
                System.load(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
                System.err.println("ERROR: Could not load the SysquakeLink library. This error occures if");
                System.err.println("       Sysquake is not installed in the system.");
                System.err.println("       Or if SysquakeLink.dll (for Windows) in the right directory!");
            }
            initialized = true;
        }
    }

    public static native void connect() throws SQLinkConnectionException;

    public static native void disconnect();

    public static native boolean isConnected();

    public static native String version() throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native void execute(String var0) throws SQLinkConnectionException;

    public static native int open(String var0) throws SQLinkConnectionException;

    public static native void reload(int var0) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native void maximize() throws SQLinkConnectionException;

    public static native void minimize() throws SQLinkConnectionException;

    public static native void restoreSize() throws SQLinkConnectionException;

    public static native void show() throws SQLinkConnectionException;

    public static native void quit() throws SQLinkConnectionException;

    public static native String[] variableNames(int var0) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native Object variableValue(int var0, String var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object variableValue(int var0, int var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] variableValue(int var0, String[] var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] variableValue(int var0, int[] var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native void setVariableValue(int var0, String var1, Object var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, int var1, Object var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, String[] var1, Object[] var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, int[] var1, Object[] var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableChangeNotification(int var0, String var1) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native String[] lmeVariableNames() throws SQLinkConnectionException;

    public static native Object lmeVariableValue(String var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object lmeVariableValue(int var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] lmeVariableValue(String[] var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] lmeVariableValue(int[] var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static void setVariableChangeNotification(int n, SQLinkVariableListener sQLinkVariableListener) throws SQLinkConnectionException, SQLinkInstanceIDException {
        if (varChangedThread == null) {
            varListeners = new VarListeners();
            varListeners.add(n, sQLinkVariableListener);
            varChangedThread = new Thread(new SysquakeLink(null));
            varChangedThread.start();
        }
        while (notificationPort < 0) {
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SysquakeLink.setVariableChangeNotification(n, "_fd_varChangedSQLinkNot=socketnew('localhost'," + notificationPort + ",socketset('Proto','udp'));" + "fprintf(_fd_varChangedSQLinkNot,'%d'," + n + ");" + "fclose(_fd_varChangedSQLinkNot);");
    }

    public static void resetVariableChangeNotification(int n) throws SQLinkConnectionException, SQLinkInstanceIDException {
        if (varListeners != null) {
            varListeners.remove(n);
        }
        SysquakeLink.setVariableChangeNotification(n, "");
        if (varListeners != null && varListeners.count() == 0) {
            Thread thread = varChangedThread;
            varChangedThread = null;
            thread.interrupt();
            varListeners = null;
        }
    }

    public void run() {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(100);
            notificationPort = datagramSocket.getLocalPort();
            byte[] byArray = new byte[256];
            while (varChangedThread != null) {
                int n;
                Object object;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                while (varChangedThread != null) {
                    try {
                        datagramSocket.receive(datagramPacket);
                        break;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                    }
                }
                if (varChangedThread == null) break;
                try {
                    object = new String(datagramPacket.getData(), 0, datagramPacket.getLength(), "UTF-8");
                    n = Integer.decode((String)object);
                }
                catch (Exception exception) {
                    n = -1;
                }
                if ((object = varListeners.getListener(n)) == null) continue;
                object.variableChange(n);
            }
            datagramSocket.close();
            notificationPort = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class VarListeners {
        private SQLinkVariableListener[] listeners = null;
        private int[] instanceId = null;
        private int n = 0;

        private VarListeners() {
        }

        public synchronized int count() {
            return this.n;
        }

        public synchronized void add(int n, SQLinkVariableListener sQLinkVariableListener) {
            if (this.instanceId == null) {
                this.listeners = new SQLinkVariableListener[16];
                this.instanceId = new int[16];
            } else if (this.n >= this.instanceId.length) {
                int n2 = this.instanceId.length;
                SQLinkVariableListener[] sQLinkVariableListenerArray = new SQLinkVariableListener[n2 + 16];
                for (int i = 0; i < n2; ++i) {
                    sQLinkVariableListenerArray[i] = this.listeners[i];
                }
                this.listeners = sQLinkVariableListenerArray;
                int[] nArray = new int[n2 + 16];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.instanceId[i];
                }
                this.instanceId = nArray;
            }
            this.instanceId[this.n] = n;
            this.listeners[this.n] = sQLinkVariableListener;
            ++this.n;
        }

        private int findById(int n) {
            if (this.instanceId == null) {
                return -1;
            }
            for (int i = 0; i < this.n; ++i) {
                if (this.instanceId[i] != n) continue;
                return i;
            }
            return -1;
        }

        public synchronized void remove(int n) {
            int n2;
            int n3 = n2 = this.findById(n);
            while (n3 + 1 < this.n) {
                this.instanceId[n3] = this.instanceId[n3 + 1];
                this.listeners[n3] = this.listeners[n3 + 1];
                ++n3;
            }
            --this.n;
        }

        public synchronized SQLinkVariableListener getListener(int n) {
            int n2 = this.findById(n);
            return n2 >= 0 ? this.listeners[n2] : null;
        }
    }
}

