/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.ResourceLoader;

public class EjsTool {
    private static final String INFO_FILE = ".Ejs.txt";
    public static final String GET_MODEL_METHOD = "_getEjsModel";
    public static final String GET_RESOURCES_METHOD = "_getEjsResources";
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String string) {
        try {
            return res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }

    public static boolean hasEjsModel(Class clazz) {
        try {
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod(GET_MODEL_METHOD, classArray);
            return method != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean runEjs(Class clazz) {
        try {
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod(GET_MODEL_METHOD, classArray);
            Method method2 = clazz.getMethod(GET_RESOURCES_METHOD, classArray);
            Object[] objectArray = new Object[]{};
            String string = (String)method.invoke(null, objectArray);
            ArrayList arrayList = method2 != null ? (ArrayList)method2.invoke(null, objectArray) : new ArrayList();
            return EjsTool.doRunEjs(string, arrayList, clazz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String[] stringArray = new String[]{res.getString("EjsTool.EjsNotRunning"), res.getString("EjsTool.NoModel") + " " + clazz.getName()};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("EjsTool.Error"), 2);
            return false;
        }
    }

    public static void saveInformation(String string, String string2) {
        try {
            String string3 = System.getProperty("user.home").replace('\\', '/');
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            string3 = string3 + INFO_FILE;
            String string4 = System.getProperty("user.dir");
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write("directory = " + string4 + "\n");
            fileWriter.write("home = " + string + "\n");
            fileWriter.write("version = " + string2 + "\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean doRunEjs(String string, ArrayList arrayList, Class clazz) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file = null;
        String string2 = "Simulations";
        try {
            object5 = System.getProperty("user.home").replace('\\', '/');
            if (!((String)object5).endsWith("/")) {
                object5 = (String)object5 + "/";
            }
            object5 = (String)object5 + INFO_FILE;
            object4 = null;
            object3 = new FileReader((String)object5);
            if (object3 == null) {
                return false;
            }
            object2 = new LineNumberReader((Reader)object3);
            object = ((LineNumberReader)object2).readLine();
            while (object != null) {
                if (((String)object).startsWith("directory = ")) {
                    object4 = ((String)object).substring("directory = ".length()).trim();
                } else if (((String)object).startsWith("home = ")) {
                    string2 = ((String)object).substring("home = ".length()).trim();
                }
                object = ((LineNumberReader)object2).readLine();
            }
            ((Reader)object3).close();
            file = new File((String)object4);
            if (!new File(file, "EjsConsole.jar").exists()) {
                file = null;
            }
        }
        catch (Exception exception) {
            file = null;
        }
        while (file == null) {
            object5 = new JFileChooser();
            ((JFileChooser)object5).setDialogTitle(res.getString("EjsTool.EjsNotFound"));
            ((JFileChooser)object5).setFileSelectionMode(1);
            ((JFileChooser)object5).setMultiSelectionEnabled(false);
            object4 = new JTextArea(res.getString("EjsTool.IndicateRootDir"));
            ((JTextArea)object4).setWrapStyleWord(true);
            ((JTextArea)object4).setLineWrap(true);
            ((JTextComponent)object4).setEditable(false);
            ((JTextArea)object4).setFont(((Component)object4).getFont().deriveFont(1));
            ((JComponent)object4).setPreferredSize(new Dimension(150, 60));
            ((JComponent)object4).setBackground(((Component)object5).getBackground());
            ((JComponent)object4).setBorder(new EmptyBorder(5, 10, 0, 0));
            ((JFileChooser)object5).setAccessory((JComponent)object4);
            if (((JFileChooser)object5).showOpenDialog(null) != 0) {
                return false;
            }
            file = ((JFileChooser)object5).getSelectedFile();
            if (file == null) {
                return false;
            }
            if (!new File(file, "EjsConsole.jar").exists()) {
                file = null;
            }
            string2 = "Simulations";
        }
        object5 = new File(file, string2);
        if (!((File)object5).exists()) {
            ((File)object5).mkdirs();
        }
        if (!arrayList.contains(string)) {
            arrayList.add(0, string);
        }
        if ((object4 = EjsTool.ejsConfirmList(null, new Dimension(400, 400), res.getString("EjsTool.ExtractingFiles"), res.getString("EjsTool.Message"), arrayList)) == null) {
            return false;
        }
        object3 = null;
        if (ResourceLoader.getResource(string) == null) {
            object3 = clazz.getName().replace('.', '/') + "/files";
            ResourceLoader.addSearchPath((String)object3);
        }
        if (!JarTool.extract((Object)null, (AbstractList)object4, (File)object5)) {
            if (object3 != null) {
                ResourceLoader.removeSearchPath((String)object3);
            }
            return false;
        }
        if (object3 != null) {
            ResourceLoader.removeSearchPath((String)object3);
        }
        object2 = new Runner(file, ((File)object5).getAbsolutePath() + "/" + string);
        object = new Thread((Runnable)object2);
        ((Thread)object).setPriority(5);
        ((Thread)object).start();
        return true;
    }

    public static AbstractList ejsConfirmList(Component component, Dimension dimension, String string, String string2, AbstractList abstractList) {
        class ReturnValue {
            boolean value = false;

            ReturnValue() {
            }
        }
        final ReturnValue returnValue = new ReturnValue();
        final DefaultListModel defaultListModel = new DefaultListModel();
        int n = abstractList.size();
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(abstractList.get(i));
        }
        final JList jList = new JList(defaultListModel);
        jList.setEnabled(true);
        jList.setSelectionMode(2);
        jList.setSelectionInterval(0, defaultListModel.getSize() - 1);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(dimension);
        final JDialog jDialog = new JDialog();
        MouseAdapter mouseAdapter = new MouseAdapter(){
            {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                String string = abstractButton.getActionCommand();
                if (string.equals("ok")) {
                    returnValue.value = true;
                    jDialog.setVisible(false);
                } else if (string.equals("cancel")) {
                    returnValue.value = false;
                    jDialog.setVisible(false);
                } else if (string.equals("selectall")) {
                    jList.setSelectionInterval(0, defaultListModel.getSize() - 1);
                } else if (string.equals("selectnone")) {
                    jList.removeSelectionInterval(0, defaultListModel.getSize() - 1);
                }
            }
        };
        JButton jButton = new JButton(DisplayRes.getString("GUIUtils.Ok"));
        jButton.setActionCommand("ok");
        jButton.addMouseListener(mouseAdapter);
        JButton jButton2 = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
        jButton2.setActionCommand("cancel");
        jButton2.addMouseListener(mouseAdapter);
        JButton jButton3 = new JButton(DisplayRes.getString("GUIUtils.SelectAll"));
        jButton3.setActionCommand("selectall");
        jButton3.addMouseListener(mouseAdapter);
        JButton jButton4 = new JButton(DisplayRes.getString("GUIUtils.SelectNone"));
        jButton4.setActionCommand("selectnone");
        jButton4.addMouseListener(mouseAdapter);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(jTextArea.getFont().deriveFont(1));
        jTextArea.setBackground(jPanel2.getBackground());
        jTextArea.setBorder(new EmptyBorder(5, 5, 10, 5));
        jPanel2.setBorder(new EmptyBorder(5, 10, 5, 10));
        jPanel2.add((Component)jTextArea, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JSeparator jSeparator = new JSeparator(0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jSeparator, "North");
        jPanel3.add((Component)jPanel, "South");
        jDialog.getContentPane().setLayout(new BorderLayout(5, 0));
        jDialog.getContentPane().add((Component)jPanel2, "Center");
        jDialog.getContentPane().add((Component)jPanel3, "South");
        jDialog.addWindowListener(new WindowAdapter(){
            {
            }

            public void windowClosing(WindowEvent windowEvent) {
                returnValue.value = false;
            }
        });
        jDialog.validate();
        jDialog.pack();
        jDialog.setTitle(string2);
        jDialog.setLocationRelativeTo(component);
        jDialog.setModal(true);
        jDialog.setVisible(true);
        if (!returnValue.value) {
            return null;
        }
        Object[] objectArray = jList.getSelectedValues();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            ((AbstractList)arrayList).add(objectArray[i]);
        }
        return arrayList;
    }

    private static class Runner
    implements Runnable {
        File rootDir;
        String model;

        Runner(File file, String string) {
            this.rootDir = file;
            this.model = string;
        }

        public void run() {
            try {
                Vector<String> vector = new Vector<String>();
                String string = System.getProperty("java.home");
                if (string != null) {
                    vector.add(string + File.separator + "bin" + File.separator + "java");
                } else {
                    vector.add("java");
                }
                vector.add("-jar");
                vector.add("EjsConsole.jar");
                if (this.model != null) {
                    vector.add(this.model);
                }
                String[] stringArray = vector.toArray(new String[0]);
                Process process = Runtime.getRuntime().exec(stringArray, null, this.rootDir);
                process.waitFor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

