/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.ode.IRK.AlgebraicEquationSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewtonStep;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.NewtonLastIterationErrorIsTooLarge;
import org.opensourcephysics.ode.IRK.NewtonLostOfConvergence;

public class IRKSimplifiedNewton
extends IRKSimplifiedNewtonStep
implements AlgebraicEquationSolver {
    private int numEqn;
    private static final int maxIterations = 7;
    protected int nIteration = 0;
    private double[][] rightHand;
    private double[] tolerance;
    protected double thetaqOld;
    public double fnewt;
    private double convergenceRateOld = 1.0;
    private double faccon = 1.0;

    public IRKSimplifiedNewton(IRKAlgebraicEquation iRKAlgebraicEquation) {
        super(iRKAlgebraicEquation);
        this.initialize(iRKAlgebraicEquation);
    }

    public IRKSimplifiedNewton(IRKAlgebraicEquation iRKAlgebraicEquation, LAESolverLU lAESolverLU) {
        super(iRKAlgebraicEquation, lAESolverLU);
        this.initialize(iRKAlgebraicEquation);
    }

    private void initialize(IRKAlgebraicEquation iRKAlgebraicEquation) {
        this.numEqn = iRKAlgebraicEquation.getApproximation()[0].length;
        this.rightHand = super.getSubstitutedApproximationIncrement();
        this.tolerance = new double[this.numEqn];
        for (int i = 0; i < this.numEqn; ++i) {
            this.setTolerance(i, 1.0E-6);
        }
    }

    public double resolve() throws NewtonLostOfConvergence, NewtonLastIterationErrorIsTooLarge {
        double d;
        this.nIteration = 0;
        this.faccon = Math.pow(Math.max(this.faccon, this.uround), 0.8);
        double d2 = 0.001;
        do {
            ++this.nIteration;
            double d3 = super.singleStep();
            d = this.estimateIncrementNorm(this.rightHand);
            if (1 < this.nIteration && this.nIteration < 7) {
                d2 = this.nIteration == 2 ? d3 : Math.sqrt(d3 * this.convergenceRateOld);
                this.convergenceRateOld = d3;
                if (d2 > 0.99) {
                    throw new NewtonLostOfConvergence(this.nIteration, d2);
                }
                this.faccon = d2 / (1.0 - d2);
                double d4 = this.predictLastIterationError(d, d2);
                if (d4 > 1.0) {
                    throw new NewtonLastIterationErrorIsTooLarge(this.nIteration, 7, d4);
                }
            }
            super.commitStep();
        } while (!this.convergenceAchieved(d, d2));
        return d2;
    }

    protected double estimateIncrementNorm(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.numEqn; ++i) {
            for (int j = 0; j < 3; ++j) {
                d += Math.pow(dArray[j][i] / this.tolerance[i], 2.0);
            }
        }
        return Math.sqrt(d / (double)(3 * this.numEqn));
    }

    private double predictLastIterationError(double d, double d2) {
        return d2 / (1.0 - d2) * d * Math.pow(d2, 6 - this.nIteration) / this.fnewt;
    }

    private boolean convergenceAchieved(double d, double d2) {
        return this.faccon * d < this.fnewt;
    }

    public double getTolerance(int n) {
        return this.tolerance[n];
    }

    public void setTolerance(int n, double d) {
        this.tolerance[n] = d;
    }
}

