/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.text.DecimalFormat;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public final class Util {
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    public static final double LOG10 = Math.log(10.0);
    public static final double defaultNumericalPrecision = Math.sqrt(Double.MIN_VALUE);
    private static SuryonoParser parser = new SuryonoParser(0);
    static DecimalFormat format2 = new DecimalFormat("#0.00");
    static DecimalFormat format3 = new DecimalFormat("#0.000");
    static DecimalFormat format4 = new DecimalFormat("#0.0000");
    static DecimalFormat format_E2 = new DecimalFormat("0.00E0");
    static DecimalFormat format_E3 = new DecimalFormat("0.000E0");
    static DecimalFormat format_E4 = new DecimalFormat("0.0000E0");

    private Util() {
    }

    public static String f2(double d) {
        return format2.format(d);
    }

    public static String f3(double d) {
        return format3.format(d);
    }

    public static String f4(double d) {
        return format4.format(d);
    }

    public static double relativePrecision(double d, double d2) {
        return d2 > defaultNumericalPrecision ? d / d2 : d;
    }

    public static int checkSorting(double[] dArray) {
        int n = dArray[0] <= dArray[dArray.length - 1] ? 1 : -1;
        int n2 = dArray.length;
        block4: for (int i = 1; i < n2; ++i) {
            switch (n) {
                case -1: {
                    if (!(dArray[i - 1] < dArray[i])) continue block4;
                    return 0;
                }
                case 1: {
                    if (!(dArray[i - 1] > dArray[i])) continue block4;
                    return 0;
                }
            }
        }
        return n;
    }

    public static double[] getRange(Function function, double d, double d2, int n) {
        double d3 = function.evaluate(d);
        double d4 = function.evaluate(d);
        double d5 = d;
        double d6 = (d2 - d) / (double)(n - 1);
        for (int i = 1; i < n; ++i) {
            double d7 = function.evaluate(d5);
            d3 = Math.min(d3, d7);
            d4 = Math.max(d4, d7);
            d5 += d6;
        }
        return new double[]{d3, d4};
    }

    public static double[][] functionFill(Function function, double d, double d2, double[][] dArray) {
        double d3 = 1.0;
        int n = dArray[0].length;
        if (n > 1) {
            d3 = (d2 - d) / (double)(n - 1);
        }
        double d4 = d;
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = d4;
            dArray[1][i] = function.evaluate(d4);
            d4 += d3;
        }
        return dArray;
    }

    public static double[] functionFill(Function function, double d, double d2, double[] dArray) {
        double d3 = 1.0;
        int n = dArray.length;
        if (n > 1) {
            d3 = (d2 - d) / (double)(n - 1);
        }
        double d4 = d;
        for (int i = 0; i < n; ++i) {
            dArray[i] = function.evaluate(d4);
            d4 += d3;
        }
        return dArray;
    }

    public static double computeAverage(double[] dArray, int n, int n2) {
        double d = 0.0;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            d += dArray[i];
        }
        return d / (double)n2;
    }

    public static Function constantFunction(final double d) {
        return new Function(){

            public double evaluate(double d2) {
                return d;
            }
        };
    }

    public static Function linearFunction(final double d, final double d2) {
        return new Function(){

            public double evaluate(double d3) {
                return d * d3 + d2;
            }
        };
    }

    public static Function gaussian(final double d, final double d2) {
        final double d3 = 2.0 * d2 * d2;
        return new Function(){

            public double evaluate(double d4) {
                return Math.exp(-(d4 - d) * (d4 - d) / d3) / d2 / SQRT2PI;
            }
        };
    }

    public static synchronized double evalMath(String string) {
        try {
            parser.parse(string);
            return parser.evaluate();
        }
        catch (ParserException parserException) {
            return Double.NaN;
        }
    }
}

