/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;

class TriggerODE
implements ODE {
    protected ODE ode;
    private int size;
    private double[] odestate;
    private double[] state;

    public TriggerODE(ODE oDE) {
        this.ode = oDE;
        this.odestate = this.ode.getState();
        this.size = this.odestate.length;
        this.state = new double[this.size];
        System.arraycopy(this.odestate, 0, this.state, 0, this.size);
    }

    public void setState(double[] dArray) {
        System.arraycopy(dArray, 0, this.state, 0, this.size);
    }

    public void readRealState() {
        this.odestate = this.ode.getState();
        System.arraycopy(this.odestate, 0, this.state, 0, this.size);
    }

    public void updateRealState() {
        System.arraycopy(this.state, 0, this.odestate, 0, this.size);
    }

    public double[] getState() {
        return this.state;
    }

    public void getRate(double[] dArray, double[] dArray2) {
        this.ode.getRate(dArray, dArray2);
    }
}

