/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.NumericsLog;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.numerics.VectorFunction;

public class Root {
    static final int MAX_ITERATIONS = 15;

    private Root() {
    }

    public static double[] quadraticReal(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = -0.5 * (d2 + (d2 < 0.0 ? -1.0 : 1.0) * Math.sqrt(d2 * d2 - 4.0 * d * d3));
        dArray[0] = d4 / d;
        dArray[1] = d3 / d4;
        return dArray;
    }

    public static double[][] quadratic(double d, double d2, double d3) {
        double[][] dArray = new double[2][2];
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (d4 < 0.0) {
            double d5 = -d2 / 2.0 / d;
            dArray[0][0] = d5;
            dArray[1][0] = d5;
            double[] dArray2 = dArray[1];
            double d6 = Math.sqrt(-d4) / 2.0 / d;
            dArray[0][1] = d6;
            dArray2[1] = dArray2[1] - d6;
            return dArray;
        }
        double d7 = -0.5 * (d2 + (d2 < 0.0 ? -1.0 : 1.0) * Math.sqrt(d4));
        dArray[0][0] = d7 / d;
        dArray[1][0] = d3 / d7;
        return dArray;
    }

    public static double[][] cubic(double d, double d2, double d3, double d4) {
        double[][] dArray = new double[3][2];
        double d5 = d3 / d;
        double d6 = d2 / d;
        double d7 = d6 * d6;
        double d8 = (3.0 * d5 - d7) / 9.0;
        double d9 = d4 / d;
        double d10 = (9.0 * d6 * d5 - 27.0 * d9 - 2.0 * d6 * d7) / 54.0;
        double d11 = d8 * d8 * d8 + d10 * d10;
        if (d11 == 0.0) {
            double d12 = d10 < 0.0 ? -Math.pow(-d10, 0.3333333333333333) : Math.pow(d10, 0.3333333333333333);
            dArray[0][0] = -d6 / 3.0 + 2.0 * d12;
            double d13 = -d6 / 3.0 - d12;
            dArray[1][0] = d13;
            dArray[2][0] = d13;
        } else if (d11 > 0.0) {
            double d14 = d10 + (d11 = Math.sqrt(d11)) < 0.0 ? -Math.pow(-d10 - d11, 0.3333333333333333) : Math.pow(d10 + d11, 0.3333333333333333);
            double d15 = d10 - d11 < 0.0 ? -Math.pow(-d10 + d11, 0.3333333333333333) : Math.pow(d10 - d11, 0.3333333333333333);
            dArray[0][0] = -d6 / 3.0 + d14 + d15;
            double d16 = -d6 / 3.0 - (d14 + d15) / 2.0;
            dArray[1][0] = d16;
            dArray[2][0] = d16;
            double[] dArray2 = dArray[2];
            double d17 = Math.sqrt(3.0) * (d14 - d15) / 2.0;
            dArray[1][1] = d17;
            dArray2[1] = dArray2[1] - d17;
        } else {
            d8 = -d8;
            double d18 = Math.acos(d10 / Math.sqrt(d8 * d8 * d8)) / 3.0;
            d8 = 2.0 * Math.sqrt(d8);
            dArray[0][0] = d8 * Math.cos(d18) - (d6 /= 3.0);
            dArray[1][0] = d8 * Math.cos(d18 + 2.0943951023931953) - d6;
            dArray[2][0] = d8 * Math.cos(d18 + 4.1887902047863905) - d6;
        }
        return dArray;
    }

    public static double newton(Function function, double d, double d2) {
        int n;
        for (n = 0; n < 15; ++n) {
            double d3 = d;
            double d4 = 0.0;
            try {
                d4 = Root.fxprime(function, d, d2);
            }
            catch (NumericMethodException numericMethodException) {
                return Double.NaN;
            }
            d -= function.evaluate(d) / d4;
            if (!(Util.relativePrecision(Math.abs(d - d3), d) < d2)) continue;
            return d;
        }
        NumericsLog.fine(n + " newton root trials made - no convergence achieved");
        return Double.NaN;
    }

    public static double newton(Function function, Function function2, double d, double d2) {
        int n;
        for (n = 0; n < 15; ++n) {
            double d3 = d;
            if (!(Util.relativePrecision(Math.abs((d -= function.evaluate(d) / function2.evaluate(d)) - d3), d) < d2)) continue;
            return d;
        }
        NumericsLog.fine(n + " newton root trials made - no convergence achieved");
        return Double.NaN;
    }

    public static double bisection(Function function, double d, double d2, double d3) {
        int n;
        double d4;
        int n2 = (int)(Math.log(Math.abs(d2 - d) / d3) / Math.log(2.0));
        n2 = Math.max(15, n2) + 2;
        double d5 = function.evaluate(d);
        if (d5 * (d4 = function.evaluate(d2)) > 0.0) {
            NumericsLog.fine(n + " bisection root - interval endpoints must have opposite sign");
            return Double.NaN;
        }
        for (n = 0; n < n2; ++n) {
            double d6 = (d + d2) / 2.0;
            double d7 = function.evaluate(d6);
            if (Util.relativePrecision(Math.abs(d - d2), d6) < d3) {
                return d6;
            }
            if (d7 * d5 > 0.0) {
                d = d6;
                d5 = d7;
                continue;
            }
            d2 = d6;
            d4 = d7;
        }
        NumericsLog.fine(n + " bisection root trials made - no convergence achieved");
        return Double.NaN;
    }

    public static double newtonBisection(Function function, double d, double d2, double d3, int n) {
        double d4;
        double d5;
        double d6;
        double d7 = 10.0 * d3;
        int n2 = 0;
        int n3 = 0;
        double d8 = function.evaluate(d);
        if (d8 * (d6 = function.evaluate(d2)) >= 0.0) {
            n3 = 1;
        }
        switch (n3) {
            case 1: {
                System.out.println("No solution possible");
            }
        }
        if (Math.abs(d8) <= Math.abs(d6)) {
            d5 = d;
            d4 = d8;
        } else {
            d5 = d2;
            d4 = d6;
        }
        double d9 = Root.fxprime(function, d5, d3);
        while (n2 < n && d7 > d3) {
            double d10;
            ++n2;
            if ((d9 * (d5 - d) - d4) * (d9 * (d5 - d2) - d4) <= 0.0) {
                d10 = -d4 / d9;
                d5 += d10;
            } else {
                d10 = (d2 - d) / 2.0;
                d5 = (d + d2) / 2.0;
            }
            d7 = Math.abs(d10 / d5);
            if (d7 <= d3) continue;
            d4 = function.evaluate(d5);
            d9 = Root.fxprime(function, d5, d3);
            if (d8 * d4 <= 0.0) {
                d2 = d5;
                d6 = d4;
                continue;
            }
            d = d5;
            d8 = d4;
        }
        if (n2 > n || d7 > d3) {
            NumericsLog.fine(n + " Newton and bisection trials made - no convergence achieved");
            return Double.NaN;
        }
        return d5;
    }

    public static double newtonMultivar(VectorFunction vectorFunction, double[] dArray, int n, double d) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        int n3 = 0;
        double d2 = 9999.0;
        double d3 = 9999.0;
        while (d2 > d * 1.0E-6 && d3 > d * 1.0E-6 && n3 < n) {
            int n4;
            ++n3;
            LUPDecomposition lUPDecomposition = new LUPDecomposition(Root.getJacobian(vectorFunction, n2, dArray, d / 100.0));
            dArray3 = vectorFunction.evaluate(dArray, dArray3);
            dArray2 = lUPDecomposition.solve(dArray3);
            for (n4 = 0; n4 < n2; ++n4) {
                dArray2[n4] = dArray[n4] - dArray2[n4];
            }
            d2 = (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]);
            d3 = dArray[0] * dArray[0];
            dArray[0] = dArray2[0];
            for (n4 = 1; n4 < n2; ++n4) {
                d2 += (dArray[n4] - dArray2[n4]) * (dArray[n4] - dArray2[n4]);
                d3 += dArray[n4] * dArray[n4];
                dArray[n4] = dArray2[n4];
            }
            d2 = Math.sqrt(d2);
            d3 = d2 / (d3 + d);
        }
        return d2;
    }

    public static double[][] getJacobian(VectorFunction vectorFunction, int n, double[] dArray, double d) {
        int n2;
        int n3;
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        double[][] dArray6 = new double[n][n];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n3][n2] = dArray[n2];
                dArray4[n3][n2] = dArray[n2];
            }
            dArray3[n3][n3] = dArray3[n3][n3] + d;
            dArray4[n3][n3] = dArray4[n3][n3] - d;
        }
        for (n3 = 0; n3 < n; ++n3) {
            dArray5[n3] = vectorFunction.evaluate(dArray3[n3], dArray5[n3]);
            dArray6[n3] = vectorFunction.evaluate(dArray4[n3], dArray6[n3]);
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[n3][n2] = (dArray5[n2][n3] - dArray6[n2][n3]) / d / 2.0;
            }
        }
        return dArray2;
    }

    static final double fxprime(Function function, double d, double d2) {
        double d3 = d2 / 10.0;
        double d4 = (function.evaluate(d + d3) - function.evaluate(d - d3)) / d3 / 2.0;
        return d4;
    }
}

