/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.Verlet;

public class LeapFrog
extends AbstractODESolver {
    private double[] rate;
    private double[] priorState;
    private double[] currentState;

    public LeapFrog(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate = new double[this.numEqn];
        this.priorState = new double[this.numEqn];
        this.currentState = new double[this.numEqn];
        this.estimatePreviousState();
    }

    public void setStepSize(double d) {
        this.initialize(d);
    }

    void estimatePreviousState() {
        double[] dArray;
        double[] dArray2 = dArray = this.ode == null ? null : this.ode.getState();
        if (dArray == null) {
            return;
        }
        System.arraycopy(dArray, 0, this.currentState, 0, dArray.length);
        Verlet verlet = new Verlet(this.ode);
        verlet.setStepSize(-this.stepSize);
        verlet.step();
        System.arraycopy(dArray, 0, this.priorState, 0, dArray.length);
        System.arraycopy(this.currentState, 0, dArray, 0, dArray.length);
        verlet = null;
    }

    public double step() {
        double[] dArray = this.ode.getState();
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        System.arraycopy(dArray, 0, this.currentState, 0, this.numEqn);
        this.ode.getRate(dArray, this.rate);
        double d = this.stepSize * this.stepSize;
        double d2 = 2.0 * this.stepSize;
        for (int i = 0; i < this.numEqn - 1; i += 2) {
            int n = i;
            dArray[n] = dArray[n] + (dArray[i] - this.priorState[i] + d * this.rate[i + 1]);
            dArray[i + 1] = (dArray[i] - this.priorState[i]) / d2 + this.rate[i + 1] * this.stepSize;
        }
        if (this.numEqn % 2 == 1) {
            int n = this.numEqn - 1;
            dArray[n] = dArray[n] + this.stepSize * this.rate[this.numEqn - 1];
        }
        System.arraycopy(this.currentState, 0, this.priorState, 0, this.numEqn);
        return this.stepSize;
    }
}

