/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ArrayLib;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MultiVarFunction;

public class HessianMinimize {
    int Iterations;
    double[][] H;
    double[] xp;
    double[] xm;
    double[] xpp;
    double[] xpm;
    double[] xmp;
    double[] xmm;
    private double rmsd_tmp;
    private double rmsd;
    private double[] xtmp;

    public double minimize(MultiVarFunction multiVarFunction, double[] dArray, int n, double d) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        this.xtmp = new double[n2];
        System.arraycopy(dArray, 0, this.xtmp, 0, n2);
        this.rmsd_tmp = multiVarFunction.evaluate(dArray);
        this.rmsd = 0.0;
        this.crudeGuess(multiVarFunction, dArray);
        this.check_rmsd(multiVarFunction, this.xtmp, dArray, n2);
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = (Math.abs(dArray[i]) + 1.0) / 100000.0;
        }
        double d2 = 9999.0;
        double d3 = 9999.0;
        this.Iterations = 0;
        while (d2 > d * 1.0E-6 && d3 > d * 1.0E-6 && this.Iterations < n) {
            int n3;
            ++this.Iterations;
            LUPDecomposition lUPDecomposition = new LUPDecomposition(this.getHessian(multiVarFunction, dArray, dArray3, dArray4));
            dArray2 = lUPDecomposition.solve(dArray3);
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3] = dArray2[n3] + dArray[n3];
            }
            d2 = (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]);
            d3 = dArray[0] * dArray[0];
            dArray[0] = dArray2[0];
            for (n3 = 1; n3 < n2; ++n3) {
                d2 += (dArray[n3] - dArray2[n3]) * (dArray[n3] - dArray2[n3]);
                d3 += dArray[n3] * dArray[n3];
                dArray[n3] = dArray2[n3];
            }
            d2 = Math.sqrt(d2);
            d3 = d2 / (d3 + d);
        }
        this.check_rmsd(multiVarFunction, this.xtmp, dArray, n2);
        return d2;
    }

    private void allocateArrays(int n) {
        this.H = new double[n][n];
        this.xp = new double[n];
        this.xm = new double[n];
        this.xpp = new double[n];
        this.xpm = new double[n];
        this.xmp = new double[n];
        this.xmm = new double[n];
    }

    void crudeGuess(MultiVarFunction multiVarFunction, double[] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = 5;
        double d = 0.35;
        int n4 = 0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = (Math.abs(dArray[n]) + 1.0) / 1000.0;
        }
        while (n4 < n3) {
            ++n4;
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    if (i == n) {
                        dArray2[n] = dArray[n] + dArray4[n];
                        dArray3[n] = dArray[n] - dArray4[n];
                        continue;
                    }
                    dArray2[i] = dArray[i];
                    dArray3[i] = dArray[i];
                }
                double d2 = multiVarFunction.evaluate(dArray2);
                double d3 = multiVarFunction.evaluate(dArray);
                double d4 = multiVarFunction.evaluate(dArray3);
                dArray[n] = dArray[n] - d * 0.5 * dArray4[n] * (d2 - d4) / (d2 - 2.0 * d3 + d4);
                dArray4[n] = 0.5 * dArray4[n];
            }
        }
    }

    void check_rmsd(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2, int n) {
        if (Double.isNaN(ArrayLib.sum(dArray2))) {
            this.rmsd = this.rmsd_tmp;
            System.arraycopy(dArray, 0, dArray2, 0, n);
        } else {
            this.rmsd = multiVarFunction.evaluate(dArray2);
            if (this.rmsd <= this.rmsd_tmp) {
                this.rmsd_tmp = this.rmsd;
                System.arraycopy(dArray2, 0, dArray, 0, n);
            } else {
                this.rmsd = this.rmsd_tmp;
                System.arraycopy(dArray, 0, dArray2, 0, n);
            }
        }
    }

    public int getIterations() {
        return this.Iterations;
    }

    public double[][] getHessian(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        int n3 = dArray.length;
        if (this.xp == null || this.xp.length != n3) {
            this.allocateArrays(n3);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2; n < n3; ++n) {
                int n4;
                if (n2 == n) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.xp[n4] = dArray[n4];
                        this.xm[n4] = dArray[n4];
                    }
                    this.xp[n2] = dArray[n2] + dArray3[n2];
                    this.xm[n2] = dArray[n2] - dArray3[n2];
                    this.H[n2][n2] = (multiVarFunction.evaluate(this.xp) - 2.0 * multiVarFunction.evaluate(dArray) + multiVarFunction.evaluate(this.xm)) / (dArray3[n2] * dArray3[n2]);
                    continue;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    this.xpp[n4] = dArray[n4];
                    this.xpm[n4] = dArray[n4];
                    this.xmp[n4] = dArray[n4];
                    this.xmm[n4] = dArray[n4];
                }
                this.xpp[n2] = dArray[n2] + dArray3[n2];
                this.xpp[n] = dArray[n] + dArray3[n];
                this.xpm[n2] = dArray[n2] + dArray3[n2];
                this.xpm[n] = dArray[n] - dArray3[n];
                this.xmp[n2] = dArray[n2] - dArray3[n2];
                this.xmp[n] = dArray[n] + dArray3[n];
                this.xmm[n2] = dArray[n2] - dArray3[n2];
                this.xmm[n] = dArray[n] - dArray3[n];
                this.H[n2][n] = ((multiVarFunction.evaluate(this.xpp) - multiVarFunction.evaluate(this.xpm)) / (2.0 * dArray3[n]) - (multiVarFunction.evaluate(this.xmp) - multiVarFunction.evaluate(this.xmm)) / (2.0 * dArray3[n])) / (2.0 * dArray3[n2]);
                this.H[n][n2] = this.H[n2][n];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.xp[n] = dArray[n];
                this.xm[n] = dArray[n];
            }
            this.xp[n2] = dArray[n2] + dArray3[n2];
            this.xm[n2] = dArray[n2] - dArray3[n2];
            dArray2[n2] = -(multiVarFunction.evaluate(this.xp) - multiVarFunction.evaluate(this.xm)) / (2.0 * dArray3[n2]);
        }
        return this.H;
    }
}

