/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.FFT;

public class FFT2D {
    static final double PI2 = Math.PI * 2;
    int nrows;
    int ncols;
    FFT rowFFT;
    FFT colFFT;
    double[] acol;
    double[] ccol;

    public FFT2D(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("The array dimensions >=0 : " + n + "," + n2);
        }
        this.nrows = n;
        this.ncols = n2;
        this.acol = new double[2 * n];
        if (n % 2 == 1) {
            this.ccol = new double[2 * n];
        }
        this.rowFFT = new FFT(n2);
        this.colFFT = n == n2 ? this.rowFFT : new FFT(n);
    }

    protected void checkData(double[] dArray, int n) {
        if (n < 2 * this.ncols) {
            throw new IllegalArgumentException("The row span " + n + "is shorter than the row length " + 2 * this.ncols);
        }
        if (this.nrows * n > dArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + n + " data.length=" + dArray.length);
        }
    }

    public void transform(double[] dArray) {
        this.transform_internal(dArray, 2 * this.ncols);
    }

    void transform_internal(double[] dArray, int n) {
        int n2;
        this.checkData(dArray, n);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.transform_internal(dArray, n2 * n, 2, -1);
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.transform_internal(dArray, 2 * n2, n, -1);
        }
    }

    public void backtransform(double[] dArray) {
        this.backtransform_internal(dArray, 2 * this.ncols);
    }

    void backtransform_internal(double[] dArray, int n) {
        int n2;
        this.checkData(dArray, n);
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.colFFT.transform_internal(dArray, 2 * n2, n, 1);
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.rowFFT.transform_internal(dArray, n2 * n, 2, 1);
        }
    }

    public void inverse(double[] dArray) {
        this.inverse_internal(dArray, 2 * this.ncols);
    }

    void inverse_internal(double[] dArray, int n) {
        this.backtransform_internal(dArray, n);
        double d = 1.0 / ((double)this.nrows * (double)this.ncols);
        int n2 = 0;
        while (n2 < this.nrows) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * d;
        }
    }

    double[] getNaturalFreq(double d, int n) {
        double[] dArray = new double[n];
        double d2 = -0.5 / d;
        double d3 = -2.0 * d2 / (double)(n - n % 2);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d2;
            d2 += d3;
        }
        return dArray;
    }

    public double getFreqMin(double d, double d2, int n) {
        return (double)(-(n / 2)) / (d2 - d);
    }

    public double getFreqMax(double d, double d2, int n) {
        return (double)((n + 1) / 2 - 1) / (d2 - d);
    }

    public double[] getNaturalModes(int n) {
        double[] dArray = new double[n];
        double d = -(n - n % 2) / 2;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
            d += 1.0;
        }
        return dArray;
    }

    public double[] getWrappedModes(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = i < (n + 1) / 2 ? (double)i : (double)(i - n);
        }
        return dArray;
    }

    public double[] getWrappedOmegaX(double d, double d2) {
        return this.getWrappedFreq((d2 - d) / (double)(this.nrows - this.nrows % 2) / (Math.PI * 2), this.nrows);
    }

    public double[] getWrappedOmegaY(double d, double d2) {
        return this.getWrappedFreq((d2 - d) / (double)(this.ncols - this.ncols % 2) / (Math.PI * 2), this.ncols);
    }

    public double[] getWrappedFreq(double d, int n) {
        double[] dArray = new double[n];
        double d2 = -0.5 / d;
        double d3 = -2.0 * d2 / (double)(n - n % 2);
        for (int i = 0; i < n; ++i) {
            dArray[i] = i < (n + 1) / 2 ? (double)i * d3 : (double)(i - n) * d3;
        }
        return dArray;
    }

    public double[] getNaturalFreqX(double d) {
        return this.getNaturalFreq(d, this.nrows);
    }

    public double[] getNaturalFreqX(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.nrows - this.nrows % 2), this.nrows);
    }

    public double[] getNaturalOmegaX(double d) {
        return this.getNaturalFreq(d / (Math.PI * 2), this.nrows);
    }

    public double[] getNaturalOmegaX(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.nrows - this.nrows % 2) / (Math.PI * 2), this.nrows);
    }

    public double[] getNaturalFreqY(double d) {
        return this.getNaturalFreq(d, this.ncols);
    }

    public double[] getNaturalFreqY(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.ncols - this.ncols % 2), this.ncols);
    }

    public double[] getNaturalOmegaY(double d) {
        return this.getNaturalFreq(d / (Math.PI * 2), this.ncols);
    }

    public double[] getNaturalOmegaY(double d, double d2) {
        return this.getNaturalFreq((d2 - d) / (double)(this.ncols - this.ncols % 2) / (Math.PI * 2), this.ncols);
    }

    public void toNaturalOrder(double[] dArray) {
        int n;
        int n2;
        int n3;
        if (this.ccol != null) {
            System.arraycopy(dArray, this.ncols / 2 * this.acol.length, this.ccol, 0, this.ccol.length);
        }
        for (n3 = 0; n3 < this.ncols / 2; ++n3) {
            n2 = n3 * this.acol.length;
            System.arraycopy(dArray, n2, this.acol, 0, this.acol.length);
            System.arraycopy(dArray, (this.ncols / 2 + n3 + this.ncols % 2) * this.acol.length, dArray, n2, this.acol.length);
            System.arraycopy(this.acol, 0, dArray, (this.ncols / 2 + n3) * this.acol.length, this.acol.length);
        }
        if (this.ccol != null) {
            System.arraycopy(this.ccol, 0, dArray, dArray.length - this.ccol.length, this.ccol.length);
        }
        for (n3 = 0; n3 < this.ncols; ++n3) {
            n2 = this.acol.length / 2;
            n = n3 * this.acol.length;
            System.arraycopy(dArray, n, this.acol, 0, this.acol.length);
            System.arraycopy(this.acol, n2 + n2 % 2, dArray, n, n2 - n2 % 2);
            System.arraycopy(this.acol, 0, dArray, n + n2 - n2 % 2, n2 + n2 % 2);
        }
        double d = 1.0 / ((double)this.nrows * (double)this.ncols);
        n = 0;
        int n4 = dArray.length;
        while (n < n4) {
            int n5 = n++;
            dArray[n5] = dArray[n5] * d;
        }
    }
}

