/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class EulerRichardson
extends AbstractODESolver {
    private double[] rate;
    private double[] midstate;

    public EulerRichardson(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate = new double[this.numEqn];
        this.midstate = new double[this.numEqn];
    }

    public double step() {
        int n;
        double[] dArray = this.ode.getState();
        this.ode.getRate(dArray, this.rate);
        double d = this.stepSize / 2.0;
        for (n = 0; n < this.numEqn; ++n) {
            this.midstate[n] = dArray[n] + this.rate[n] * d;
        }
        this.ode.getRate(this.midstate, this.rate);
        for (n = 0; n < this.numEqn; ++n) {
            dArray[n] = dArray[n] + this.stepSize * this.rate[n];
        }
        return this.stepSize;
    }
}

