/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODESolverException;

public class DormandPrince45
implements ODEAdaptiveSolver {
    int error_code = 0;
    static final double[][] a = new double[][]{{0.2}, {0.075, 0.225}, {0.3, -0.9, 1.2}, {0.3100137174211248, -0.9259259259259259, 1.2071330589849107, 0.07544581618655692}, {-0.6703703703703704, 2.5, -0.8956228956228957, -3.3703703703703702, 3.4363636363636365}};
    static final double[] b5 = new double[]{0.08796296296296297, 0.0, 0.481000481000481, -0.5787037037037037, 0.9204545454545454, 0.08928571428571429};
    static final double[] er = new double[]{-0.030555555555555555, 0.0, 0.15873015873015872, -0.7638888888888888, 0.675, -0.039285714285714285};
    static final int numStages = 6;
    private volatile double stepSize = 0.01;
    private int numEqn = 0;
    private double[] temp_state;
    private double[][] k;
    private double truncErr;
    private ODE ode;
    protected double tol = 1.0E-6;
    protected boolean enableExceptions = false;

    public DormandPrince45(ODE oDE) {
        this.ode = oDE;
        this.initialize(this.stepSize);
    }

    public void initialize(double d) {
        this.stepSize = d;
        double[] dArray = this.ode.getState();
        if (dArray == null) {
            return;
        }
        if (this.numEqn != dArray.length) {
            this.numEqn = dArray.length;
            this.temp_state = new double[this.numEqn];
            this.k = new double[6][this.numEqn];
        }
    }

    public double step() {
        int n;
        this.error_code = 0;
        int n2 = 10;
        double d = this.stepSize;
        double d2 = 0.0;
        double[] dArray = this.ode.getState();
        this.ode.getRate(dArray, this.k[0]);
        do {
            double d3;
            int n3;
            --n2;
            d = this.stepSize;
            for (n3 = 1; n3 < 6; ++n3) {
                for (n = 0; n < this.numEqn; ++n) {
                    this.temp_state[n] = dArray[n];
                    for (int i = 0; i < n3; ++i) {
                        this.temp_state[n] = this.temp_state[n] + this.stepSize * a[n3 - 1][i] * this.k[i][n];
                    }
                }
                this.ode.getRate(this.temp_state, this.k[n3]);
            }
            d2 = 0.0;
            for (n3 = 0; n3 < this.numEqn; ++n3) {
                this.truncErr = 0.0;
                for (n = 0; n < 6; ++n) {
                    this.truncErr += this.stepSize * er[n] * this.k[n][n3];
                }
                d2 = Math.max(d2, Math.abs(this.truncErr));
            }
            if (d2 <= (double)1.4E-45f) {
                d2 = this.tol / 100000.0;
            }
            if (d2 > this.tol) {
                double d4 = 0.9 * Math.pow(d2 / this.tol, -0.25);
                this.stepSize *= Math.max(d4, 0.1);
                continue;
            }
            if (!(d2 < this.tol / 10.0) || !((d3 = 0.9 * Math.pow(d2 / this.tol, -0.2)) > 1.0)) continue;
            this.stepSize *= Math.min(d3, 10.0);
        } while (d2 > this.tol && n2 > 0);
        for (int i = 0; i < this.numEqn; ++i) {
            for (n = 0; n < 6; ++n) {
                int n4 = i;
                dArray[n4] = dArray[n4] + d * b5[n] * this.k[n][i];
            }
        }
        if (n2 == 0) {
            this.error_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException("DormanPrince45 ODE solver did not converge.");
            }
        }
        return d;
    }

    public void enableRuntimeExpecptions(boolean bl) {
        this.enableExceptions = bl;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setTolerance(double d) {
        this.tol = Math.abs(d);
        if (this.tol < 1.0E-12) {
            String string = "Error: Dormand-Prince ODE solver tolerance cannot be smaller than 1.0e-12.";
            if (this.enableExceptions) {
                throw new ODESolverException(string);
            }
            System.err.println(string);
            this.tol = 1.0E-12;
        }
    }

    public double getTolerance() {
        return this.tol;
    }

    public int getErrorCode() {
        return this.error_code;
    }
}

