/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoAdapter
implements Video,
PropertyChangeListener {
    protected Image rawImage;
    protected Dimension size;
    protected BufferedImage bufferedImage;
    protected BufferedImage filteredImage;
    protected int frameCount;
    protected int frameNumber;
    protected int startFrameNumber;
    protected int endFrameNumber;
    protected double rate = 1.0;
    protected boolean playing = false;
    protected boolean looping = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean mouseEnabled = false;
    protected boolean visible = true;
    protected boolean isMeasured = false;
    protected boolean isValidMeasure = false;
    protected boolean widthDominates = true;
    protected boolean isValidImage = false;
    protected boolean isValidFilteredImage = false;
    protected ImageCoordSystem coords;
    protected DoubleArray aspects;
    protected PropertyChangeSupport support;
    protected HashMap properties = new HashMap();
    protected FilterStack filterStack = new FilterStack();

    protected VideoAdapter() {
        this.initialize();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (drawingPanel instanceof VideoPanel && ((VideoPanel)drawingPanel).isDrawingInImageSpace() || this.isMeasured) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(drawingPanel.getPixelTransform());
            if (drawingPanel instanceof VideoPanel) {
                VideoPanel videoPanel = (VideoPanel)drawingPanel;
                if (!videoPanel.isDrawingInImageSpace()) {
                    ImageCoordSystem imageCoordSystem = videoPanel.getCoords();
                    graphics2D.transform(imageCoordSystem.getToWorldTransform(this.frameNumber));
                }
            } else {
                graphics2D.transform(this.coords.getToWorldTransform(this.frameNumber));
            }
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                graphics2D.drawImage(this.rawImage, 0, 0, drawingPanel);
            } else {
                graphics2D.drawImage((Image)this.getImage(), 0, 0, drawingPanel);
            }
            graphics2D.setTransform(affineTransform);
        } else {
            double d = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
            double d2 = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
            int n = drawingPanel.xToPix(d) - this.size.width / 2;
            int n2 = drawingPanel.yToPix(d2) - this.size.height / 2;
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                graphics2D.drawImage(this.rawImage, n, n2, drawingPanel);
            } else {
                graphics2D.drawImage((Image)this.getImage(), n, n2, drawingPanel);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.firePropertyChange("videoVisible", null, new Boolean(bl));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public double getXMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minX;
    }

    public double getXMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxX;
    }

    public double getYMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minY;
    }

    public double getYMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxY;
    }

    public boolean isMeasured() {
        return this.isMeasured;
    }

    public BufferedImage getImage() {
        if (!this.isValidImage) {
            this.isValidImage = true;
            Graphics2D graphics2D = this.bufferedImage.createGraphics();
            graphics2D.drawImage(this.rawImage, 0, 0, null);
        }
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
        }
        return this.filteredImage;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.mouseEnabled) {
            return null;
        }
        return this;
    }

    public void setEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    public boolean isEnabled() {
        return this.mouseEnabled;
    }

    public void setFrameX(int n, double d) {
        this.setFrameXY(n, d, this.coords.imageToWorldY(n, 0.0, 0.0));
    }

    public void setX(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameX(i, d);
        }
    }

    public void setFrameY(int n, double d) {
        this.setFrameXY(n, this.coords.imageToWorldX(n, 0.0, 0.0), d);
    }

    public void setY(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameY(i, d);
        }
    }

    public double getX() {
        return this.coords.imageToWorldX(this.frameNumber, 0.0, 0.0);
    }

    public double getY() {
        return this.coords.imageToWorldY(this.frameNumber, 0.0, 0.0);
    }

    public void setFrameXY(int n, double d, double d2) {
        double d3 = this.coords.getSine(n);
        double d4 = this.coords.getCosine(n);
        double d5 = this.coords.getScaleX(n) * (d2 * d3 - d * d4);
        double d6 = this.coords.getScaleY(n) * (d2 * d4 + d * d3);
        this.coords.setOriginXY(n, d5, d6);
    }

    public void setXY(double d, double d2) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameXY(i, d, d2);
        }
    }

    public void setFrameRelativeAspect(int n, double d) {
        if (d < 0.001 || d > 1000.0) {
            return;
        }
        this.aspects.set(n, Math.abs(d));
        if (this.isMeasured) {
            if (this.widthDominates) {
                this.setFrameWidth(n, (double)this.size.width / this.coords.getScaleX(n));
            } else {
                this.setFrameHeight(n, (double)this.size.height / this.coords.getScaleY(n));
            }
        }
    }

    public void setRelativeAspect(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameRelativeAspect(i, d);
        }
    }

    public double getRelativeAspect() {
        return this.aspects.get(this.frameNumber);
    }

    public void setFrameWidth(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.width / d;
        this.coords.setScaleX(n, d4);
        this.coords.setScaleY(n, d4 * this.aspects.get(n));
        this.widthDominates = true;
        this.setFrameXY(n, d2, d3);
    }

    public void setWidth(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameWidth(i, d);
        }
    }

    public double getWidth() {
        return (double)this.size.width / this.coords.getScaleX(this.frameNumber);
    }

    public void setFrameHeight(int n, double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = (double)this.size.height / d;
        this.coords.setScaleY(n, d4);
        this.coords.setScaleX(n, d4 / this.aspects.get(n));
        this.widthDominates = false;
        this.setFrameXY(n, d2, d3);
    }

    public void setHeight(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameHeight(i, d);
        }
    }

    public double getHeight() {
        return (double)this.size.height / this.coords.getScaleY(this.frameNumber);
    }

    public void setFrameAngle(int n, double d) {
        double d2 = this.coords.imageToWorldX(n, 0.0, 0.0);
        double d3 = this.coords.imageToWorldY(n, 0.0, 0.0);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        this.coords.setCosineSine(n, d4, -d5);
        this.setFrameXY(n, d2, d3);
    }

    public void setAngle(double d) {
        for (int i = 0; i < this.frameCount; ++i) {
            this.setFrameAngle(i, d);
        }
    }

    public double getAngle() {
        return -this.coords.getAngle(this.frameNumber);
    }

    public void step() {
        this.stop();
        this.setFrameNumber(this.frameNumber + 1);
    }

    public void back() {
        this.stop();
        this.setFrameNumber(this.frameNumber - 1);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        n = Math.min(n, this.endFrameNumber);
        this.frameNumber = n = Math.max(n, this.startFrameNumber);
    }

    public int getStartFrameNumber() {
        return this.startFrameNumber;
    }

    public void setStartFrameNumber(int n) {
        if (n == this.startFrameNumber) {
            return;
        }
        n = Math.max(0, n);
        this.startFrameNumber = Math.min(this.endFrameNumber, n);
        this.firePropertyChange("startframe", null, new Integer(this.startFrameNumber));
    }

    public int getEndFrameNumber() {
        return this.endFrameNumber;
    }

    public void setEndFrameNumber(int n) {
        if (n == this.endFrameNumber) {
            return;
        }
        if (this.frameCount > 1) {
            n = Math.min(this.frameCount - 1, n);
        }
        this.endFrameNumber = Math.max(this.startFrameNumber, n);
        this.firePropertyChange("endframe", null, new Integer(this.endFrameNumber));
    }

    public double getFrameTime(int n) {
        return -1.0;
    }

    public double getFrameDuration(int n) {
        if (this.frameCount == 1) {
            return this.getDuration();
        }
        if (n == this.frameCount - 1) {
            return this.getDuration() - this.getFrameTime(n);
        }
        return this.getFrameTime(n + 1) - this.getFrameTime(n);
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        this.playing = false;
    }

    public void reset() {
        this.stop();
        this.setFrameNumber(this.startFrameNumber);
    }

    public double getTime() {
        return -1.0;
    }

    public void setTime(double d) {
    }

    public double getStartTime() {
        return -1.0;
    }

    public void setStartTime(double d) {
    }

    public double getEndTime() {
        return -1.0;
    }

    public void setEndTime(double d) {
    }

    public double getDuration() {
        return -1.0;
    }

    public void goToStart() {
        this.setFrameNumber(this.startFrameNumber);
    }

    public void goToEnd() {
        this.setFrameNumber(this.endFrameNumber);
    }

    public void setPlaying(boolean bl) {
        if (bl) {
            this.play();
        } else {
            this.stop();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setLooping(boolean bl) {
        if (this.looping == bl) {
            return;
        }
        this.looping = bl;
        this.firePropertyChange("looping", null, new Boolean(this.looping));
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setRate(double d) {
        if ((d = Math.abs(d)) == this.rate || d == 0.0) {
            return;
        }
        this.rate = d;
    }

    public double getRate() {
        return this.rate;
    }

    public void setCoords(ImageCoordSystem imageCoordSystem) {
        if (imageCoordSystem == this.coords) {
            return;
        }
        this.coords.removePropertyChangeListener(this);
        imageCoordSystem.addPropertyChangeListener(this);
        this.coords = imageCoordSystem;
        this.isMeasured = true;
        this.isValidMeasure = false;
        this.firePropertyChange("coords", null, imageCoordSystem);
    }

    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    public void setFilterStack(FilterStack filterStack) {
        this.filterStack.removePropertyChangeListener(this);
        this.filterStack = filterStack;
        this.filterStack.addPropertyChangeListener(this);
    }

    public FilterStack getFilterStack() {
        return this.filterStack;
    }

    public void setProperty(String string, Object object) {
        if (string.equals("measure")) {
            this.isValidMeasure = false;
        } else {
            this.properties.put(string, object);
        }
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Collection getPropertyNames() {
        return this.properties.keySet();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void dispose() {
        this.coords.removePropertyChangeListener(this);
        this.getFilterStack().setInspectorsVisible(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.coords) {
            this.isMeasured = true;
            this.isValidMeasure = false;
        } else if (propertyChangeEvent.getSource() == this.filterStack) {
            this.isValidFilteredImage = false;
            this.support.firePropertyChange(propertyChangeEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    protected void finalize() {
        this.dispose();
    }

    protected void initialize() {
        this.support = new SwingPropertyChangeSupport(this);
        this.filterStack.addPropertyChangeListener(this);
    }

    protected void findMinMaxValues() {
        VideoClip videoClip = (VideoClip)this.getProperty("videoclip");
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        int n = 0;
        if (videoClip != null) {
            n = videoClip.getStartFrameNumber();
        }
        AffineTransform affineTransform = this.coords.getToWorldTransform(n);
        affineTransform.transform(double_, double_);
        this.maxX = this.minX = ((Point2D)double_).getX();
        this.maxY = this.minY = ((Point2D)double_).getY();
        int n2 = this.frameCount;
        if (videoClip != null) {
            n2 = videoClip.getStepCount();
        }
        for (int i = 0; i < n2; ++i) {
            affineTransform = videoClip == null ? this.coords.getToWorldTransform(i) : this.coords.getToWorldTransform(videoClip.stepToFrame(i));
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        ((Point2D)double_).setLocation(0.0, 0.0);
                        break;
                    }
                    case 1: {
                        ((Point2D)double_).setLocation(this.size.width, 0.0);
                        break;
                    }
                    case 2: {
                        ((Point2D)double_).setLocation(0.0, this.size.height);
                        break;
                    }
                    case 3: {
                        ((Point2D)double_).setLocation(this.size.width, this.size.height);
                    }
                }
                affineTransform.transform(double_, double_);
                this.minX = Math.min(((Point2D)double_).getX(), this.minX);
                this.maxX = Math.max(((Point2D)double_).getX(), this.maxX);
                this.minY = Math.min(((Point2D)double_).getY(), this.minY);
                this.maxY = Math.max(((Point2D)double_).getY(), this.maxY);
            }
        }
        this.isValidMeasure = true;
    }
}

