/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

public class DoubleArray {
    private double[] map;
    private int length;

    public DoubleArray(int n, double d) {
        this.length = n;
        this.map = new double[this.length];
        this.fill(d, 0);
    }

    public double get(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return this.map[n];
    }

    public void set(int n, double d) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.map[n] = d;
    }

    public void setLength(int n) {
        if (n == this.length || n < 1) {
            return;
        }
        double[] dArray = new double[n];
        System.arraycopy(this.map, 0, dArray, 0, Math.min(n, this.length));
        this.map = dArray;
        if (n > this.length) {
            double d = this.map[this.length - 1];
            int n2 = this.length;
            this.length = n;
            this.fill(d, n2);
        } else {
            this.length = n;
        }
    }

    public void fill(double d) {
        for (int i = this.length - 1; i >= 0; --i) {
            this.map[i] = d;
        }
    }

    private void fill(double d, int n) {
        for (int i = n; i < this.length; ++i) {
            this.map[i] = d;
        }
    }
}

