/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.frames.TableData;

public class TableFrame
extends DataTableFrame {
    TableData tableData = new TableData();

    public TableFrame(String string) {
        super(string, new DataTable());
        this.setAnimated(true);
        this.setAutoclear(true);
        this.table.setModel(this.tableData);
        this.table.add(this.tableData);
        this.setRowNumberVisible(true);
    }

    public void setRefreshDelay(int n) {
        this.table.setRefreshDelay(n);
    }

    public void setColumnVisible(int n, boolean bl) {
        this.table.setColumnVisible(this.tableData, n, bl);
        this.tableData.setColumnVisible(n, bl);
    }

    public void setRowNumberVisible(boolean bl) {
        this.table.setRowNumberVisible(bl);
        this.tableData.setRowNumberVisible(bl);
    }

    public synchronized void appendArray(Object object) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("");
        }
        Class<?> clazz = object.getClass().getComponentType();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName();
        if (string.equals("double")) {
            double[][] dArray = (double[][])object;
            double[] dArray2 = new double[dArray.length];
            int n = dArray[0].length;
            for (int i = 0; i < n; ++i) {
                int n2 = dArray2.length;
                for (int j = 0; j < n2; ++j) {
                    dArray2[j] = dArray[j][i];
                }
                this.appendRow(dArray2);
            }
        } else if (string.equals("int")) {
            int[][] nArray = (int[][])object;
            int[] nArray2 = new int[nArray.length];
            int n = nArray[0].length;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray2.length;
                for (int j = 0; j < n3; ++j) {
                    nArray2[j] = nArray[j][i];
                }
                this.appendRow(nArray2);
            }
        } else if (string.equals("byte")) {
            byte[][] byArray = (byte[][])object;
            byte[] byArray2 = new byte[byArray.length];
            int n = byArray[0].length;
            for (int i = 0; i < n; ++i) {
                int n4 = byArray2.length;
                for (int j = 0; j < n4; ++j) {
                    byArray2[j] = byArray[j][i];
                }
                this.appendRow(byArray2);
            }
        } else {
            Object[][] objectArray = (Object[][])object;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = objectArray[0].length;
            for (int i = 0; i < n; ++i) {
                int n5 = objectArray2.length;
                for (int j = 0; j < n5; ++j) {
                    objectArray2[j] = objectArray[j][i];
                }
                this.appendRow(objectArray2);
            }
        }
    }

    public synchronized void appendRow(double[] dArray) {
        this.tableData.appendDoubles(dArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(int[] nArray) {
        this.tableData.appendInts(nArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(Object[] objectArray) {
        this.tableData.appendRow(objectArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(byte[] byArray) {
        this.tableData.appendBytes(byArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public void setColumnNames(int n, String string) {
        this.tableData.setColumnNames(n, string);
    }

    public void setColumnFormat(int n, String string) {
        this.tableData.setColumnFormat(n, string);
    }

    public void setMaxPoints(int n) {
        this.tableData.setMaxPoints(n);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.table.refreshTable();
        }
        super.setVisible(bl);
    }

    public synchronized void clearData() {
        this.tableData.rowList.clear();
        this.tableData.colCount = 0;
    }
}

